<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\{Information, User, PopularCategory, Category};
use Illuminate\Http\Request;
use App\Utils\Util;
use Auth, Validator;

class InformationController extends Controller
{
    public function index()
    {
        $information = Information::orderBy('id', 'desc')->first();
        return view('backend.informations.index', compact('information'));
    }

    public function colors()
    {
        $information = Information::orderBy('id', 'desc')->first();
        return view('backend.informations.style', compact('information'));
    }

    // ✅✅✅ NEW: Invoice Design Index Page View
    public function invoiceDesign()
    {
        $info = Information::first();
        // Ensure this view exists: resources/views/backend/informations/invoice_design.blade.php
        return view('backend.informations.invoice_design', compact('info'));
    }

    // ✅✅✅ NEW: Update Invoice Type
    public function updateInvoiceType(Request $request)
    {
        $request->validate([
            'type' => 'required|integer|in:1,2,3,4' // Validating for types 1, 2, 3, 4
        ]);

        $info = Information::first();
        if ($info) {
            $info->invoice_type = $request->type;
            $info->save();
            return back()->with('success', 'Invoice Design Updated Successfully!');
        }

        return back()->with('error', 'Information settings not found!');
    }

    public function styleUpdate(Request $request, $id)
    {
        $data = $request->validate([
            'primary_color'       => 'nullable',
            'primary_background'  => 'nullable',
            'primary_background2' => 'nullable',
            'primary_background3' => 'nullable',
            'gradient_code'       => 'nullable',

            'footer_bg1' => 'nullable',
            'footer_bg2' => 'nullable',
            'footer_bg3' => 'nullable',

            'footer_text' => 'nullable',
            'footer_link_hover' => 'nullable',
            'footer_subtitle' => 'nullable',

            'footer_border_grad1' => 'nullable',
            'footer_border_grad2' => 'nullable',

            'footer_pill_bg' => 'nullable',
            'footer_pill_border' => 'nullable',
            'footer_pill_hover_bg' => 'nullable',
            'footer_pill_hover_text' => 'nullable',

            'footer_underline' => 'nullable',

            'footer_social_border' => 'nullable',
            'footer_social_bg' => 'nullable',
            'footer_social_hover_bg' => 'nullable',
            'footer_social_hover_text' => 'nullable',

            'mnav_bg' => 'nullable',
            'mnav_border' => 'nullable',
            'mnav_icon' => 'nullable',

            'mnav_home_bg' => 'nullable',
            'mnav_home_border' => 'nullable',
            'mnav_home_icon' => 'nullable',

            'footer_bg_color'     => 'nullable',
            'footer_text_color'   => 'nullable',
            'footer_accent_color' => 'nullable',
        ]);

        $information = Information::orderBy('id', 'desc')->firstOrFail();

        if (empty($data['gradient_code'] ?? null)) unset($data['gradient_code']);

        $information->update($data);

        return back()->with(['msg' => 'Style settings has been updated']);
    }

    public function update(Request $request, $id)
    {
        $data = $request->validate([
            'site_name'    => ['required'],
            'site_logo'    => ['max:2048'],
            'footer_logo'  => ['max:2048'],
            'fav_icon'     => ['max:2048'],

            'owner_phone'  => ['required'],
            'owner_email'  => ['required'],
            'address'      => ['required'],
            'copyright'    => ['required'],

            'topbar_notice' => 'nullable',
            'topbar_active' => 'nullable',

            'facebook'      => 'nullable',
            'instagram'     => 'nullable',
            'tiktok'        => 'nullable',
            'twitter'       => 'nullable',
            'youtube'       => 'nullable',

            'tracking_code' => 'nullable',

            'recommend_num' => 'nullable',
            'discount_num'  => 'nullable',
            'newarrival_num' => 'nullable',

            'bkash' => 'nullable',
            'bkash_number' => 'nullable',
            'nogod' => 'nullable',
            'nogod_number' => 'nullable',
            'rocket' => 'nullable',
            'rocket_number' => 'nullable',
            'paypal' => 'nullable',
            'paypal_account' => 'nullable',
            'stripe' => 'nullable',
            'stripe_account' => 'nullable',

            'whats_num' => 'nullable',
            'whats_active' => 'nullable',

            'msngr_chat' => 'nullable',
            'msngr_plugin' => 'nullable',

            'supp_num1' => 'nullable',
            'supp_num2' => 'nullable',
            'supp_num3' => 'nullable',
            'number_visibility' => 'nullable',
            
            'coupon_visibility' => 'nullable', 

            'currency' => 'nullable',

            'redx_api_base_url' => 'nullable',
            'redx_api_access_token' => 'nullable',

            'pathao_api_base_url' => 'nullable',
            'pathao_api_access_token' => 'nullable',
            'pathao_store_id' => 'nullable',

            'steadfast_api_base_url' => 'nullable',
            'steadfast_api_key' => 'nullable',
            'steadfast_secret_key' => 'nullable',

            'fb_pixel_id' => 'nullable',
            'fb_pixel_test_code' => 'nullable',
            'fb_access_token' => 'nullable',

            'fraudApi' => 'nullable',
            'pathao_status' => 'nullable',
            'redx_status' => 'nullable',

            'is_ip_check' => 'nullable',
            'is_mobile_check' => 'nullable',
            'time_limit' => 'nullable',

            'primary_color' => 'nullable',
            'primary_background' => 'nullable',
            'primary_background2' => 'nullable',
            'primary_background3' => 'nullable',
            'gradient_code' => 'nullable',

            'footer_bg1' => 'nullable',
            'footer_bg2' => 'nullable',
            'footer_bg3' => 'nullable',

            'footer_text' => 'nullable',
            'footer_link_hover' => 'nullable',
            'footer_subtitle' => 'nullable',

            'footer_border_grad1' => 'nullable',
            'footer_border_grad2' => 'nullable',

            'footer_pill_bg' => 'nullable',
            'footer_pill_border' => 'nullable',
            'footer_pill_hover_bg' => 'nullable',
            'footer_pill_hover_text' => 'nullable',

            'footer_underline' => 'nullable',

            'footer_social_border' => 'nullable',
            'footer_social_bg' => 'nullable',
            'footer_social_hover_bg' => 'nullable',
            'footer_social_hover_text' => 'nullable',

            'mnav_bg' => 'nullable',
            'mnav_border' => 'nullable',
            'mnav_icon' => 'nullable',

            'mnav_home_bg' => 'nullable',
            'mnav_home_border' => 'nullable',
            'mnav_home_icon' => 'nullable',

            'footer_bg_color' => 'nullable',
            'footer_text_color' => 'nullable',
            'footer_accent_color' => 'nullable',

            'smtp_host' => 'nullable',
            'smtp_port' => 'nullable',
            'smtp_user' => 'nullable',
            'smtp_pass' => 'nullable',
            'sms_api_key' => 'nullable',
            'sms_sender_id' => 'nullable',
            'admin_phone' => 'nullable',
            'admin_email' => 'nullable',
            'sms_new_order_admin' => 'nullable',
            'sms_status_update' => 'nullable',

            'sms_pending'    => 'nullable',
            'sms_processing' => 'nullable',
            'sms_courier'    => 'nullable',
            'sms_complete'   => 'nullable',
            'sms_cancell'    => 'nullable',
            'sms_return'     => 'nullable',
            'sms_on_hold'    => 'nullable',

            'otp_system' => 'nullable',
            'notification_active' => 'nullable', // ✅ NEW: Validation for notification

            'ssl_store_id'       => 'nullable',
            'ssl_store_password' => 'nullable',
            'ssl_sandbox'        => 'nullable',
            'ssl_active'         => 'nullable',
            'ssl_terms_active'   => 'nullable',
            'cod_active'         => 'nullable',
            
            'ssl_sandbox_store_id'       => 'nullable',
            'ssl_sandbox_store_password' => 'nullable',
            
            'stock_warning_limit'        => 'nullable|integer', 

            'max_order_amount'           => 'nullable|numeric',
            'max_order_qty'              => 'nullable|integer',
        ]);

        $information = Information::orderBy('id', 'desc')->firstOrFail();

        // ✅✅✅ FIX: Added Notification Logic and Changed has() to boolean()
        $data['topbar_active']       = $request->boolean('topbar_active') ? 1 : 0;
        $data['otp_system']          = $request->boolean('otp_system') ? 1 : 0;
        $data['notification_active'] = $request->boolean('notification_active') ? 1 : 0; // ✅ NEW: Logic
        $data['ssl_sandbox']         = $request->boolean('ssl_sandbox') ? 1 : 0;
        $data['ssl_active']          = $request->boolean('ssl_active') ? 1 : 0;
        $data['ssl_terms_active']    = $request->boolean('ssl_terms_active') ? 1 : 0;
        $data['cod_active']          = $request->boolean('cod_active') ? 1 : 0;

        if (empty($data['gradient_code'] ?? null)) unset($data['gradient_code']);

        if ($request->hasFile('site_logo')) {
            Util::deleteFile($information->site_logo, 'img');
            $data['site_logo'] = Util::uploadFile($request->site_logo, 'img');
        }

        if ($request->hasFile('footer_logo')) {
            Util::deleteFile($information->footer_logo, 'img');
            $data['footer_logo'] = Util::uploadFile($request->footer_logo, 'img');
        }

        if ($request->hasFile('fav_icon')) {
            Util::deleteFile($information->fav_icon, 'img');
            $data['fav_icon'] = Util::uploadFile($request->fav_icon, 'img');
        }

        $information->update($data);

        return back()->with(['msg' => 'Site settings has been updated']);
    }

    public function statusCoupon(Request $request)
    {
        $information = Information::orderBy('id', 'desc')->first();
        if($information) {
            $information->coupon_visibility = $request->coupon_visibility;
            $information->save();
        }

        return back()->with(['msg' => 'Coupon status updated successfully']);
    }

    public function showProfile()
    {
        $data = Auth::user();
        return view('backend.informations.profile', compact('data'));
    }

    public function updateProfile(Request $request)
    {
        $user = Auth::user();

        $validator = Validator::make($request->all(), [
            'first_name' => ['required'],
            'last_name' => ['required'],
            'username' => ['required', 'unique:users,username,' . $user->id],
            'mobile' => ['required', 'unique:users,mobile,' . $user->id],
            'business_name' => ['required'],
            'image' => ['max:2048'],
        ]);

        $data = $request->only(['first_name', 'last_name', 'username', 'mobile', 'business_name']);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()]);
        }

        if ($request->hasFile('image')) {
            Util::deleteFile($user->image, 'img');
            $data['image'] = Util::uploadFile($request->image, 'img');
        }

        $user->update($data);

        return response()->json(['success' => 'Profile has been updated']);
    }
}