<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Information extends Model
{
    use HasFactory;

    protected $table = 'informations';

    public $timestamps = false;

    /**
     * ✅ Mass assignment safe (recommended)
     * তোমার controller এ update($data) কাজ করবে, আর unwanted field ঢুকবে না।
     */
    protected $fillable = [
        // =========================
        // Basic Site Info (common)
        // =========================
        'site_name',
        'site_logo',
        'footer_logo',
        'fav_icon',
        'owner_phone',
        'owner_email',
        'address',
        'copyright',
        'topbar_notice',
        'topbar_active', 

        // Social
        'facebook',
        'instagram',
        'tiktok',
        'twitter',
        'youtube',

        // Tracking
        'tracking_code',

        // Settings numbers
        'recommend_num',
        'discount_num',
        'newarrival_num',

        // Payments
        'bkash', 'bkash_number',
        'nogod', 'nogod_number',
        'rocket', 'rocket_number',
        'paypal', 'paypal_account',
        'stripe', 'stripe_account',

        // WhatsApp / Messenger
        'whats_num',
        'whats_active',
        'msngr_chat',
        'msngr_plugin',

        // Support numbers
        'supp_num1',
        'supp_num2',
        'supp_num3',
        'number_visibility',

        // Currency
        'currency',

        // Courier API
        'redx_api_base_url',
        'redx_api_access_token',
        'pathao_api_base_url',
        'pathao_api_access_token',
        'pathao_store_id',
        'steadfast_api_base_url',
        'steadfast_api_key',
        'steadfast_secret_key',

        // Facebook pixel
        'fb_pixel_id',
        'fb_pixel_test_code',
        'fb_access_token',

        // Fraud / status
        'fraudApi',
        'pathao_status',
        'redx_status',

        // Security checks
        'is_ip_check',
        'is_mobile_check',
        'time_limit',

        // =========================
        // Site Colors / Gradient
        // =========================
        'primary_color',
        'primary_background',
        'primary_background2',
        'primary_background3',
        'gradient_code',

        // =========================
        // ✅ Footer Theme Colors
        // =========================
        'footer_bg1',
        'footer_bg2',
        'footer_bg3',
        'footer_text',
        'footer_link_hover',
        'footer_subtitle',
        'footer_border_grad1',
        'footer_border_grad2',

        'footer_pill_bg',
        'footer_pill_border',
        'footer_pill_hover_bg',
        'footer_pill_hover_text',

        'footer_underline',

        'footer_social_border',
        'footer_social_bg',
        'footer_social_hover_bg',
        'footer_social_hover_text',

        // =========================
        // ✅ Mobile Bottom Nav Colors
        // =========================
        'mnav_bg',
        'mnav_border',
        'mnav_icon',
        'mnav_home_bg',
        'mnav_home_border',
        'mnav_home_icon',

        // =========================
        // Backward compatible old fields (যদি থাকে)
        // =========================
        'footer_bg_color',
        'footer_text_color',
        'footer_accent_color',

        // =========================
        // ✅ NEW: SMTP & SMS SETTINGS
        // =========================
        'smtp_host', 
        'smtp_port', 
        'smtp_user', 
        'smtp_pass',
        'sms_api_key', 
        'sms_sender_id',
        'admin_phone', 
        'admin_email',

        // =========================
        // ✅ NEW: SMS TEMPLATES (Admin & Customer)
        // =========================
        'sms_new_order_admin',
        'sms_status_update',

        // =========================
        // ✅ NEW: Status-wise SMS Templates
        // =========================
        'sms_pending',
        'sms_processing',
        'sms_courier',
        'sms_complete',
        'sms_cancell',
        'sms_return',
        'sms_on_hold',

        // =========================
        // ✅ NEW: OTP & Notifications
        // =========================
        'otp_system',
        'notification_active', // ✅✅✅ এই লাইনটি অ্যাড করা হয়েছে
        'coupon_visibility', 

        // =========================
        // ✅✅✅ NEW: SSLCommerz Settings
        // =========================
        'ssl_store_id',
        'ssl_store_password',
        'ssl_sandbox',
        'ssl_active',
        'ssl_terms_active', // ✅ Added for Terms & Conditions Show/Hide in checkout
        'cod_active',       // ✅ Added new field for Enable/Disable Button
        
        // ✅✅✅ NEW: SSLCommerz Sandbox Specific Credentials
        'ssl_sandbox_store_id',
        'ssl_sandbox_store_password',

        // ✅✅✅ NEW: Stock Warning Limit
        'stock_warning_limit',

        // ✅✅✅ NEW: Order Limits (Amount & Quantity)
        'max_order_amount',
        'max_order_qty',

        // ✅✅✅ NEW: Invoice Design Settings
        'invoice_type',
    ];
}