<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\View;
use App\Services\FacebookConversionService;
use App\Models\Category;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->singleton('facebook-conversion', function ($app) {
            return new FacebookConversionService();
        });
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        // Pagination bootstrap
        Paginator::useBootstrap();

        // ✅ Header category dropdown data (global – all views)
        View::composer('*', function ($view) {

            $headerCategories = Category::whereNull('parent_id')
                ->with('subcatsRecursive') // recursive sub categories
                ->orderBy('name')
                ->get();

            $view->with('headerCategories', $headerCategories);
        });
    }
}
