@extends('backend.app')

@push('css')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@mdi/font@7.2.96/css/materialdesignicons.min.css">
<style>
    :root {
        --primary-color: #556ee6;
        --primary-soft: rgba(85, 110, 230, 0.08);
        --text-dark: #343a40;
        --text-muted: #74788d;
        --bg-body: #f8f8fb;
        --card-bg: #ffffff;
        --border-radius: 16px;
        --transition: all 0.3s ease-in-out;
        --shadow-sm: 0 2px 4px rgba(0,0,0,0.02);
        --shadow-md: 0 8px 20px rgba(18, 38, 63, 0.06);
    }

    /* Page Styling */
    .page-title-box h4 {
        font-weight: 700;
        color: var(--text-dark);
        letter-spacing: -0.5px;
    }

    /* PREMIUM ACCORDION STYLES */
    .accordion-item {
        border: 1px solid rgba(0,0,0,0.03);
        border-radius: var(--border-radius);
        background: var(--card-bg);
        margin-bottom: 20px;
        box-shadow: var(--shadow-sm);
        overflow: hidden;
        transition: var(--transition);
    }

    .accordion-item:hover {
        box-shadow: var(--shadow-md);
        transform: translateY(-2px);
    }

    .accordion-button {
        font-size: 1.1rem;
        font-weight: 600;
        color: var(--text-dark);
        background-color: var(--card-bg);
        padding: 1.5rem;
        border: none;
        box-shadow: none !important;
        display: flex;
        align-items: center;
    }

    .header-icon {
        width: 45px;
        height: 45px;
        background: var(--bg-body);
        color: var(--primary-color);
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-right: 18px;
        font-size: 20px;
        transition: var(--transition);
    }

    .accordion-button::after { display: none; }

    .custom-chevron {
        margin-left: auto;
        font-size: 1.5rem;
        color: #adb5bd;
        transition: transform 0.3s;
    }

    .accordion-button:not(.collapsed) {
        background-color: #fff;
        color: var(--primary-color);
    }

    .accordion-button:not(.collapsed) .header-icon {
        background: var(--primary-color);
        color: #fff;
        box-shadow: 0 4px 10px rgba(85, 110, 230, 0.3);
    }

    .accordion-button:not(.collapsed) .custom-chevron {
        transform: rotate(180deg);
        color: var(--primary-color);
    }

    .accordion-item:has(.accordion-button:not(.collapsed)) {
        border-left: 4px solid var(--primary-color);
    }

    .accordion-body {
        padding: 0 1.5rem 2rem 1.5rem;
        background-color: #fff;
        animation: fadeIn 0.4s ease;
    }

    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(5px); }
        to { opacity: 1; transform: translateY(0); }
    }

    /* FORM ELEMENTS */
    .form-label {
        font-weight: 600;
        color: #495057;
        font-size: 0.88rem;
        margin-bottom: 0.6rem;
    }
    
    .form-control, .form-select {
        border: 1px solid #e2e5e8;
        border-radius: 10px;
        padding: 0.75rem 1rem;
        font-size: 0.95rem;
        transition: var(--transition);
        background-color: #fdfdfd;
    }
    
    .form-control:focus, .form-select:focus {
        border-color: var(--primary-color);
        background-color: #fff;
        box-shadow: 0 0 0 4px var(--primary-soft);
    }

    /* Image Preview */
    .preview-box {
        width: 100%;
        height: 100px;
        border: 2px dashed #ced4da;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        background: #f8f9fa;
        margin-top: 10px;
        position: relative;
        overflow: hidden;
        transition: var(--transition);
    }
    .preview-box:hover {
        border-color: var(--primary-color);
        background: var(--primary-soft);
    }
    .preview-box img {
        max-height: 80px;
        max-width: 90%;
        object-fit: contain;
    }

    /* STICKY SAVE BAR */
    .sticky-actions {
        position: sticky;
        bottom: 25px;
        background: rgba(255, 255, 255, 0.85);
        backdrop-filter: blur(12px);
        -webkit-backdrop-filter: blur(12px);
        padding: 15px 30px;
        border-radius: 50px;
        box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-top: 40px;
        border: 1px solid rgba(255,255,255,0.5);
        z-index: 1000;
        transition: transform 0.3s;
    }

    .sticky-actions:hover {
        transform: translateY(-2px);
        box-shadow: 0 15px 35px rgba(0,0,0,0.12);
    }

    .btn-save {
        background: linear-gradient(135deg, #556ee6, #34c38f);
        border: none;
        color: white;
        padding: 12px 40px;
        border-radius: 30px;
        font-weight: 700;
        letter-spacing: 1px;
        text-transform: uppercase;
        box-shadow: 0 4px 15px rgba(52, 195, 143, 0.4);
        transition: all 0.3s;
    }

    .btn-save:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(52, 195, 143, 0.6);
        color: white;
    }

    @media (max-width: 768px) {
        .sticky-actions {
            flex-direction: column;
            bottom: 15px;
            padding: 15px;
            border-radius: 20px;
        }
        .btn-save { width: 100%; }
        .sticky-text { display: none; }
    }
</style>
@endpush

@section('content')

<div class="row mb-4">
    <div class="col-12">
        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
            <h4 class="mb-0">System Configuration</h4>
            <div class="page-title-right">
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item"><a href="javascript: void(0);">Admin</a></li>
                    <li class="breadcrumb-item active">Settings</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<form action="{{ route('admin.settings.update', [$information->id]) }}" method="POST" enctype="multipart/form-data">
    @csrf
    @method('PUT')

    @if(Session::has('msg'))
        <div class="alert alert-success alert-dismissible fade show mb-4 shadow-sm border-0 rounded-3" role="alert">
            <div class="d-flex align-items-center">
                <i class="mdi mdi-check-decagram fs-3 me-2"></i>
                <div>{{ Session::get('msg') }}</div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    <div class="accordion" id="settingsAccordion">

        {{-- General Information --}}
        <div class="accordion-item">
            <h2 class="accordion-header" id="headingGeneral">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseGeneral" aria-expanded="false">
                    <span class="header-icon"><i class="mdi mdi-tune-vertical"></i></span> 
                    General Information
                    <i class="mdi mdi-chevron-down custom-chevron"></i>
                </button>
            </h2>
            <div id="collapseGeneral" class="accordion-collapse collapse" aria-labelledby="headingGeneral" data-bs-parent="#settingsAccordion">
                <div class="accordion-body">
                    <div class="row g-4">
                        <div class="col-12">
                            <label class="form-label">Site Name</label>
                            <input type="text" class="form-control" name="site_name" value="{{ $information->site_name }}">
                        </div>
                        
                        <div class="col-md-4">
                            <label class="form-label">Site Logo</label>
                            <small class="text-muted d-block mb-2">Recommended Size: 180px x 50px</small>
                            <input type="file" id="site_logo" class="form-control" name="site_logo" accept="image/*">
                            <div class="preview-box">
                                <img src="{{ asset('uploads/img/'.$information->site_logo) }}" id="preview_logo" alt="Logo">
                            </div>
                        </div>

                        <div class="col-md-4">
                            <label class="form-label">Footer Logo</label>
                             <small class="text-muted d-block mb-2">Recommended Size: 180px x 50px</small>
                            <input type="file" id="footer_logo" class="form-control" name="footer_logo" accept="image/*">
                            <div class="preview-box">
                                <img src="{{ !empty($information->footer_logo) ? asset('uploads/img/'.$information->footer_logo) : asset('uploads/img/'.$information->site_logo) }}" id="preview_footer_logo">
                            </div>
                        </div>

                        <div class="col-md-4">
                            <label class="form-label">Favicon</label>
                             <small class="text-muted d-block mb-2">Recommended Size: 32px x 32px (Square)</small>
                            <input type="file" id="fav_icon" class="form-control" name="fav_icon" accept="image/*">
                            <div class="preview-box">
                                <img src="{{ asset('uploads/img/'.$information->fav_icon) }}" id="preview_favicon">
                            </div>
                        </div>
                        
                        <div class="col-12">
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <label class="form-label mb-0">Topbar Announcement</label>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" role="switch" id="topbarSwitch" name="topbar_active" value="1" {{ $information->topbar_active == 1 ? 'checked' : '' }}>
                                    <label class="form-check-label" for="topbarSwitch">Show/Hide</label>
                                </div>
                            </div>
                            <textarea class="form-control" name="topbar_notice" rows="2">{{ $information->topbar_notice }}</textarea>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- Contact & Social --}}
        <div class="accordion-item">
            <h2 class="accordion-header" id="headingContact">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseContact" aria-expanded="false">
                    <span class="header-icon"><i class="mdi mdi-card-account-details-outline"></i></span> 
                    Contact & Header Code
                    <i class="mdi mdi-chevron-down custom-chevron"></i>
                </button>
            </h2>
            <div id="collapseContact" class="accordion-collapse collapse" aria-labelledby="headingContact" data-bs-parent="#settingsAccordion">
                <div class="accordion-body">
                    <div class="row g-4">
                        <div class="col-md-6">
                            <label class="form-label">Support Phone</label>
                            <input type="tel" class="form-control" name="owner_phone" value="{{ $information->owner_phone }}">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Support Email</label>
                            <input type="email" class="form-control" name="owner_email" value="{{ $information->owner_email }}">
                        </div>
                        <div class="col-12">
                            <label class="form-label">Office Address</label>
                            <textarea class="form-control" name="address" rows="2">{{ $information->address }}</textarea>
                        </div>
                        <div class="col-12">
                            <label class="form-label">Tracking Scripts (Header)</label>
                            <textarea class="form-control font-monospace" name="tracking_code" rows="3" style="font-size: 12px;">{{ $information->tracking_code }}</textarea>
                        </div>
                        <div class="col-12">
                            <label class="form-label">Copyright Text</label>
                            <input type="text" class="form-control" name="copyright" value="{{ $information->copyright }}">
                        </div>
                        
                        <div class="col-12 mt-4"><h6 class="text-primary fw-bold">Social Media Links</h6></div>
                        <div class="col-md-4">
                            <div class="input-group">
                                <span class="input-group-text bg-white"><i class="mdi mdi-facebook text-primary"></i></span>
                                <input type="url" class="form-control" name="facebook" placeholder="Facebook URL" value="{{ $information->facebook }}">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="input-group">
                                <span class="input-group-text bg-white"><i class="mdi mdi-instagram text-danger"></i></span>
                                <input type="url" class="form-control" name="instagram" placeholder="Instagram URL" value="{{ $information->instagram }}">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="input-group">
                                <span class="input-group-text bg-white"><i class="mdi mdi-youtube text-danger"></i></span>
                                <input type="url" class="form-control" name="youtube" placeholder="YouTube URL" value="{{ $information->youtube }}">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="input-group">
                                <span class="input-group-text bg-white"><i class="mdi mdi-twitter text-info"></i></span>
                                <input type="url" class="form-control" name="twitter" placeholder="Twitter URL" value="{{ $information->twitter }}">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="input-group">
                                <span class="input-group-text bg-white"><i class="mdi mdi-music-note-eighth text-dark"></i></span>
                                <input type="url" class="form-control" name="tiktok" placeholder="TikTok URL" value="{{ $information->tiktok }}">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- Security & Fraud --}}
        <div class="accordion-item">
            <h2 class="accordion-header" id="headingSecurity">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseSecurity" aria-expanded="false">
                    <span class="header-icon"><i class="mdi mdi-shield-lock-outline"></i></span> 
                    Security & Fraud Check API
                    <i class="mdi mdi-chevron-down custom-chevron"></i>
                </button>
            </h2>
            <div id="collapseSecurity" class="accordion-collapse collapse" aria-labelledby="headingSecurity" data-bs-parent="#settingsAccordion">
                <div class="accordion-body">
                    <div class="row g-4">
                        <div class="col-md-4">
                            <label class="form-label">WhatsApp Number</label>
                            <input type="tel" class="form-control" name="whats_num" value="{{ $information->whats_num }}">
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">WhatsApp Order Feature</label>
                            <select class="form-select" name="whats_active">
                                <option value="1" {{ $information->whats_active == '1' ? 'selected':'' }}>Enabled</option>
                                <option value="0" {{ $information->whats_active == '0' ? 'selected':'' }}>Disabled</option>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Hotline 2</label>
                            <input type="tel" class="form-control" name="supp_num1" value="{{ $information->supp_num1 }}">
                        </div>
                        <div class="col-md-12">
                            <div class="d-flex justify-content-between align-items-center mb-1">
                                <label class="form-label mb-0">Fraud Check API Key</label>
                                <a href="https://www.hoorin.com/" target="_blank" class="btn btn-sm btn-soft-primary rounded-pill">
                                    <i class="mdi mdi-web me-1"></i> Visit Hoorin.com
                                </a>
                            </div>
                            <input type="text" class="form-control font-monospace" name="fraudApi" value="{{ $information->fraudApi }}">
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- Order Rules --}}
        <div class="accordion-item">
            <h2 class="accordion-header" id="headingOrder">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOrder" aria-expanded="false">
                    <span class="header-icon"><i class="mdi mdi-gavel"></i></span> 
                    Order Guard (Rules)
                    <i class="mdi mdi-chevron-down custom-chevron"></i>
                </button>
            </h2>
            <div id="collapseOrder" class="accordion-collapse collapse" aria-labelledby="headingOrder" data-bs-parent="#settingsAccordion">
                <div class="accordion-body">
                    <div class="row g-4">
                        <div class="col-md-6">
                            <div class="p-3 border rounded-3 h-100 bg-light">
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <label class="form-label mb-0">IP Check</label>
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" role="switch" name="is_ip_check" value="1" {{ $information->is_ip_check == 1 ? 'checked' : '' }}>
                                    </div>
                                </div>
                                <small class="text-muted">Block multiple orders from same IP Address.</small>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="p-3 border rounded-3 h-100 bg-light">
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <label class="form-label mb-0">Phone Check</label>
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" role="switch" name="is_mobile_check" value="1" {{ $information->is_mobile_check == 1 ? 'checked' : '' }}>
                                    </div>
                                </div>
                                <small class="text-muted">Block duplicate orders from same Phone Number.</small>
                            </div>
                        </div>
                        <div class="col-12">
                            <label class="form-label">Order Frequency Limit (Minutes)</label>
                            <input type="number" class="form-control w-50" name="time_limit" value="{{ $information->time_limit }}">
                            <small class="text-muted">Time to wait before placing another order.</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- ✅✅✅ NEW: Inventory & Order Limits Menu --}}
        <div class="accordion-item" style="border-color: #f1b44c;">
            <h2 class="accordion-header" id="headingInventory">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseInventory" aria-expanded="false">
                    <span class="header-icon" style="background: #fff4e5; color: #f1b44c;">
                        <i class="mdi mdi-store-alert"></i>
                    </span> 
                    Inventory & Order Limits
                    <i class="mdi mdi-chevron-down custom-chevron"></i>
                </button>
            </h2>
            <div id="collapseInventory" class="accordion-collapse collapse" aria-labelledby="headingInventory" data-bs-parent="#settingsAccordion">
                <div class="accordion-body">
                    <div class="row g-4">
                        
                        {{-- Stock Warning Limit --}}
                        <div class="col-md-4">
                            <label class="form-label">Stock Warning Limit</label>
                            <div class="input-group">
                                <span class="input-group-text bg-white"><i class="mdi mdi-alert-outline text-danger"></i></span>
                                <input type="number" class="form-control border-start-0 ps-0" name="stock_warning_limit" min="0" value="{{ $information->stock_warning_limit ?? 0 }}" placeholder="Example: 5">
                            </div>
                            <small class="text-muted">কত পিসের নিচে স্টক নামলে ওয়ার্নিং দেখাবে।</small>
                        </div>

                        {{-- Maximum Order Amount --}}
                        <div class="col-md-4">
                            <label class="form-label">Maximum Order Amount (Tk)</label>
                            <div class="input-group">
                                <span class="input-group-text bg-white fw-bold">৳</span>
                                <input type="number" step="0.01" class="form-control border-start-0 ps-0" name="max_order_amount" value="{{ $information->max_order_amount }}" placeholder="Leave empty for NO limit">
                            </div>
                            <small class="text-muted">একসাথে সর্বোচ্চ কত টাকার অর্ডার করা যাবে।</small>
                        </div>

                        {{-- Maximum Quantity Per Order --}}
                        <div class="col-md-4">
                            <label class="form-label">Maximum Quantity Per Order</label>
                            <div class="input-group">
                                <span class="input-group-text bg-white"><i class="mdi mdi-shopping-outline text-primary"></i></span>
                                <input type="number" class="form-control border-start-0 ps-0" name="max_order_qty" value="{{ $information->max_order_qty }}" placeholder="Leave empty for NO limit">
                            </div>
                            <small class="text-muted">একটি অর্ডারে সর্বোচ্চ কত পিস প্রোডাক্ট নেওয়া যাবে।</small>
                        </div>

                    </div>
                </div>
            </div>
        </div>

        {{-- Couriers --}}
        <div class="accordion-item">
            <h2 class="accordion-header" id="headingCourier">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseCourier" aria-expanded="false">
                    <span class="header-icon"><i class="mdi mdi-truck-delivery-outline"></i></span> 
                    Courier Integrations
                    <i class="mdi mdi-chevron-down custom-chevron"></i>
                </button>
            </h2>
            <div id="collapseCourier" class="accordion-collapse collapse" aria-labelledby="headingCourier" data-bs-parent="#settingsAccordion">
                <div class="accordion-body">
                    <div class="card border-0 shadow-none bg-light mb-3">
                        <div class="card-body">
                            <h6 class="fw-bold text-danger mb-3"><i class="mdi mdi-package"></i> RedX Courier</h6>
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <input type="text" class="form-control" name="redx_api_base_url" value="{{ $information->redx_api_base_url }}" placeholder="API Base URL">
                                </div>
                                <div class="col-md-6">
                                    <input type="text" class="form-control" name="redx_api_access_token" value="{{ $information->redx_api_access_token }}" placeholder="Access Token">
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card border-0 shadow-none bg-light mb-3">
                        <div class="card-body">
                            <div class="d-flex justify-content-between mb-3">
                                <h6 class="fw-bold text-danger"><i class="mdi mdi-bike-fast"></i> Pathao Courier</h6>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" name="pathao_status" value="1" {{ $information->pathao_status == 1 ? 'checked' : '' }}>
                                </div>
                            </div>
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <input type="text" class="form-control" name="pathao_api_base_url" value="{{ $information->pathao_api_base_url }}" placeholder="API URL">
                                </div>
                                <div class="col-md-6">
                                    <input type="text" class="form-control" name="pathao_store_id" value="{{ $information->pathao_store_id }}" placeholder="Store ID">
                                </div>
                                <div class="col-12">
                                    <div class="input-group">
                                        <input type="text" class="form-control" name="pathao_api_access_token" value="{{ $information->pathao_api_access_token }}" placeholder="Access Token">
                                        <a href="{{ route('admin.viewAccessToken') }}" class="btn btn-dark">Generate Token</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card border-0 shadow-none bg-light">
                        <div class="card-body">
                            <h6 class="fw-bold text-primary mb-3"><i class="mdi mdi-truck-fast"></i> Steadfast Courier</h6>
                            <div class="row g-3">
                                <div class="col-12">
                                    <input type="text" class="form-control" name="steadfast_api_base_url" value="{{ $information->steadfast_api_base_url }}" placeholder="API URL">
                                </div>
                                <div class="col-md-6">
                                    <input type="text" class="form-control" name="steadfast_api_key" value="{{ $information->steadfast_api_key }}" placeholder="API Key">
                                </div>
                                <div class="col-md-6">
                                    <input type="text" class="form-control" name="steadfast_secret_key" value="{{ $information->steadfast_secret_key }}" placeholder="Secret Key">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- Meta Pixel --}}
        <div class="accordion-item">
            <h2 class="accordion-header" id="headingPixel">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapsePixel" aria-expanded="false">
                    <span class="header-icon"><i class="mdi mdi-facebook"></i></span> 
                    Meta (Facebook) Pixel
                    <i class="mdi mdi-chevron-down custom-chevron"></i>
                </button>
            </h2>
            <div id="collapsePixel" class="accordion-collapse collapse" aria-labelledby="headingPixel" data-bs-parent="#settingsAccordion">
                <div class="accordion-body">
                    <div class="row g-4">
                        <div class="col-md-6">
                            <label class="form-label">Pixel ID</label>
                            <input type="text" class="form-control" name="fb_pixel_id" value="{{ $information->fb_pixel_id }}">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Test Event Code</label>
                            <input type="text" class="form-control" name="fb_pixel_test_code" value="{{ $information->fb_pixel_test_code }}">
                        </div>
                        <div class="col-12">
                            <label class="form-label">Conversion API Access Token</label>
                            <textarea class="form-control" name="fb_access_token" rows="3">{{ $information->fb_access_token }}</textarea>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- COD --}}
        <div class="accordion-item">
            <h2 class="accordion-header" id="headingCod">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseCod" aria-expanded="false">
                    <span class="header-icon"><i class="mdi mdi-cash-multiple"></i></span> 
                    Cash on Delivery (COD) Settings
                    <i class="mdi mdi-chevron-down custom-chevron"></i>
                </button>
            </h2>
            <div id="collapseCod" class="accordion-collapse collapse" aria-labelledby="headingCod" data-bs-parent="#settingsAccordion">
                <div class="accordion-body">
                    
                    <div class="p-3 border rounded-3 bg-white mb-4" style="border-left: 4px solid #34c38f !important;">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="fw-bold mb-1 text-dark">COD Status</h6>
                                <small class="text-muted">Enable or Disable Cash on Delivery option.</small>
                            </div>
                            <div class="form-check form-switch">
                                <input type="hidden" name="cod_active" value="0">
                                <input class="form-check-input" type="checkbox" id="codActiveSwitch" name="cod_active" value="1" {{ ($information->cod_active ?? 1) == 1 ? 'checked' : '' }} style="width: 3rem; height: 1.5rem; cursor: pointer;">
                                <label class="form-check-label fw-bold ms-2 mt-1" for="codActiveSwitch" id="codActiveLabel">
                                    {{ ($information->cod_active ?? 1) == 1 ? 'Enabled' : 'Disabled' }}
                                </label>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>

        {{-- SSLCommerz --}}
        <div class="accordion-item">
            <h2 class="accordion-header" id="headingSsl">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseSsl" aria-expanded="false">
                    <span class="header-icon"><i class="mdi mdi-credit-card-outline"></i></span> 
                    SSLCommerz Payment Gateway
                    <i class="mdi mdi-chevron-down custom-chevron"></i>
                </button>
            </h2>
            <div id="collapseSsl" class="accordion-collapse collapse" aria-labelledby="headingSsl" data-bs-parent="#settingsAccordion">
                <div class="accordion-body">
                    
                    {{-- Enable/Disable Gateway --}}
                    <div class="p-3 border rounded-3 bg-white mb-4" style="border-left: 4px solid #556ee6 !important;">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="fw-bold mb-1 text-dark">Gateway Status</h6>
                                <small class="text-muted">Enable or Disable SSLCommerz payment on checkout.</small>
                            </div>
                            <div class="form-check form-switch">
                                <input type="hidden" name="ssl_active" value="0">
                                <input class="form-check-input" type="checkbox" id="sslActiveSwitch" name="ssl_active" value="1" {{ ($information->ssl_active ?? 1) == 1 ? 'checked' : '' }} style="width: 3rem; height: 1.5rem; cursor: pointer;">
                                <label class="form-check-label fw-bold ms-2 mt-1" for="sslActiveSwitch" id="sslActiveLabel">
                                    {{ ($information->ssl_active ?? 1) == 1 ? 'Enabled' : 'Disabled' }}
                                </label>
                            </div>
                        </div>
                    </div>

                    {{-- ✅✅ NEW: Terms & Conditions Checkbox Toggle ✅✅ --}}
                    <div class="p-3 border rounded-3 bg-white mb-4" style="border-left: 4px solid #50a5f1 !important;">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="fw-bold mb-1 text-dark">Terms & Conditions Checkbox</h6>
                                <small class="text-muted">Show/Hide "I agree to Terms & Conditions" checkbox on checkout.</small>
                            </div>
                            <div class="form-check form-switch">
                                <input type="hidden" name="ssl_terms_active" value="0">
                                <input class="form-check-input" type="checkbox" id="sslTermsSwitch" name="ssl_terms_active" value="1" {{ ($information->ssl_terms_active ?? 0) == 1 ? 'checked' : '' }} style="width: 3rem; height: 1.5rem; cursor: pointer;">
                                <label class="form-check-label fw-bold ms-2 mt-1" for="sslTermsSwitch" id="sslTermsLabel">
                                    {{ ($information->ssl_terms_active ?? 0) == 1 ? 'Enabled' : 'Disabled' }}
                                </label>
                            </div>
                        </div>
                    </div>

                    {{-- Mode Switch --}}
                    <div class="p-3 border rounded-3 bg-light mb-4">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="fw-bold mb-1">Active Payment Mode</h6>
                                <small class="text-muted">Select which credentials to use for transactions.</small>
                            </div>
                            <div class="form-check form-switch">
                                <input type="hidden" name="ssl_sandbox" value="0">
                                <input class="form-check-input" type="checkbox" id="sandboxMode" name="ssl_sandbox" value="1" {{ ($information->ssl_sandbox ?? 1) == 1 ? 'checked' : '' }}>
                                <label class="form-check-label fw-bold ms-2" for="sandboxMode" id="sandboxLabel">
                                    {{ ($information->ssl_sandbox ?? 1) == 1 ? 'Sandbox (Test Mode)' : 'Live Mode' }}
                                </label>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 border-end">
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <h6 class="text-warning fw-bold mb-0"><i class="mdi mdi-flask-outline me-1"></i> Sandbox (Test) Config</h6>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Test Store ID</label>
                                <input type="text" id="ssl_sandbox_store_id" class="form-control bg-light" name="ssl_sandbox_store_id" value="{{ $information->ssl_sandbox_store_id ?? '' }}" placeholder="">
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Test Store Password</label>
                                <input type="text" id="ssl_sandbox_store_password" class="form-control bg-light" name="ssl_sandbox_store_password" value="{{ $information->ssl_sandbox_store_password ?? '' }}" placeholder="">
                            </div>
                        </div>

                        <div class="col-md-6 ps-md-4">
                            <h6 class="text-success fw-bold mb-3"><i class="mdi mdi-lock-check-outline me-1"></i> Live (Real) Config</h6>
                            <div class="mb-3">
                                <label class="form-label">Live Store ID</label>
                                <input type="text" class="form-control" name="ssl_store_id" value="{{ $information->ssl_store_id ?? '' }}" placeholder="Enter Live Store ID">
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Live Store Password</label>
                                <input type="text" class="form-control" name="ssl_store_password" value="{{ $information->ssl_store_password ?? '' }}" placeholder="Enter Live Store Password">
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>

        {{-- Notifications & SMTP --}}
        <div class="accordion-item">
            <h2 class="accordion-header" id="headingNotification">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseNotification" aria-expanded="false">
                    <span class="header-icon"><i class="mdi mdi-bell-ring-outline"></i></span> 
                    Notification, SMS & SMTP Setup
                    <i class="mdi mdi-chevron-down custom-chevron"></i>
                </button>
            </h2>
            <div id="collapseNotification" class="accordion-collapse collapse" aria-labelledby="headingNotification" data-bs-parent="#settingsAccordion">
                <div class="accordion-body">
                    
                    {{-- OTP --}}
                    <div class="form-group row mb-4 p-3 border rounded bg-light">
                        <label class="col-sm-3 col-form-label font-weight-bold text-dark">
                            OTP Verification System
                            <small class="d-block text-muted">চেকআউটের সময় ফোন ভেরিফিকেশন</small>
                        </label>
                        <div class="col-sm-9 d-flex align-items-center">
                            <div class="custom-control custom-switch">
                                <input type="hidden" name="otp_system" value="0">
                                <input type="checkbox" class="custom-control-input" id="otpSystemSwitch" name="otp_system" value="1" {{ (isset($information->otp_system) && $information->otp_system == 1) ? 'checked' : '' }}>
                                <label class="custom-control-label font-weight-bold" for="otpSystemSwitch" style="cursor: pointer;">
                                    {{ (isset($information->otp_system) && $information->otp_system == 1) ? 'চালু আছে (ON)' : 'বন্ধ আছে (OFF)' }}
                                </label>
                            </div>
                        </div>
                    </div>

                    {{-- Order Notification --}}
                    <div class="form-group row mb-4 p-3 border rounded bg-light">
                        <label class="col-sm-3 col-form-label font-weight-bold text-dark">
                            Order Notification
                            <small class="d-block text-muted">নতুন অর্ডারের ইমেইল ও SMS অ্যালার্ট</small>
                        </label>
                        <div class="col-sm-9 d-flex align-items-center">
                            <div class="custom-control custom-switch">
                                <input type="hidden" name="notification_active" value="0">
                                <input type="checkbox" class="custom-control-input" id="notificationActiveSwitch" name="notification_active" value="1" {{ (isset($information->notification_active) && $information->notification_active == 1) ? 'checked' : '' }}>
                                <label class="custom-control-label font-weight-bold" for="notificationActiveSwitch" style="cursor: pointer;">
                                    {{ (isset($information->notification_active) && $information->notification_active == 1) ? 'চালু আছে (ON)' : 'বন্ধ আছে (OFF)' }}
                                </label>
                            </div>
                        </div>
                    </div>

                    {{-- Admin Alerts --}}
                    <div class="alert alert-soft-primary mb-3">
                        <strong>Admin Notification:</strong> নতুন অর্ডার আসলে এই নাম্বারে SMS ও ইমেইল যাবে।
                    </div>
                    <div class="row g-3 mb-4">
                        <div class="col-md-6">
                            <label class="form-label">Admin Phone (SMS)</label>
                            <input type="text" class="form-control" name="admin_phone" value="{{ $information->admin_phone }}" placeholder="Example: 01700000000">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Admin Email</label>
                            <input type="text" class="form-control" name="admin_email" value="{{ $information->admin_email }}" placeholder="admin@example.com">
                        </div>
                    </div>

                    {{-- BulkSMSBD --}}
                    <div class="alert alert-soft-warning mb-3">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <strong>BulkSMSBD Config:</strong> SMS পাঠানোর জন্য API Key ও Sender ID দিন।
                            </div>
                            <a href="https://bulksmsbd.com/" target="_blank" class="btn btn-sm btn-warning text-dark fw-bold">
                                <i class="mdi mdi-web me-1"></i> Visit BulkSMSBD.com
                            </a>
                        </div>
                    </div>
                    <div class="row g-3 mb-4">
                        <div class="col-md-6">
                            <label class="form-label">API Key</label>
                            <input type="text" class="form-control" name="sms_api_key" value="{{ $information->sms_api_key }}">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Sender ID</label>
                            <input type="text" class="form-control" name="sms_sender_id" value="{{ $information->sms_sender_id }}">
                        </div>
                    </div>

                    {{-- General SMS Templates --}}
                    <div class="alert alert-soft-info mb-3">
                        <strong>General SMS Message Templates:</strong> আপনি চাইলে মেসেজ কাস্টমাইজ করতে পারেন। 
                        <br><small>Placeholder ব্যবহার করুন: <code>{order_id}</code>, <code>{amount}</code>, <code>{status}</code></small>
                    </div>
                    <div class="row g-3 mb-4">
                        <div class="col-12">
                            <label class="form-label">New Order SMS (To Admin)</label>
                            <textarea class="form-control" name="sms_new_order_admin" rows="2" placeholder="New Order Received! ID: #{order_id}, Amount: {amount} Tk.">{{ $information->sms_new_order_admin }}</textarea>
                            <div class="form-text">Available: <code>{order_id}</code>, <code>{amount}</code></div>
                        </div>
                        <div class="col-12">
                            <label class="form-label">Default Order Status SMS (Fallback)</label>
                            <textarea class="form-control" name="sms_status_update" rows="2" placeholder="Dear Customer, your order #{order_id} is now {status}.">{{ $information->sms_status_update }}</textarea>
                            <div class="form-text">Used if no specific status template is set. Available: <code>{order_id}</code>, <code>{status}</code></div>
                        </div>
                    </div>

                    {{-- Status-wise SMS Templates --}}
                    <div class="alert alert-soft-secondary mb-3 mt-4">
                        <strong>Status-Specific SMS Templates (To Customer):</strong> 
                        <br><small>প্রতিটি স্ট্যাটাসের জন্য আলাদা মেসেজ সেট করুন। খালি রাখলে উপরের ডিফল্ট মেসেজ যাবে。</small>
                    </div>

                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label fw-bold text-warning">Pending Status SMS</label>
                            <textarea class="form-control" name="sms_pending" rows="2" placeholder="Order #{order_id} is Pending.">{{ $information->sms_pending }}</textarea>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-bold text-info">Processing Status SMS</label>
                            <textarea class="form-control" name="sms_processing" rows="2" placeholder="Order #{order_id} is Processing.">{{ $information->sms_processing }}</textarea>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-bold text-primary">Courier/Shipped Status SMS</label>
                            <textarea class="form-control" name="sms_courier" rows="2" placeholder="Order #{order_id} is with Courier.">{{ $information->sms_courier }}</textarea>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-bold text-success">Completed Status SMS</label>
                            <textarea class="form-control" name="sms_complete" rows="2" placeholder="Order #{order_id} Completed. Thanks!">{{ $information->sms_complete }}</textarea>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-bold text-danger">Cancelled Status SMS</label>
                            <textarea class="form-control" name="sms_cancell" rows="2" placeholder="Order #{order_id} Cancelled.">{{ $information->sms_cancell }}</textarea>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-bold text-dark">Returned Status SMS</label>
                            <textarea class="form-control" name="sms_return" rows="2" placeholder="Order #{order_id} Returned.">{{ $information->sms_return }}</textarea>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-bold text-secondary">On Hold Status SMS</label>
                            <textarea class="form-control" name="sms_on_hold" rows="2" placeholder="Order #{order_id} On Hold.">{{ $information->sms_on_hold }}</textarea>
                        </div>
                    </div>

                    {{-- SMTP --}}
                    <div class="alert alert-soft-success mb-3 mt-4">
                        <strong>SMTP Settings:</strong> ইমেইল পাঠানোর কনফিগারেশন।
                    </div>
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label">Mail Host</label>
                            <input type="text" class="form-control" name="smtp_host" value="{{ $information->smtp_host }}" placeholder="smtp.gmail.com">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Mail Port</label>
                            <input type="text" class="form-control" name="smtp_port" value="{{ $information->smtp_port }}" placeholder="587">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Mail Username</label>
                            <input type="text" class="form-control" name="smtp_user" value="{{ $information->smtp_user }}">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Mail Password</label>
                            <input type="password" class="form-control" name="smtp_pass" value="{{ $information->smtp_pass }}">
                        </div>
                    </div>

                </div>
            </div>
        </div>

    </div>

    <div class="sticky-actions">
        <div class="sticky-text text-muted">
            <i class="mdi mdi-information-outline"></i> Ensure all API keys are valid before saving.
        </div>
        <button type="submit" class="btn-save">
            Save Configuration
        </button>
    </div>

</form>

@endsection

@push('js')
<script>
    // Simple Image Preview
    function setupPreview(inputId, imgId) {
        document.getElementById(inputId).addEventListener('change', function(e) {
            if (e.target.files && e.target.files[0]) {
                const reader = new FileReader();
                reader.onload = function(e) { document.getElementById(imgId).src = e.target.result; }
                reader.readAsDataURL(e.target.files[0]);
            }
        });
    }

    document.addEventListener('DOMContentLoaded', function() {
        setupPreview('site_logo', 'preview_logo');
        setupPreview('footer_logo', 'preview_footer_logo');
        setupPreview('fav_icon', 'preview_favicon');
    });

    // Toggle Label Logic (Sandbox/Live)
    document.getElementById('sandboxMode').addEventListener('change', function() {
        let label = document.getElementById('sandboxLabel');
        if(this.checked) {
            label.innerText = 'Sandbox (Test Mode)';
            label.classList.remove('text-success');
            label.classList.add('text-warning');
        } else {
            label.innerText = 'Live Mode';
            label.classList.remove('text-warning');
            label.classList.add('text-success');
        }
    });

    // ✅ Toggle Label Logic (Gateway Status - Enabled/Disabled)
    function setupSwitch(switchId, labelId) {
        const switchEl = document.getElementById(switchId);
        const labelEl = document.getElementById(labelId);
        
        if(switchEl && labelEl){
            // Initial State
            if(switchEl.checked) {
                labelEl.innerText = 'Enabled';
                labelEl.classList.remove('text-danger');
                labelEl.classList.add('text-success');
            } else {
                labelEl.innerText = 'Disabled';
                labelEl.classList.remove('text-success');
                labelEl.classList.add('text-danger');
            }

            // Change Event
            switchEl.addEventListener('change', function() {
                if(this.checked) {
                    labelEl.innerText = 'Enabled';
                    labelEl.classList.remove('text-danger');
                    labelEl.classList.add('text-success');
                } else {
                    labelEl.innerText = 'Disabled';
                    labelEl.classList.remove('text-success');
                    labelEl.classList.add('text-danger');
                }
            });
        }
    }

    // Setup for both switches
    setupSwitch('sslActiveSwitch', 'sslActiveLabel');
    setupSwitch('codActiveSwitch', 'codActiveLabel');
    // ✅ Setup for New Terms Switch
    setupSwitch('sslTermsSwitch', 'sslTermsLabel');

</script>
@endpush