<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $ln_pg->title1 ?? 'Premium Product Landing Page' }}</title>
    
    <meta name="csrf-token" content="{{ csrf_token() }}">

    {{-- Fonts & Icons --}}
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    
    {{-- Bootstrap & Owl Carousel CSS --}}
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.theme.default.min.css">

    @php
        $information = \App\Models\Information::first();
        // Theme Colors
        $primaryColor    = $ln_pg->theme_primary_col ?? '#d35400'; 
        $darkBg          = '#2c1e16'; 
        $lightBg         = '#fdfbf7'; 
        
        $productId = $product->id ?? 0;
        $productName = $product->name ?? '';
        $contentCategory = $product?->category?->name ?? 'Landing Page';
        $sslActive = $information->ssl_active ?? 0;
        $pixelId = setting('fb_pixel_id') ?? null;
        $phoneNumber = $ln_pg->phone ?? '';

        // ✅ FIX: সব প্রাইস intval() দিয়ে পূর্ণসংখ্যা করা হয়েছে
        $defaultPrice = 0; $regularStrikePrice = 0; 
        if (isset($product->after_discount) && $product->after_discount > 0) {
            $defaultPrice = intval($product->after_discount); 
            $regularStrikePrice = intval($product->sell_price); 
        } elseif (isset($product->sell_price) && $product->sell_price > 0) {
            $defaultPrice = intval($product->sell_price); 
            $regularStrikePrice = ($product->price > $product->sell_price) ? intval($product->price) : 0;
        } else { 
            $defaultPrice = intval($product->price ?? 0); 
        }
        $defaultStock = $product->stock_quantity ?? 0;

        $sizes = collect(); $colors = collect(); $varMatrix = [];
        if($product && $product->variations->count() > 0) {
            foreach($product->variations as $v) {
                if($v->size) $sizes->push($v->size); if($v->color) $colors->push($v->color);
                
                // ✅ FIX: ভেরিয়েশন প্রাইসও পূর্ণসংখ্যা করা হয়েছে
                $vPrice = (isset($v->after_discount_price) && $v->after_discount_price > 0) ? intval($v->after_discount_price) : intval($v->price ?? $defaultPrice);
                
                $varMatrix["{$v->size_id}_{$v->color_id}"] = ['variation_id' => $v->id, 'price' => $vPrice, 'stock' => $v->stocks->sum('quantity')];
            }
            $sizes = $sizes->unique('id')->values(); $colors = $colors->unique('id')->values();
        }
        
        $rawSliderImages = collect($ln_pg->images ? $ln_pg->images->all() : []);
        $sliderImages = $rawSliderImages;
        if($rawSliderImages->count() > 0 && $rawSliderImages->count() < 4) {
            $sliderImages = $rawSliderImages->merge($rawSliderImages)->merge($rawSliderImages);
        }

        $reviewImages = collect($ln_pg->review_images ? $ln_pg->review_images->all() : []);
        $bgImage = $ln_pg->landing_bg ? asset('landing_pages/'.$ln_pg->landing_bg) : asset('frontend/images/default-bg.jpg');
    @endphp

    <style>
        :root { --brand-color: {{ $primaryColor }}; --dark-bg: {{ $darkBg }}; --light-bg: {{ $lightBg }}; }
        
        html { height: 100%; }
        body { 
            font-family: 'Hind Siliguri', sans-serif; 
            background: var(--light-bg); 
            color: #2c3e50; 
            overflow-x: hidden; 
            margin: 0;
            padding: 0;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }

        .flex-grow-1 { flex: 1; width: 100%; }
        footer { margin-top: auto; margin-bottom: 0 !important; }

        /* ================= 1. HERO SECTION ================= */
        .hero-fullscreen { position: relative; width: 100%; min-height: 100vh; display: flex; align-items: center; justify-content: center; flex-direction: column; padding: 80px 15px; overflow: hidden; background-color: var(--dark-bg); }
        .hero-bg-blur { position: absolute; top: -5%; left: -5%; width: 110%; height: 110%; background-image: url('{{ $bgImage }}'); background-size: cover; background-position: center; filter: blur(12px); z-index: 1; }
        .hero-overlay { position: absolute; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.6); z-index: 2; }
        .hero-content-wrapper { position: relative; z-index: 3; width: 100%; max-width: 800px; text-align: center; }

        .hero-title { font-size: clamp(28px, 6vw, 48px); font-weight: 800; color: #f39c12; margin-bottom: 10px; line-height: 1.4; text-shadow: 2px 2px 10px rgba(0,0,0,0.8); }
        .hero-subtitle { font-size: clamp(16px, 4vw, 22px); font-weight: 500; color: #fff; margin-bottom: 40px; line-height: 1.5; text-shadow: 1px 1px 5px rgba(0,0,0,0.8); }

        .floating-price-card { background: rgba(255, 255, 255, 0.95); border-radius: 20px; padding: 40px 25px; text-align: center; border: 2px solid #f39c12; max-width: 500px; margin: 0 auto; animation: cardGlow 2s infinite alternate; }
        @keyframes cardGlow { 0% { box-shadow: 0 0 15px rgba(243, 156, 18, 0.4); transform: scale(1); } 100% { box-shadow: 0 0 35px rgba(243, 156, 18, 0.9); transform: scale(1.02); } }

        .countdown-container { background: {{ $ln_pg->countdown_bg_color ?? '#fff3e0' }}; border: 2px dashed #e67e22; border-radius: 12px; padding: 15px; margin-bottom: 20px; width: 100%; }
        .countdown-title { font-size: 16px; font-weight: 800; color: #d35400; margin-bottom: 10px; display: block; animation: pulse 1.5s infinite;}
        .timer-box { display: flex; gap: 8px; justify-content: center; }
        .time-block { background: linear-gradient(to bottom, #e67e22, #d35400); color: {{ $ln_pg->countdown_text_color ?? '#fff' }}; padding: 10px 15px; border-radius: 8px; font-weight: 800; font-size: 26px; min-width: 65px; box-shadow: 0 3px 10px rgba(211, 84, 0, 0.4);}
        .time-label { font-size: 11px; font-weight: 600; margin-top: 5px; display: block;}
        
        .regular-price-crossed { text-decoration: line-through; color: #95a5a6; font-size: 18px; font-weight: 700; display: block; margin-bottom: 5px;}
        .offer-price-highlight { font-size: clamp(32px, 8vw, 45px); font-weight: 900; color: #d35400; line-height: 1; margin-bottom: 15px; display: block; }
        
        .btn-glowing { background: {{ $ln_pg->hero_btn_bg_color ?? 'linear-gradient(135deg, #f39c12, #d35400)' }}; color: {{ $ln_pg->hero_btn_text_color ?? '#fff' }} !important; font-weight: 800; font-size: clamp(18px, 5vw, 22px); padding: 15px 25px; border-radius: 50px; border: none; display: flex; align-items: center; justify-content: center; gap: 10px; width: 100%; text-decoration: none; position: relative; z-index: 1; cursor: pointer; animation: btnGlow 1.5s infinite alternate; transition: all 0.3s ease; }
        @keyframes btnGlow { 0% { box-shadow: 0 0 5px #f39c12; } 100% { box-shadow: 0 0 25px #f39c12; } }
        @keyframes pulse { 0% { transform: scale(1); opacity: 1; } 50% { transform: scale(1.05); opacity: 0.8; } 100% { transform: scale(1); opacity: 1; }}
        .btn-glowing:hover { transform: translateY(-3px); }

        /* ================= 2. SEPARATE DESCRIPTION CARD ================= */
        .description-card { background: #fff; max-width: 900px; margin: -50px auto 60px auto; position: relative; z-index: 10; border-radius: 20px; padding: 40px 30px; box-shadow: 0 15px 40px rgba(0,0,0,0.08); border-top: 5px solid #d35400; font-size: 17px; line-height: 1.8; color: #444; text-align: center; }
        .description-card img { max-width: 100%; border-radius: 12px; margin: 15px 0;}

        /* ================= GENERAL SECTIONS ================= */
        .section-title-wrapper { text-align: center; margin: 20px 0 40px 0; }
        .section-badge { display: inline-block; background: #fdebd0; color: #d35400; font-size: 14px; font-weight: 700; padding: 6px 20px; border-radius: 50px; margin-bottom: 15px; border: 1px solid #fad7a1;}
        .section-title { font-size: clamp(24px, 6vw, 32px); font-weight: 800; color: var(--dark-bg); margin: 0; line-height: 1.3;}
        .feature-container { max-width: 1100px; margin: 0 auto 60px auto; padding: 0 15px;}

        /* ================= 3. PROMISE SECTION ================= */
        .promise-slider-wrapper { position: relative; border-radius: 20px; padding: 10px; background: #fff; box-shadow: 0 10px 30px rgba(0,0,0,0.05);}
        .single-product-img { width: 100%; border-radius: 15px; border: 2px solid #eee;}
        .badge-khati { position: absolute; bottom: -10px; right: 20px; background: #f39c12; color: #fff; padding: 8px 20px; border-radius: 50px; font-weight: 800; font-size: 16px; box-shadow: 0 5px 15px rgba(243, 156, 18, 0.4); z-index: 10;}
        
        .promise-item { background: #fff; border: 1px solid #eee; border-radius: 12px; padding: 15px 20px; display: flex; align-items: center; gap: 15px; margin-bottom: 15px; box-shadow: 0 2px 10px rgba(0,0,0,0.02); transition: 0.3s;}
        .promise-item:hover { border-color: #f39c12; transform: translateX(5px); }
        .promise-icon { background: #fdebd0; color: #d35400; width: 40px; height: 40px; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-size: 16px; flex-shrink: 0; }
        .promise-text h6 { font-weight: 800; color: #2c3e50; margin-bottom: 2px; font-size: 16px;}
        .promise-text p { font-size: 13px; color: #7f8c8d; margin: 0; line-height: 1.4;}

        .negative-box { background: #fffaf6; border: 1px dashed #e67e22; border-radius: 12px; padding: 20px; margin-top: 25px; }
        .negative-box h6 { font-weight: 800; color: #2c3e50; font-size: 15px; margin-bottom: 15px; }
        .negative-pill { background: #fff; border: 1px solid #eee; padding: 6px 15px; border-radius: 50px; font-size: 13px; font-weight: 700; color: #555; box-shadow: 0 2px 5px rgba(0,0,0,0.02); display: inline-flex; align-items: center; gap: 5px;}
        .negative-pill i { color: #e74c3c; font-size: 14px;}

        /* ================= 4. HOW TO IDENTIFY ================= */
        .identify-row { display: flex; flex-wrap: wrap; align-items: stretch; }
        .identify-grid { display: grid; grid-template-columns: repeat(2, 1fr); gap: 15px; height: 100%; align-content: space-between;}
        .identify-box { background: #fff; border: 1px solid #eee; border-radius: 15px; padding: 25px 15px; box-shadow: 0 5px 15px rgba(0,0,0,0.03); transition: 0.3s; display: flex; flex-direction: column; align-items: center; text-align: center; justify-content: center; height: 100%;}
        .identify-box:hover { border-color: #f39c12; transform: translateY(-3px); box-shadow: 0 8px 20px rgba(243, 156, 18, 0.1); }
        .identify-icon { width: 45px; height: 45px; background: #fdf2e9; color: #d35400; border-radius: 10px; display: flex; align-items: center; justify-content: center; font-size: 20px; margin-bottom: 15px; }
        .identify-box h6 { font-weight: 800; color: #2c3e50; font-size: 16px; margin-bottom: 5px; }
        .identify-box p { font-size: 13px; color: #7f8c8d; margin: 0; line-height: 1.4; }

        .slider-wrapper-h100 { height: 100%; display: flex; align-items: stretch; justify-content: center; background: #fff; box-shadow: 0 5px 15px rgba(0,0,0,0.05); border-radius: 15px; overflow: hidden; padding: 0;}
        .slider-wrapper-h100 .owl-carousel { height: 100%; display: flex; flex-direction: column;}
        .slider-wrapper-h100 .owl-stage-outer, .slider-wrapper-h100 .owl-stage, .slider-wrapper-h100 .owl-item { height: 100%; }
        .slider-wrapper-h100 .item { height: 100%; width: 100%; }
        .product-slider-img { width: 100%; height: 100%; object-fit: cover; border-radius: 15px; display: block;} 
        
        .owl-theme .owl-dots .owl-dot span { width: 10px; height: 10px; margin: 5px; background: #d6d6d6; }
        .owl-theme .owl-dots .owl-dot.active span { background: #e67e22; width: 25px; transition: 0.3s; }

        /* DARK TRUST SECTION */
        .dark-trust-section { background: var(--dark-bg); padding: 70px 15px; color: #fff; text-align: center; margin-bottom: 60px; border-radius: 20px; margin-left: 15px; margin-right: 15px;}
        .trust-badge-box { background: rgba(255,255,255,0.05); border: 1px solid rgba(255,255,255,0.1); border-radius: 15px; padding: 25px 15px; transition: 0.3s; height: 100%;}
        .trust-badge-box:hover { background: rgba(255,255,255,0.15); transform: translateY(-5px); border-color: #e67e22;}
        .trust-badge-box i { font-size: 40px; color: #f39c12; margin-bottom: 15px; }
        .trust-badge-box h6 { font-weight: 700; margin: 0; font-size: 16px; }

        /* ================= 5. TEXT BASED REVIEW ================= */
        .stats-row { display: flex; justify-content: center; gap: 40px; flex-wrap: wrap; margin-bottom: 40px; }
        .stat-box { text-align: center; }
        .stat-box h3 { font-size: 38px; font-weight: 900; color: #d35400; margin-bottom: 5px; }
        .stat-box p { font-size: 15px; color: #475569; font-weight: 600; margin: 0; }

        #textReviewCarousel .owl-stage { display: flex; align-items: stretch; }
        #textReviewCarousel .owl-item { display: flex; }
        .item-flex { width: 100%; display: flex; padding: 10px; }
        
        .testimonial-card { width: 100%; background: #fff; border: 1px solid #e2e8f0; border-radius: 15px; padding: 30px; box-shadow: 0 4px 15px rgba(0,0,0,0.03); transition: 0.3s; display: flex; flex-direction: column; justify-content: space-between; text-align: left; }
        .testimonial-card:hover { transform: translateY(-5px); border-color: #fdebd0; box-shadow: 0 10px 25px rgba(0,0,0,0.08);}
        .quote-icon { font-size: 35px; color: #fef0d7; margin-bottom: 10px; line-height: 1; }
        .stars { color: #0f172a; font-size: 13px; margin-bottom: 15px; }
        .review-text { font-size: 15px; color: #0f172a; font-weight: 600; line-height: 1.6; margin-bottom: 25px; flex-grow: 1; }
        .reviewer-info { display: flex; align-items: center; gap: 15px; margin-top: auto;}
        .avatar-initial { width: 45px; height: 45px; background: #fdf2e9; color: #d35400; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-size: 18px; font-weight: 800; }
        .reviewer-details h6 { margin: 0; font-size: 15px; font-weight: 800; color: #0f172a;}
        .reviewer-details span { font-size: 13px; color: #64748b; font-weight: 500;}

        /* FAQ */
        .faq-item { background: #fff; border-radius: 10px; margin-bottom: 12px; box-shadow: 0 2px 8px rgba(0,0,0,0.05); border: 1px solid #eee;}
        .faq-header { padding: 18px 20px; cursor: pointer; display: flex; justify-content: space-between; align-items: center; font-weight: 700; color: #2c3e50; font-size: 16px; transition: 0.3s;}
        .faq-header:hover { background: #fff3e0; color: #d35400; }
        .faq-header i { color: #e67e22; transition: 0.3s;}
        .faq-header.active i { transform: rotate(180deg); }
        .faq-body { padding: 0 20px 20px 20px; color: #555; display: none; line-height: 1.6; font-size: 15px;}

        /* ================= ORDER FORM ================= */
        .order-section-wrapper { max-width: 1000px; margin: 0 auto; padding: 0 15px; scroll-margin-top: 30px;}
        .order-form-container { background: #fdfbf7; border-radius: 20px; box-shadow: 0 15px 40px rgba(0,0,0,0.1); overflow: hidden; border: 3px solid #d35400;}
        .order-header { background: linear-gradient(to right, #d35400, #e67e22); color: #fff; padding: 18px 10px; text-align: center; font-size: clamp(18px, 5vw, 24px); font-weight: 800; line-height: 1.4; word-break: break-word; }
        .order-body { padding: 30px 20px; }
        
        .form-control, .form-select { border-radius: 8px; padding: 12px 15px; border: 1px solid #cbd5e1; background: #fff; font-size: 15px; font-weight: 500; transition: 0.3s;}
        .form-control:focus, .form-select:focus { border-color: #d35400; box-shadow: 0 0 0 3px rgba(211, 84, 0, 0.1); background: #fff; }
        .form-label { font-weight: 700; color: #2c3e50; font-size: 14px; margin-bottom: 8px;}
        
        .summary-box { background: #fff; border-radius: 12px; padding: 25px; border: 1px solid #cbd5e1; height: 100%; box-shadow: 0 5px 15px rgba(0,0,0,0.03);}
        .summary-img { width: 65px; height: 65px; border-radius: 8px; object-fit: cover; border: 1px solid #fad7a1; }
        .summary-title-text { font-size: 16px; font-weight: 700; color: #2c3e50; line-height: 1.4;}
        
        .qty-box { display: inline-flex; align-items: center; background: #fff; border-radius: 6px; border: 1px solid #cbd5e1; overflow: hidden; margin-top: 5px;}
        .qty-btn { background: #f8fafc; border: none; padding: 5px 15px; font-weight: bold; color: #d35400; font-size: 18px; cursor: pointer;}
        .qty-input { width: 40px; border: none; text-align: center; font-weight: 800; pointer-events: none; font-size: 15px; color: #2c3e50;}

        .calc-line { display: flex; justify-content: space-between; align-items: center; padding: 10px 0; border-bottom: 1px dashed #cbd5e1; font-weight: 600; color: #475569; font-size: 14px;}
        .calc-line.total { border-bottom: none; border-top: 2px solid #cbd5e1; font-size: 20px; font-weight: 800; color: #d35400; padding-top: 15px; margin-top: 5px;}

        .var-btn { border: 1px solid #cbd5e1; padding: 6px 12px; border-radius: 6px; cursor: pointer; background: #fff; font-weight: 600; font-size: 13px; transition: 0.2s; color: #475569;}
        .var-btn.active { background: #d35400; color: #fff; border-color: #d35400; }

        .info-box-left { background: #fff; border: 1px solid #e2e8f0; border-radius: 12px; padding: 20px; margin-bottom: 20px; box-shadow: 0 2px 10px rgba(0,0,0,0.02);}

        .payment-radio { display: none; } 
        .payment-card { border: 1px solid #cbd5e1; border-radius: 8px; padding: 12px; display: flex; align-items: center; cursor: pointer; margin-bottom: 10px; background: #fff; transition: 0.2s; }
        .payment-card i { font-size: 20px; margin-right: 10px; color: #94a3b8; }
        .payment-card b { font-size: 14px; color: #2c3e50; display: block; }
        .payment-radio:checked + .payment-card { border-color: #d35400; background: #fffaf6; }
        .payment-radio:checked + .payment-card i { color: #d35400; }

        /* ✅✅✅ OTP Modal CSS Added Below ✅✅✅ */
        #otpModal { z-index: 99999 !important; }
        .otp-modal-content { border: none !important; border-radius: 20px !important; background: #ffffff; box-shadow: 0 10px 40px rgba(0, 0, 0, 0.2); text-align: center; overflow: hidden; position: relative; }
        .otp-modal-content::before { content: ""; position: absolute; top: 0; left: 0; right: 0; height: 6px; background: linear-gradient(90deg, #E2136E, #F6921E); }
        .otp-icon-box { width: 80px; height: 80px; background: #fdf2f7; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 10px auto 20px; color: #E2136E; }
        .otp-input { width: 100%; letter-spacing: 15px; text-align: center; font-size: 28px; font-weight: bold; color: #333; border: 2px solid #eee !important; border-radius: 12px !important; background: #fafafa; height: 65px; transition: all 0.3s ease; position: relative; z-index: 999999 !important; }
        .otp-input:focus { border-color: #E2136E !important; background: #fff; box-shadow: 0 5px 15px rgba(226, 19, 110, 0.1) !important; outline: none; }
        .btn-verify { background: linear-gradient(135deg, #E2136E 0%, #C90D5E 100%); border: none; padding: 12px; font-size: 18px; border-radius: 12px; box-shadow: 0 8px 20px rgba(226, 19, 110, 0.3); width: 100%; color: white; font-family: 'Hind Siliguri', sans-serif; }
        .btn-verify:hover { transform: translateY(-2px); box-shadow: 0 12px 25px rgba(226, 19, 110, 0.4); }

        @media (max-width: 991px) {
            .identify-grid { grid-template-columns: 1fr; } 
            .identify-row { flex-direction: column; }
            .slider-wrapper-h100 { height: 350px; margin-top: 20px;} 
        }

        /* MOBILE FIXES */
        @media (max-width: 768px) {
            .hero-fullscreen { min-height: 100vh; padding: 40px 15px 0 15px; }
            .description-card { margin-top: -30px; padding: 25px 15px; font-size: 15px;}
            .floating-price-card { padding: 25px 15px; }
            .offer-price-highlight { font-size: 35px; }
            .time-block { padding: 5px 8px; font-size: 22px; min-width: 55px; }
            
            .stats-row { gap: 20px; flex-direction: row; align-items: center; }
            .stat-box h3 { font-size: 28px; }
            
            .order-body { padding: 20px 15px; }
            .dark-trust-section { padding: 40px 15px; margin-left: 0; margin-right: 0; border-radius: 0;}
            
            body { padding-bottom: 10px !important; } 
        }
    </style>
    
    {{-- PIXEL SCRIPTS --}}
    @if(!empty($pixelId))
        <script>
        !function(f,b,e,v,n,t,s){if(f.fbq)return;n=f.fbq=function(){n.callMethod?n.callMethod.apply(n,arguments):n.queue.push(arguments)};if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';n.queue=[];t=b.createElement(e);t.async=!0;t.src=v;s=b.getElementsByTagName(e)[0];s.parentNode.insertBefore(t,s)}(window, document,'script','https://connect.facebook.net/en_US/fbevents.js');
        fbq('init', '{{ $pixelId }}'); fbq('track', 'PageView');
        fbq('track', 'ViewContent', { content_ids: ['{{ $productId }}'], content_type: 'product', content_name: '{{ $productName }}', value: {{ $defaultPrice }}, currency: 'BDT' });
        fbq('track', 'InitiateCheckout', { content_ids: ['{{ $productId }}'], num_items: 1, value: {{ $defaultPrice }}, currency: 'BDT' });
        </script>
        <noscript><img height="1" width="1" style="display:none" src="https://www.facebook.com/tr?id={{ $pixelId }}&ev=PageView&noscript=1"/></noscript>
    @endif
</head>
<body>

<main class="flex-grow-1">

{{-- 1. FULL SCREEN HERO SECTION WITH BLUR AND CENTERED CARD --}}
<div class="hero-fullscreen">
    <div class="hero-bg-blur"></div>
    <div class="hero-overlay"></div>
    
    <div class="hero-content-wrapper">
        @if(!empty($ln_pg->title1)) <h1 class="hero-title">{{ $ln_pg->title1 }}</h1> @endif
        @if(!empty($ln_pg->left_side_title)) <p class="hero-subtitle">{{ $ln_pg->left_side_title }}</p> @endif
        
        <div class="floating-price-card">
            <div class="countdown-container">
                <span class="countdown-title"><i class="fas fa-bolt"></i> {{ $ln_pg->countdown_title ?? 'অফারটি শেষ হতে আর বাকি মাত্র' }}</span>
                <div class="timer-box" id="countdown">
                    <div class="time-block"><span id="hours">05</span><span class="time-label">ঘণ্টা</span></div>
                    <div class="time-block"><span id="minutes">00</span><span class="time-label">মিনিট</span></div>
                    <div class="time-block"><span id="seconds">00</span><span class="time-label">সেকেন্ড</span></div>
                </div>
            </div>

            @if($regularStrikePrice > 0) <span class="regular-price-crossed">{{ $ln_pg->old_price_text ?? 'পূর্বের মূল্যঃ' }} {{ $regularStrikePrice }} ৳</span> @endif
            <span class="offer-price-highlight">{{ $ln_pg->new_price_text ?? 'বর্তমান মূল্যঃ' }} {{ $defaultPrice }} ৳</span>
            
            <button onclick="scrollToForm()" class="btn-glowing mt-3">
                <i class="fas fa-shopping-cart"></i> {{ $ln_pg->btn_text_hero ?: 'অর্ডার করতে ক্লিক করুন' }}
            </button>
        </div>
    </div>
</div>

{{-- 2. SEPARATE DESCRIPTION CARD --}}
@if(!empty($ln_pg->left_side_desc))
<div class="container px-3">
    <div class="description-card">
        {!! $ln_pg->left_side_desc !!}
    </div>
</div>
@endif

{{-- 3. PROMISE SECTION (LEFT IMAGE, RIGHT LIST) --}}
@if(!empty($ln_pg->promise_title))
<div class="feature-container" style="margin-top: 20px;">
    <div class="section-title-wrapper">
        <div class="section-badge">{{ $ln_pg->promise_badge ?? 'কেন আমাদের প্রোডাক্ট সেরা?' }}</div>
        <h2 class="section-title">{{ $ln_pg->promise_title ?? 'আমাদের প্রতিশ্রুতি' }}</h2>
    </div>

    <div class="row g-4 align-items-center">
        <div class="col-lg-5">
            <div class="promise-slider-wrapper">
                @if($ln_pg->right_product_image)
                    <img src="{{ asset('landing_pages/'.$ln_pg->right_product_image) }}" class="single-product-img" alt="Product">
                @else
                    <img src="{{ getImage('products', $product->image) }}" class="single-product-img" alt="Product">
                @endif
                <div class="badge-khati"><i class="fas fa-medal"></i> {{ $ln_pg->promise_img_badge ?? '১০০% খাঁটি' }}</div>
            </div>
        </div>

        <div class="col-lg-7 pl-lg-4">
            {{-- Promise 1 --}}
            @if(!empty($ln_pg->promise_1_title))
            <div class="promise-item">
                <div class="promise-icon"><i class="fas fa-check"></i></div>
                <div class="promise-text">
                    <h6>{{ $ln_pg->promise_1_title }}</h6>
                    <p>{{ $ln_pg->promise_1_desc }}</p>
                </div>
            </div>
            @endif

            {{-- Promise 2 --}}
            @if(!empty($ln_pg->promise_2_title))
            <div class="promise-item">
                <div class="promise-icon"><i class="fas fa-check"></i></div>
                <div class="promise-text">
                    <h6>{{ $ln_pg->promise_2_title }}</h6>
                    <p>{{ $ln_pg->promise_2_desc }}</p>
                </div>
            </div>
            @endif

            {{-- Promise 3 --}}
            @if(!empty($ln_pg->promise_3_title))
            <div class="promise-item">
                <div class="promise-icon"><i class="fas fa-check"></i></div>
                <div class="promise-text">
                    <h6>{{ $ln_pg->promise_3_title }}</h6>
                    <p>{{ $ln_pg->promise_3_desc }}</p>
                </div>
            </div>
            @endif

            {{-- Negative Points --}}
            @if(!empty($ln_pg->negative_tags))
            <div class="negative-box">
                <h6>{{ $ln_pg->negative_title ?: 'আমাদের পণ্যে যা নেই:' }}</h6>
                <div class="d-flex flex-wrap gap-2">
                    @php $tags = explode(',', $ln_pg->negative_tags); @endphp
                    @foreach($tags as $tag)
                        @if(trim($tag) != '')
                            <span class="negative-pill"><i class="fas fa-times-circle text-danger"></i> {{ trim($tag) }}</span>
                        @endif
                    @endforeach
                </div>
            </div>
            @endif
        </div>
    </div>
</div>
@endif

{{-- 4. HOW TO IDENTIFY --}}
@if(!empty($ln_pg->identify_title))
<div class="feature-container" style="margin-top: 80px;">
    <div class="section-title-wrapper">
        <div class="section-badge">{{ $ln_pg->identify_badge ?? 'খাঁটি প্রোডাক্ট চেনার উপায়' }}</div>
        <h2 class="section-title">{{ $ln_pg->identify_title ?? 'আসল পণ্য চেনার উপায়' }}</h2>
        <p class="text-muted mt-2 fw-bold">{{ $ln_pg->identify_subtitle ?? 'এই লক্ষণগুলো দেখলেই বুঝবেন পণ্য খাঁটি কিনা' }}</p>
    </div>

    <div class="row g-4 identify-row">
        <div class="col-lg-6 order-2 order-lg-1">
            <div class="identify-grid">
                {{-- Loop through id_1 to id_8 --}}
                @for($i=1; $i<=8; $i++)
                    @if(!empty($ln_pg->{'id_'.$i.'_title'}))
                    @php 
                        $iconClass = $ln_pg->{'id_'.$i.'_icon'} ?: 'fa-check';
                        if(!preg_match('/^(fas|far|fab|fal|fa-solid|fa-regular|fa-brands)\s/', $iconClass)) {
                            $iconClass = 'fas ' . $iconClass;
                        }
                    @endphp
                    <div class="identify-box">
                        <div class="identify-icon"><i class="{{ $iconClass }} fa-fw"></i></div>
                        <h6>{{ $ln_pg->{'id_'.$i.'_title'} }}</h6>
                        <p>{{ $ln_pg->{'id_'.$i.'_desc'} }}</p>
                    </div>
                    @endif
                @endfor
            </div>
        </div>

        <div class="col-lg-6 order-1 order-lg-2">
            <div class="slider-wrapper-h100">
                @if($sliderImages->count() > 0)
                    <div class="owl-carousel owl-theme h-100-carousel" id="productGallery">
                        @foreach($sliderImages as $img)
                            <div class="item"><img src="{{ asset('landing_sliders/'.$img->image) }}" class="product-slider-img" alt="Product Image"></div>
                        @endforeach
                    </div>
                @else
                    <img src="{{ getImage('products', $product->image) }}" class="product-slider-img" alt="Product">
                @endif
            </div>
        </div>
    </div>
</div>
@endif

{{-- 5. DARK TRUST BADGE SECTION --}}
<div class="dark-trust-section">
    <div class="container">
        <h2 class="section-title text-white mb-5">{{ $ln_pg->dhamaka_title ?: 'ঝুঁকিমুক্ত অর্ডার করুন' }}</h2>
        
        <div class="row g-4 justify-content-center mb-5">
            <div class="col-6 col-md-3">
                <div class="trust-badge-box">
                    <i class="fas fa-thumbs-up fa-fw"></i>
                    <h6>উন্নত মান</h6>
                </div>
            </div>
            <div class="col-6 col-md-3">
                <div class="trust-badge-box">
                    <i class="fas fa-hand-holding-usd fa-fw"></i>
                    <h6>ক্যাশ অন ডেলিভারি</h6>
                </div>
            </div>
            <div class="col-6 col-md-3">
                <div class="trust-badge-box">
                    <i class="fas fa-shipping-fast fa-fw"></i>
                    <h6>দ্রুত ডেলিভারি</h6>
                </div>
            </div>
            <div class="col-6 col-md-3">
                <div class="trust-badge-box">
                    <i class="fas fa-headset fa-fw"></i>
                    <h6>২৪/৭ সাপোর্ট</h6>
                </div>
            </div>
        </div>
    </div>
</div>

{{-- 6. TEXT BASED REVIEW CAROUSEL --}}
@if(!empty($ln_pg->review_title))
<div class="feature-container" style="margin-top: 80px;">
    <div class="section-title-wrapper">
        <div class="section-badge">{{ $ln_pg->review_badge ?? 'গ্রাহকদের মতামত' }}</div>
        <h2 class="section-title mb-2">{{ $ln_pg->review_title ?? 'গ্রাহকদের মতামত' }}</h2>
        <p class="text-muted fw-bold">{{ $ln_pg->review_subtitle ?? 'হাজারো সন্তুষ্ট পরিবার আমাদের সাথে আছে' }}</p>
    </div>

    <div class="stats-row">
        @for($i=1; $i<=3; $i++)
            @if(!empty($ln_pg->{'stat_'.$i.'_num'}))
            <div class="stat-box">
                <h3>{{ $ln_pg->{'stat_'.$i.'_num'} }}</h3>
                <p>{{ $ln_pg->{'stat_'.$i.'_text'} }}</p>
            </div>
            @endif
        @endfor
    </div>

    <div class="owl-carousel owl-theme mt-4" id="textReviewCarousel">
        @for($i=1; $i<=4; $i++)
            @if(!empty($ln_pg->{'rev_'.$i.'_text'}))
            <div class="item-flex">
                <div class="testimonial-card">
                    <div>
                        <div class="quote-icon"><i class="fas fa-quote-left"></i></div>
                        <div class="stars"><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i></div>
                        <p class="review-text">"{{ $ln_pg->{'rev_'.$i.'_text'} }}"</p>
                    </div>
                    <div class="reviewer-info">
                        <div class="avatar-initial">{{ mb_substr($ln_pg->{'rev_'.$i.'_name'} ?? 'C', 0, 1) }}</div>
                        <div class="reviewer-details">
                            <h6>{{ $ln_pg->{'rev_'.$i.'_name'} }}</h6>
                            <span>{{ $ln_pg->{'rev_'.$i.'_loc'} }}</span>
                        </div>
                    </div>
                </div>
            </div>
            @endif
        @endfor
    </div>
</div>
@endif

{{-- 7. ORDER FORM SECTION --}}
<div class="order-section-wrapper" id="orderForm">
    <div class="order-form-container">
        <div class="order-header"><i class="fas fa-clipboard-list me-2"></i> {{ $ln_pg->form_title ?: 'অর্ডার কনফার্ম করতে নিচের ফর্মটি পূরণ করুন' }}</div>
        <div class="order-body">
            <form id="checkoutForm" action="{{ route('front.storelandData') }}" method="POST">
                @csrf
                <input type="hidden" name="prd_id" value="{{ $product->id }}">
                <input type="hidden" name="variation_id" id="variation_id" value="">
                <input type="hidden" name="amount" id="amount" value="">
                <input type="hidden" name="final_amount" id="final_amount" value="">
                <input type="hidden" name="purchase_event_id" id="purchase_event_id" value="">
                
                <script> window.varMatrix = @json($varMatrix); </script>
                <input type="hidden" id="max_stock" value="{{ $defaultStock }}">

                <div class="row g-4">
                    <div class="col-12 col-lg-7">
                        
                        <div class="info-box-left">
                            <h5 class="fw-bold mb-4" style="color: #d35400;"><i class="fas fa-user-edit me-2"></i> ১. বিলিং ও শিপিং তথ্য:</h5>
                            <div class="mb-3"><label class="form-label">আপনার নাম *</label><input type="text" name="first_name" class="form-control" placeholder="নাম লিখুন" required></div>
                            <div class="mb-3"><label class="form-label">মোবাইল নাম্বার *</label><input type="tel" name="mobile" id="customer_mobile" class="form-control" placeholder="017XXXXXXXX" required maxlength="11"></div>
                            <div class="mb-3"><label class="form-label">সম্পূর্ণ ঠিকানা *</label><textarea name="shipping_address" id="customer_address" class="form-control" rows="2" placeholder="বাসা নং, রোড নং, এলাকা, থানা, জেলা" required></textarea></div>
                            <div class="mb-3"><label class="form-label">ডেলিভারি এলাকা নির্বাচন করুন *</label>
                                <select name="delivery_charge_id" id="delivery_charge" class="form-select" required>
                                    <option value="" disabled selected>এলাকা নির্বাচন করুন...</option>
                                    {{-- ✅ FIX: ডেলিভারি চার্জ intval() করা হয়েছে --}}
                                    @foreach($charges as $charge) <option value="{{ $charge->id }}" data-charge="{{ intval($charge->amount) }}">{{ $charge->title }} - {{ intval($charge->amount) }} ৳</option> @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="info-box-left">
                            <h5 class="fw-bold mb-3" style="color: #d35400;"><i class="fas fa-money-check-alt me-2"></i> {{ ($sizes->count() > 0 || $colors->count() > 0) ? '৩' : '২' }}. পেমেন্ট মাধ্যম:</h5>
                            <label class="d-flex align-items-center cursor-pointer mb-2">
                                <input type="radio" name="payment_method" value="cod" checked class="me-3" style="width: 20px; height: 20px; accent-color: #d35400;">
                                <div><b style="color: #2c3e50; font-size:16px;">ক্যাশ অন ডেলিভারি</b><small class="d-block text-muted mt-1">পণ্য হাতে পেয়ে টাকা পরিশোধ করুন</small></div>
                            </label>
                            @if($sslActive == 1)
                            <div class="border-top my-3"></div>
                            <label class="d-flex align-items-center cursor-pointer">
                                <input type="radio" name="payment_method" value="sslcommerz" class="me-3" style="width: 20px; height: 20px; accent-color: #d35400;">
                                <div><b style="color: #2c3e50; font-size:16px;">অনলাইন পেমেন্ট</b><small class="d-block text-muted mt-1">বিকাশ, নগদ, রকেট বা কার্ডের মাধ্যমে পেমেন্ট</small></div>
                            </label>
                            @endif
                        </div>
                    </div>
                    
                    <div class="col-12 col-lg-5">
                        <div class="summary-box sticky-top" style="top: 20px;">
                            <h5 class="fw-bold mb-4" style="color: #d35400;"><i class="fas fa-shopping-basket me-2"></i> অর্ডারের সারাংশ:</h5>
                            
                            <div class="d-flex align-items-center mb-4 bg-white p-3 border rounded-3 shadow-sm">
                                <img src="{{ getImage('products', $product->image) }}" class="summary-img me-3">
                                <div>
                                    <div class="summary-title-text">{{ $product->name }}</div>
                                    <div class="text-danger fw-bold mt-2 fs-5"><span id="unit_price_display">{{ $defaultPrice }}</span> ৳</div>
                                    <input type="hidden" id="unit_price" value="{{ $defaultPrice }}">
                                </div>
                            </div>
                            
                            @if($sizes->count() > 0 || $colors->count() > 0)
                            <div class="info-box-left" style="box-shadow: none; border: 1px dashed #cbd5e1; padding: 15px;">
                                <h5 class="fw-bold mb-3" style="color: #d35400; font-size: 16px;"><i class="fas fa-palette me-2"></i> ২. প্রোডাক্ট অপশন:</h5>
                                @if($sizes->count() > 0)
                                    <div class="mb-3"><label class="form-label mb-2">সাইজ সিলেক্ট করুন:</label><div class="d-flex flex-wrap gap-2">@foreach($sizes as $size) <div class="var-btn var-size-btn" data-id="{{ $size->id ?? $size['id'] }}">{{ $size->name ?? $size->title ?? 'N/A' }}</div> @endforeach</div></div>
                                @endif
                                @if($colors->count() > 0)
                                    <div class="mb-2"><label class="form-label mb-2">কালার সিলেক্ট করুন:</label><div class="d-flex flex-wrap gap-2">@foreach($colors as $color) <div class="var-btn var-color-btn" data-id="{{ $color->id ?? $color['id'] }}">{{ $color->name ?? $color->title ?? 'N/A' }}</div> @endforeach</div></div>
                                @endif
                            </div>
                            @endif
                            
                            {{-- ✅ COUPON SECTION ADDED HERE ✅ --}}
                            @if(isset($information->coupon_visibility) && $information->coupon_visibility == 1)
                            <div class="coupon-box mt-3 mb-3 p-3" style="background: #fdfbf7; border: 1px dashed #d35400; border-radius: 8px;">
                                <label class="form-label mb-2" style="font-size: 14px; font-weight: 700; color: #d35400;"><i class="fas fa-ticket-alt me-1"></i> কুপন কোড (যদি থাকে)</label>
                                <div class="input-group">
                                    <input type="text" id="coupon_code" class="form-control" placeholder="কোড লিখুন" style="border-right: 0; box-shadow: none;">
                                    <button type="button" class="btn text-white px-3" onclick="applyCouponLand()" style="background: #d35400; font-weight: 700;">APPLY</button>
                                </div>
                                <small id="coupon_msg" class="d-block mt-2 fw-bold"></small>
                            </div>
                            @endif

                            @php $sessionDiscount = session('coupon_discount') ?? 0; @endphp
                            <input type="hidden" id="discount_amount" value="{{ $sessionDiscount }}">

                            <div class="calc-line mt-3"><span>পরিমাণ</span><div class="qty-box"><button type="button" class="qty-btn" id="qty_minus">-</button><input type="number" name="quantity" id="qty_input" class="qty-input" value="1" readonly><button type="button" class="qty-btn" id="qty_plus">+</button></div></div>
                            <div class="calc-line"><span>সাবটোটাল</span><span><span id="calc_subtotal">{{ $defaultPrice }}</span> ৳</span></div>
                            <div class="calc-line"><span>ডেলিভারি চার্জ</span><span>+ <span id="calc_shipping">0</span> ৳</span></div>
                            
                            {{-- ✅ DISCOUNT CALCULATION ROW ✅ --}}
                            <div class="calc-line" id="discount_row" style="{{ $sessionDiscount > 0 ? '' : 'display:none;' }}">
                                <span style="color: #27ae60;">ডিসকাউন্ট</span>
                                <span style="color: #27ae60;">- <span id="calc_discount">{{ $sessionDiscount }}</span> ৳</span>
                            </div>

                            <div class="calc-line total"><span>সর্বমোট বিল</span><span><span id="calc_total">{{ $defaultPrice }}</span> ৳</span></div>

                            <button type="submit" id="submit_btn" class="btn-glowing mt-4" style="width: 100%; border-radius: 12px; font-size: 20px; padding: 15px;">অর্ডার কনফার্ম করুন <i class="fas fa-check-circle ms-2"></i></button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

{{-- 8. FAQ SECTION --}}
@if(!empty($ln_pg->faq_title))
<div class="feature-container" style="max-width: 800px; margin-top: 80px; margin-bottom: 60px;">
    <div class="section-title-wrapper">
        <div class="section-badge"><i class="fas fa-question-circle"></i> {{ $ln_pg->faq_badge ?? 'জিজ্ঞাসা' }}</div>
        <h2 class="section-title">{{ $ln_pg->faq_title ?? 'সচরাচর জিজ্ঞাসিত প্রশ্ন (FAQ)' }}</h2>
    </div>
    @for($i=1; $i<=4; $i++)
        @if(!empty($ln_pg->{'faq_'.$i.'_q'}))
        <div class="faq-item">
            <div class="faq-header">{{ $ln_pg->{'faq_'.$i.'_q'} }} <i class="fas fa-chevron-down"></i></div>
            <div class="faq-body">{{ $ln_pg->{'faq_'.$i.'_a'} }}</div>
        </div>
        @endif
    @endfor
</div>
@endif

{{-- ✅✅✅ OTP MODAL ADDED HERE ✅✅✅ --}}
<div class="modal fade" id="otpModal" data-bs-backdrop="static" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content otp-modal-content p-4">
      <div class="modal-header border-0 pb-0 justify-content-end">
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body text-center pt-0 pb-4">
        <div class="otp-icon-box"><i class="fas fa-shield-alt fa-2x"></i></div>
        <h4 class="fw-bold mb-2 otp-title">মোবাইল ভেরিফিকেশন</h4>
        <p class="otp-subtitle">আপনার <span class="fw-bold text-dark" id="otp_sent_number"></span> নাম্বারে কোড পাঠানো হয়েছে।</p>
        <div class="form-group mb-4">
            <input type="text" id="otp_input" maxlength="4" class="form-control otp-input" placeholder="____" autocomplete="one-time-code" inputmode="numeric">
            <small class="text-danger mt-2 d-block fw-bold" id="otp_error"></small>
        </div>
        <button type="button" class="btn-verify" onclick="verifyOtpNow()">যাচাই করুন (Verify)</button>
        <div class="text-center mt-3">
             <button type="button" class="btn btn-link text-decoration-none text-muted p-0 small" id="resendOtpBtn" onclick="sendOtpBeforeSubmit(true)">
                 কোড পাননি? <span class="text-primary fw-bold">আবার পাঠান</span>
             </button>
        </div>
      </div>
    </div>
  </div>
</div>

</main> 

{{-- DYNAMIC MAIN FOOTER INCLUDED --}}
@include('frontend.partials.footer')

{{-- SCRIPTS --}}
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script>

<script>
    // ✅✅✅ COUPON FUNCTION ✅✅✅
    window.applyCouponLand = function() {
        var code = $('#coupon_code').val();
        if(!code) { toastr.error('কুপন কোড লিখুন'); return; }

        $.ajax({
            url: "{{ route('front.getCouponDiscount') }}", 
            method: "GET",
            data: { code: code },
            success: function(res) {
                if(res.success) {
                    toastr.success(res.msg);
                    setTimeout(function(){ location.reload(); }, 1000); 
                } else {
                    $('#coupon_msg').text(res.msg).css('color', 'red');
                    toastr.error(res.msg);
                }
            }
        });
    };

    // ✅✅✅ OTP GLOBAL VARIABLES & FUNCTIONS ✅✅✅
    var isOtpVerified = false;
    var otpSystemEnabled = {{ $information->otp_system ?? 0 }};
    var otpTimerInterval;
    var isSendingOtp = false;

    function startOtpTimer(duration, display) {
        var timer = duration, seconds;
        clearInterval(otpTimerInterval);
        $('#resendOtpBtn').prop('disabled', true).addClass('text-muted').removeClass('text-primary');
        otpTimerInterval = setInterval(function () {
            seconds = parseInt(timer % 60, 10);
            seconds = seconds < 10 ? "0" + seconds : seconds;
            display.html("Wait (" + seconds + "s)");
            if (--timer < 0) {
                clearInterval(otpTimerInterval);
                display.html("কোড পাননি? <span class='text-primary fw-bold'>আবার পাঠান</span>");
                $('#resendOtpBtn').prop('disabled', false).removeClass('text-muted').addClass('text-primary');
            }
        }, 1000);
    }

    window.sendOtpBeforeSubmit = function(isResend = false) {
        if(isSendingOtp) return;
        var mobile = $('#customer_mobile').val();
        if(!mobile || mobile.length !== 11) { toastr.error('সঠিক মোবাইল নাম্বার দিন'); return; }
        
        isSendingOtp = true;
        if(!isResend) $('#submit_btn').prop('disabled', true).text('Sending OTP...');
        
        $.ajax({
            url: "{{ route('sendOtp') }}", type: "POST", data: { mobile: mobile, _token: "{{ csrf_token() }}" },
            success: function(res) {
                isSendingOtp = false;
                if(!isResend) $('#submit_btn').prop('disabled', false).html('অর্ডার কনফার্ম করুন <i class="fas fa-check-circle ms-2"></i>');
                
                if(res.success) {
                    $('#otp_sent_number').text(mobile);
                    $('#otpModal').appendTo('body'); 
                    var myModal = new bootstrap.Modal(document.getElementById('otpModal'));
                    myModal.show();
                    
                    setTimeout(function() { $('#otp_input').focus(); }, 500);
                    startOtpTimer(30, $('#resendOtpBtn'));
                } else { toastr.error(res.msg); }
            },
            error: function() { 
                isSendingOtp = false; 
                if(!isResend) $('#submit_btn').prop('disabled', false).html('অর্ডার কনফার্ম করুন <i class="fas fa-check-circle ms-2"></i>'); 
            }
        });
    };

    window.verifyOtpNow = function() {
        var code = $('#otp_input').val();
        var mobile = $('#customer_mobile').val();
        $.ajax({
            url: "{{ route('verifyOtp') }}", type: "POST", data: { otp: code, mobile: mobile, _token: "{{ csrf_token() }}" },
            success: function(res) {
                if(res.success) {
                    isOtpVerified = true;
                    bootstrap.Modal.getInstance(document.getElementById('otpModal')).hide();
                    submitOrderFinal(); // ✅ Proceed to final submit
                } else { $('#otp_error').text(res.msg); }
            }
        });
    };

    // ✅✅✅ FINAL SUBMIT FUNCTION ✅✅✅
    function submitOrderFinal() {
        let form = $('#checkoutForm');
        let payMethod = $('input[name="payment_method"]:checked').val() || 'cod'; 
        var purchaseEventId = buildPurchaseEventId(); $('#purchase_event_id').val(purchaseEventId);
        
        if(payMethod === 'sslcommerz'){ 
            form.attr('action', "{{ url('/pay') }}")[0].submit(); 
            return; 
        }
        
        $('#submit_btn').prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> প্রসেসিং হচ্ছে...');
        var totalAmt = toNumber($('#final_amount').val()); var unitPrice = parseFloat($('#unit_price').val()) || 0;
        var pid = "{{ $productId }}"; var pname = @json($productName); var cat = @json($contentCategory); var q = $('#qty_input').val();
        
        $.ajax({
            url: "{{ route('front.storelandData') }}", method: "POST", data: form.serialize(),
            success: function(res){
                if(res.success){ 
                    try{ if(typeof fbq === 'function') fbq('track', 'Purchase', { currency: "BDT", value: totalAmt, content_type: "product", content_ids: [String(pid)], content_name: pname, content_category: cat, num_items: q, contents: [{ id: String(pid), quantity: q, item_price: unitPrice }] }, {eventID: (res.purchase_event_id || purchaseEventId)}); }catch(e){}
                    toastr.success(res.msg); setTimeout(function(){ window.location.href = res.url; }, 800);
                } else { toastr.error(res.msg); $('#submit_btn').prop('disabled', false).html('অর্ডার কনফার্ম করুন <i class="fas fa-check-circle ms-2"></i>'); }
            },
            error: function (response) { $('#submit_btn').prop('disabled', false).html('অর্ডার কনফার্ম করুন <i class="fas fa-check-circle ms-2"></i>'); toastr.error('ফর্ম সাবমিট করতে সমস্যা হচ্ছে।'); }
        });
    }

    // GENERAL FUNCTIONS
    function startTimer(duration) {
        let timer = duration, hours, minutes, seconds;
        setInterval(function () {
            hours = parseInt(timer / 3600, 10); minutes = parseInt((timer % 3600) / 60, 10); seconds = parseInt(timer % 60, 10);
            hours = hours < 10 ? "0" + hours : hours; minutes = minutes < 10 ? "0" + minutes : minutes; seconds = seconds < 10 ? "0" + seconds : seconds;
            $('#hours').text(hours); $('#minutes').text(minutes); $('#seconds').text(seconds);
            if (--timer < 0) timer = duration;
        }, 1000);
    }
    let dynamicHours = {{ $ln_pg->countdown_hours ?? 5 }};
    startTimer(dynamicHours * 60 * 60); 

    function scrollToForm() { document.getElementById('orderForm').scrollIntoView({ behavior: 'smooth' }); }
    function toNumber(v){ v = (v ?? '').toString().replace(/[^\d.]/g,''); var n = parseFloat(v); return isNaN(n) ? 0 : n; }
    function buildPurchaseEventId(){ return "PUR_{{ $productId }}_" + Date.now() + "_" + Math.floor(Math.random() * 1000000); }
    
    $(document).ready(function(){
        $('#productGallery').owlCarousel({ 
            loop:true, margin:0, nav:false, dots:true, autoplay:true, autoplayTimeout:3000, smartSpeed: 1000, items:1 
        });
        
        $('#textReviewCarousel').owlCarousel({ 
            loop:true, margin:20, nav:false, dots:true, autoplay:true, autoplayTimeout:4000, autoplayHoverPause:true, smartSpeed: 800, 
            responsive:{ 0:{ items:1 }, 768:{ items:2 }, 1000:{ items:3 }, 1200:{ items:4 } } 
        });
        
        $('.faq-header').click(function(){
            $(this).toggleClass('active'); $(this).next('.faq-body').slideToggle(300);
            $('.faq-header').not(this).removeClass('active').next('.faq-body').slideUp(300);
        });

        let varMatrix = window.varMatrix || {}; let selectedSize = 0; let selectedColor = 0;
        if($('.var-size-btn').length > 0) { selectedSize = $('.var-size-btn').first().data('id'); $('.var-size-btn').first().addClass('active'); }
        if($('.var-color-btn').length > 0) { selectedColor = $('.var-color-btn').first().data('id'); $('.var-color-btn').first().addClass('active'); }

        // ✅✅✅ UPDATED CALCULATE FUNCTION FOR DISCOUNT ✅✅✅
        function calculate() {
            let price = Math.round(parseFloat($('#unit_price').val()) || 0); 
            let qty = parseInt($('#qty_input').val()) || 1;
            let charge = Math.round(parseFloat($('#delivery_charge').find(':selected').data('charge')) || 0);
            let discount = Math.round(parseFloat($('#discount_amount').val()) || 0);
            
            let subtotal = price * qty; 
            let total = (subtotal + charge) - discount;
            if(total < 0) total = 0;
            
            $('#calc_subtotal').text(subtotal); 
            $('#calc_shipping').text(charge); 
            $('#calc_total').text(total);
            
            $('#amount').val(subtotal); 
            $('#final_amount').val(total); 
        }

        function checkVariation() {
            if(Object.keys(varMatrix).length === 0) { calculate(); return; }
            let key = selectedSize + '_' + selectedColor; let matchedVar = varMatrix[key];
            if(matchedVar) {
                let roundedPrice = Math.round(matchedVar.price);
                $('#variation_id').val(matchedVar.variation_id); 
                $('#unit_price').val(roundedPrice); 
                $('#unit_price_display').text(roundedPrice); 
                $('#max_stock').val(matchedVar.stock);
                if(matchedVar.stock <= 0) { toastr.error('Out of Stock!'); $('#submit_btn').prop('disabled', true).text('স্টক আউট'); $('#qty_input').val(0); } 
                else { $('#submit_btn').prop('disabled', false).html('অর্ডার কনফার্ম করুন <i class="fas fa-check-circle ms-2"></i>'); if($('#qty_input').val() == 0) $('#qty_input').val(1); }
            } else { $('#variation_id').val(''); $('#submit_btn').prop('disabled', true).text('Unavailable'); $('#qty_input').val(0); }
            calculate();
        }
        
        $('.var-size-btn').click(function() { $('.var-size-btn').removeClass('active'); $(this).addClass('active'); selectedSize = $(this).data('id'); checkVariation(); });
        $('.var-color-btn').click(function() { $('.var-color-btn').removeClass('active'); $(this).addClass('active'); selectedColor = $(this).data('id'); checkVariation(); });
        checkVariation();
        $('#delivery_charge').on('change', calculate);
        $('#qty_plus').click(function(){ let q = parseInt($('#qty_input').val()) || 1; let max = parseInt($('#max_stock').val()) || 1; if(q < max) { $('#qty_input').val(q + 1); calculate(); } else { toastr.warning('Maximum Stock Limit Reached!'); } });
        $('#qty_minus').click(function(){ let q = parseInt($('#qty_input').val()) || 1; if(q > 1) { $('#qty_input').val(q - 1); calculate(); } });
        
        $(document).on('blur', '#customer_mobile', function(){ let mobile = $(this).val(); if(mobile.length === 11){ $.post("{{ route('incompleteStore') }}", { _token: "{{ csrf_token() }}", mobile: mobile, name: $('input[name="first_name"]').val(), address: $('#customer_address').val(), prd_id: "{{ $productId }}", amount: $('#final_amount').val() }); } });
        
        // ✅✅✅ FORM SUBMIT LOGIC WITH OTP ✅✅✅
        $('#checkoutForm').submit(function(e){
            e.preventDefault(); 
            if(!$('#variation_id').val() && Object.keys(varMatrix).length > 0) { toastr.error('সঠিক সাইজ এবং কালার সিলেক্ট করুন!'); return false; }
            if(parseInt($('#max_stock').val()) <= 0) { toastr.error('প্রোডাক্টটি স্টকে নেই!'); return false; }
            if(!$('#delivery_charge').val()){ toastr.warning('ডেলিভারি এলাকা নির্বাচন করুন!'); return false; }
            
            let payMethod = $('input[name="payment_method"]:checked').val() || 'cod'; 
            
            // Online Payment by-passes OTP usually (Optional: adjust as per your logic)
            if(payMethod === 'sslcommerz' && !otpSystemEnabled) {
                var purchaseEventId = buildPurchaseEventId(); $('#purchase_event_id').val(purchaseEventId);
                $(this).attr('action', "{{ url('/pay') }}")[0].submit(); 
                return;
            }

            // OTP Trigger
            if(otpSystemEnabled == 1 && !isOtpVerified) {
                sendOtpBeforeSubmit();
            } else {
                submitOrderFinal();
            }
        });
    });
</script>
</body>
</html>