@php 
    $cart = session()->get('cart', []); 
    use App\Models\Information;
    $info = Information::first();
@endphp

<style>
    /* ✅ Coupon & General Styles */
    .coupon-section-wrapper {
        padding: 15px 0;
        border-bottom: 1px dashed rgba(0,0,0,0.1);
        margin-bottom: 15px;
    }
    .coupon-label-text {
        font-family: 'Hind Siliguri', sans-serif;
        font-size: 15px;
        font-weight: 700;
        color: #333;
        display: block;
        margin-bottom: 8px;
    }
    .coupon-input-styled {
        width: 100%;
        display: block;
        padding: 12px 20px;
        border: 1px solid #e0e0e0;
        border-radius: 50px;
        background: #fdfdfd;
        font-size: 14px;
        color: #333;
        outline: none;
        transition: all 0.3s ease;
        margin-bottom: 12px;
        box-shadow: inset 0 2px 4px rgba(0,0,0,0.02);
        height: 48px;
    }
    .coupon-input-styled:focus {
        border-color: var(--primary, #00276C);
        background: #fff;
        box-shadow: 0 0 0 3px rgba(0,39,108,0.1);
    }
    .coupon-btn-styled {
        width: 100%;
        display: block;
        background: linear-gradient(90deg, var(--primary, #00276C) 0%, var(--primary2, #033199) 100%);
        color: white;
        border: none;
        border-radius: 50px;
        padding: 12px 0;
        font-family: 'Hind Siliguri', sans-serif;
        font-size: 16px;
        font-weight: 700;
        cursor: pointer;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        box-shadow: 0 4px 15px rgba(0,39,108,0.2);
        transition: transform 0.2s, box-shadow 0.2s;
    }
    .coupon-btn-styled:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(0,39,108,0.3);
    }
    .coupon-btn-styled:active { transform: translateY(0); }
    .coupon-btn-styled:disabled { background: #ccc; cursor: not-allowed; box-shadow: none; }
    #coupon_message {
        font-family: 'Hind Siliguri', sans-serif;
        font-size: 13px;
        margin-top: 10px;
        text-align: center;
        font-weight: 600;
        display: block;
    }

    /* ✅✅✅ BEAUTIFUL BADGE STYLES (SIZE & COLOR) ✅✅✅ */
    
    /* Base Badge Style */
    .product-badge {
        display: inline-block;
        padding: 4px 10px;
        border-radius: 6px;
        font-size: 12px;
        font-weight: 600;
        font-family: 'Hind Siliguri', sans-serif;
        margin-top: 5px;
        letter-spacing: 0.3px;
        line-height: 1.2;
    }

    /* Style for 'Single' - Soft Green/Teal */
    .badge-single {
        background-color: #e6fffa;
        color: #047481;
        border: 1px solid #b2f5ea;
    }

    /* Style for 'Variable Size' - Soft Blue */
    .badge-variable {
        background-color: #ebf8ff;
        color: #2b6cb0;
        border: 1px solid #bee3f8;
    }

    /* ✅ Style for 'Color' - Soft Purple */
    .badge-color {
        background-color: #faf5ff;
        color: #6b46c1;
        border: 1px solid #e9d8fd;
    }

    /* ✅✅✅ NEW: QUANTITY SELECTOR STYLES (CENTERED & RESPONSIVE) ✅✅✅ */
    .pro-qty {
        display: inline-flex !important; /* Force to stay in one line */
        align-items: center;
        justify-content: center;
        border: 1px solid #ddd;
        border-radius: 30px; /* Pill shape */
        padding: 3px;
        background: #fff;
        min-width: 90px;
        box-shadow: 0 2px 5px rgba(0,0,0,0.02);
    }
    .pro-qty .qtybtn {
        width: 28px;
        height: 28px;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        background: #f1f3f5;
        border-radius: 50%;
        font-weight: bold;
        font-size: 16px;
        color: #333;
        user-select: none;
        transition: all 0.2s ease-in-out;
    }
    .pro-qty .qtybtn:hover {
        background: #e2e6ea;
        color: #000;
    }
    .pro-qty .quantity-input {
        width: 35px;
        text-align: center !important; /* ✅ Keep number strictly in center */
        border: none;
        background: transparent;
        font-weight: 700;
        font-size: 15px;
        color: #333;
        outline: none;
        -moz-appearance: textfield; /* Remove default styling on Firefox */
    }
    /* Hide number arrows for Chrome/Safari */
    .pro-qty .quantity-input::-webkit-outer-spin-button,
    .pro-qty .quantity-input::-webkit-inner-spin-button {
        -webkit-appearance: none;
        margin: 0;
    }

    /* Responsive adjustments for mobile table layout */
    @media (max-width: 768px) {
        .table th, .table td {
            font-size: 13px; /* Slightly smaller text on mobile */
            padding: 8px 4px !important; /* Less padding to fit columns */
            vertical-align: middle;
        }
        .pro-qty {
            min-width: 75px;
            padding: 2px;
        }
        .pro-qty .qtybtn {
            width: 24px;
            height: 24px;
            font-size: 14px;
        }
        .pro-qty .quantity-input {
            width: 26px;
            font-size: 14px;
        }
    }
</style>

<aside class="card border-0 shadow-sm rounded-4">
  <article class="card-body">
    <header class="mb-3">
      <h4 class="card-title fw-bold" style="font-family: 'Hind Siliguri', sans-serif; font-size: 18px;">
        অর্ডার ডিটেইলস
      </h4>
    </header>

    <div class="table-responsive">
      <table class="table align-middle">
        <thead class="table-light">
          <tr>
            <th class="fw-bold text-dark" style="font-family: 'Hind Siliguri', sans-serif;">Image</th>
            <th class="fw-bold text-dark" style="font-family: 'Hind Siliguri', sans-serif;">Product</th>
            <th class="fw-bold text-dark" style="font-family: 'Hind Siliguri', sans-serif;">Price</th>
            <th class="fw-bold text-dark text-center" style="font-family: 'Hind Siliguri', sans-serif;">QTY</th>
            <th class="fw-bold text-dark" style="font-family: 'Hind Siliguri', sans-serif;">Total</th>
            <th></th>
          </tr>
        </thead>
        <tbody>
          @php
            $total = 0;
            $discount = 0;
          @endphp

          @foreach($cart as $key => $item)
            @php
              $price = $item['price'] * $item['quantity'];
              $total += $price;
              $discount += $item['discount'] * $item['quantity'];
              
              // ✅ Get Size & Color safely
              $productSize  = $item['size'] ?? null;
              $productColor = $item['color'] ?? null;
            @endphp
            <tr class="cart-item">

              {{-- ✅✅✅ CRITICAL FIX: HIDDEN INPUTS ADDED HERE ✅✅✅ --}}
              {{-- These inputs send the product data to the controller --}}
              <input type="hidden" name="product_id[]" value="{{ $item['product_id'] }}">
              <input type="hidden" name="quantity[]" value="{{ $item['quantity'] }}">
              <input type="hidden" name="unit_price[]" value="{{ $item['price'] }}">
              <input type="hidden" name="unit_discount[]" value="{{ $item['discount'] ?? 0 }}">
              <input type="hidden" name="variation_id[]" value="{{ $item['variation_id'] ?? '' }}">
              {{-- ✅✅✅ END HIDDEN INPUTS ✅✅✅ --}}

              {{-- Image --}}
              <td class="align-middle" style="width:70px;">
                <a href="{{ route('front.products.show', [$item['product_id']]) }}">
                  <img src="{{ getImage('products', $item['image']) }}" class="img-fluid rounded" style="max-width:50px;">
                </a>
              </td>

              {{-- ✅✅✅ PRODUCT NAME, SIZE & COLOR LOGIC ✅✅✅ --}}
              <td class="align-middle" style="font-family: 'Hind Siliguri', sans-serif; min-width: 120px;">
                <div class="d-flex flex-column">
                    {{-- Product Name --}}
                    <span class="fw-bold text-dark" style="font-size: 14px;">{{ $item['name'] }}</span>
                    
                    {{-- Free Ship Badge --}}
                    @if(isset($item['is_free_shipping']) && $item['is_free_shipping'])
                        <span class="badge bg-info mt-1" style="width: fit-content; font-size: 10px;">Free Ship</span>
                    @endif

                    <div class="d-flex flex-column gap-1">
                        {{-- 1. Size Logic --}}
                        @if(!empty($productSize))
                            @if(strtolower(trim($productSize)) === 'single')
                                <div><span class="product-badge badge-single">Single</span></div>
                            @else
                                <div><span class="product-badge badge-variable">Size: {{ $productSize }}</span></div>
                            @endif
                        @endif

                        {{-- 2. Color Logic --}}
                        @if(!empty($productColor))
                            <div>
                                <span class="product-badge badge-color">
                                    Color: {{ $productColor }}
                                </span>
                            </div>
                        @endif
                    </div>

                </div>
              </td>

              {{-- Price --}}
              <td class="align-middle" style="font-family: 'Hind Siliguri', sans-serif;">
                {{ priceFormate($item['price']) }}
              </td>

              {{-- Quantity --}}
              <td class="product-quantity text-center" data-title="Qty">
                <div class="pro-qty" data-segment="{{ request()->segment(1)}}" data-href="{{ route('front.carts.edit',[$key])}}">
                  <span class="dec qtybtn">-</span>
                  <input type="number" class="quantity-input" value="{{ $item['quantity'] }}" style="font-family: 'Hind Siliguri', sans-serif">
                  <span class="inc qtybtn">+</span>
                </div>
              </td>

              {{-- Total Price --}}
              <td class="align-middle" style="font-family: 'Hind Siliguri', sans-serif;">
                {{ priceFormate($price) }}
              </td>

              {{-- ✅✅✅ DELETE BUTTON FIXED ✅✅✅ --}}
              <td class="align-middle text-center">
                 <button type="button" 
                         onclick="deleteCartItem('{{ route('front.carts.destroy', [$key]) }}')" 
                         class="btn btn-danger btn-sm" 
                         style="border-radius: 50px; padding: 5px 10px;">
                    <i class="fa fa-trash"></i>
                 </button>
              </td>

            </tr>
          @endforeach
        </tbody>
      </table>
    </div>
  </article>

  <article class="card-body border-top bg-light rounded-bottom">
    
    {{-- Coupon Section --}}
    @if(isset($info->coupon_visibility) && $info->coupon_visibility == 1)
    <div class="coupon-section-wrapper">
        <label class="coupon-label-text">কুপন কোড (যদি থাকে)</label>
        <input type="text" id="coupon_code" class="coupon-input-styled" placeholder="এখানে কোড লিখুন..." autocomplete="off">
        <button type="button" id="coupon_btn" class="coupon-btn-styled" onclick="applyCoupon()">Apply</button>
        <small id="coupon_message"></small>
    </div>
    @endif

    {{-- Totals --}}
    <div class="d-flex justify-content-between mb-2" style="font-family: 'Hind Siliguri', sans-serif;">
      <span class="fs-3 fw-bold text-dark">Subtotal:</span>
      <span class="fs-3 fw-bold text-dark">{{ priceFormate($total) }}</span>
    </div>

    <div class="d-flex justify-content-between mb-2" style="font-family: 'Hind Siliguri', sans-serif;">
      <span class="fs-3 fw-bold text-dark">Delivery Charge:</span>
      <span class="text-danger delivery_charge fs-3 fw-bold text-dark" id="d_charge">৳0</span>
    </div>

    @if(session()->has('coupon_discount'))
    <div class="d-flex justify-content-between mb-2" style="font-family: 'Hind Siliguri', sans-serif;">
        <span class="fs-3 fw-bold text-success">Coupon Discount:</span>
        <span class="fs-3 fw-bold text-success">- {{ priceFormate(session('coupon_discount')) }}</span>
    </div>
    @endif

    <div class="d-flex justify-content-between fw-bold fs-5 mt-3 pt-2 border-top" style="font-family: 'Hind Siliguri', sans-serif;">
      <span class="fs-3 fw-bold text-dark">Total:</span>
      <span class="total fs-3 fw-bold text-dark">
          {{ priceFormate($total - (session('coupon_discount') ?? 0)) }}
      </span>
    </div>
    
    <input type="hidden" value="{{ $total }}" id="subtotal">
    {{-- 'amount' field for SSLCommerz/Logic if needed in JS --}}
    <input type="hidden" value="{{ $total }}" name="amount" id="amount">
  </article>
</aside>