

<?php $__env->startSection('content'); ?>

<?php $__env->startPush('css'); ?>
<link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
<style>
    :root {
        --bg-body: #F4F7FE;
        --card-bg: #FFFFFF;
        --text-main: #2B3674;
        --text-sub: #A3AED0;
        --shadow-soft: 0px 18px 40px rgba(112, 144, 176, 0.12);
        --radius-xl: 24px;
        --radius-lg: 16px;
        --transition: all 0.3s ease;
    }

    body { font-family: 'Plus Jakarta Sans', sans-serif; background: var(--bg-body); }
    
    /* ----- Premium Filter Card ----- */
    .filter-section {
        background: var(--card-bg);
        border-radius: var(--radius-xl);
        padding: 24px;
        box-shadow: var(--shadow-soft);
        margin-bottom: 30px;
        border: 1px solid rgba(255, 255, 255, 0.5);
    }
    
    .form-label {
        color: var(--text-sub); font-size: 0.85rem; font-weight: 600; margin-bottom: 8px;
    }
    
    .form-control {
        background: #F4F7FE; border: none; border-radius: var(--radius-lg);
        padding: 12px 16px; color: var(--text-main); font-weight: 600;
        transition: var(--transition);
    }
    .form-control:focus {
        background: #fff; box-shadow: 0 0 0 2px #4318FF; color: var(--text-main);
    }

    .btn-sync {
        background: linear-gradient(90deg, #4481EB 0%, #04BEFE 100%);
        color: #fff; border: none; border-radius: var(--radius-lg);
        padding: 12px; width: 100%; font-weight: 700;
        box-shadow: 0 10px 20px rgba(68, 129, 235, 0.2);
        transition: var(--transition);
    }
    .btn-sync:hover { transform: translateY(-2px); box-shadow: 0 15px 30px rgba(68, 129, 235, 0.3); color: #fff; }

    /* ----- Quick Pills ----- */
    .quick-range {
        background: #F4F7FE; border-radius: 50px; padding: 6px;
        display: inline-flex; width: 100%; justify-content: space-between;
    }
    .quick-range .btn {
        border: none; border-radius: 40px; font-size: 0.8rem; font-weight: 600;
        color: var(--text-sub); padding: 8px 0; width: 24%;
        transition: var(--transition);
    }
    .quick-range .btn:hover { color: var(--text-main); }
    .quick-range .btn.active {
        background: #FFFFFF; color: #4318FF;
        box-shadow: 0 2px 10px rgba(0,0,0,0.05);
    }

    /* ----- Premium White Cards ----- */
    .mini-card {
        background: var(--card-bg);
        border-radius: var(--radius-xl);
        box-shadow: var(--shadow-soft);
        border: none; padding: 24px;
        position: relative; overflow: hidden;
        transition: var(--transition);
        height: 100%;
        display: flex; flex-direction: column; justify-content: space-between;
    }
    .mini-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 25px 50px rgba(112, 144, 176, 0.2);
    }

    /* Card Typography */
    .card-label {
        color: var(--text-sub); font-size: 0.9rem; font-weight: 600; margin-bottom: 6px;
    }
    .card-value {
        color: var(--text-main); font-size: 2rem; font-weight: 800; line-height: 1.2;
    }
    .card-sub {
        font-size: 0.75rem; color: #05CD99; font-weight: 700; display: flex; align-items: center; margin-top: 10px;
    }
    .card-sub.down { color: #EE5D50; }

    /* Card Icons (Soft Backgrounds) */
    .icon-box {
        width: 60px; height: 60px; border-radius: 50%;
        display: flex; align-items: center; justify-content: center;
        font-size: 1.6rem; transition: var(--transition);
    }
    
    /* Icon Colors */
    .ic-total   { background: #F4F7FE; color: #4318FF; }
    .ic-pending { background: #FFF7E6; color: #FFB547; }
    .ic-complete{ background: #E6FBF5; color: #05CD99; }
    .ic-cancel  { background: #FEEEEE; color: #EE5D50; }
    .ic-sell    { background: #F0F3FF; color: #2B3674; }
    .ic-expense { background: #F2F4F7; color: #667085; }
    .ic-profit  { background: #E9FAF7; color: #008E76; }
    .ic-stocks  { background: #F3E8FF; color: #8B5CF6; }

    /* Layout Header */
    .page-title {
        color: var(--text-main); font-weight: 800; font-size: 1.8rem; margin-bottom: 0;
    }
    .user-badge {
        background: #fff; padding: 8px 16px; border-radius: 30px;
        color: var(--text-main); font-weight: 700; box-shadow: var(--shadow-soft);
        display: inline-flex; align-items: center; gap: 8px;
    }

    /* Skeleton Loading */
    .skeleton {
        background: linear-gradient(90deg, #F4F7FE 25%, #E8EDFB 50%, #F4F7FE 75%);
        background-size: 200% 100%; animation: loading 1.5s infinite;
        border-radius: 6px; color: transparent !important;
    }
    @keyframes loading { 0% { background-position: 200% 0; } 100% { background-position: -200% 0; } }

    /* Spacing */
    .gy-premium { row-gap: 24px; }

    /* Mobile Table Fix */
    @media (max-width: 576px) {
        .page-title { font-size: 1.4rem; }
        .mini-card { padding: 20px; }
        .card-value { font-size: 1.6rem; }
        .table thead th { font-size: 0.75rem; white-space: nowrap; }
        .table tbody td { font-size: 0.8rem; }
    }
</style>
<?php $__env->stopPush(); ?>

<?php
  $today       = date('Y-m-d');
  $userStart  = optional(auth()->user()->created_at)->format('Y-m-d') ?? $today;
  $endDateUi  = request('endDate', $today);
  
  // ✅✅✅ NEW: Fetch Dynamic Limit to show in Card
  $dyn_limit = \App\Models\Information::orderBy('id', 'desc')->value('stock_warning_limit') ?? 5;
?>

<div class="row mb-4 align-items-center">
  <div class="col-12 col-md-6">
    <div class="page-title-box">
      <span style="color: #A3AED0; font-weight: 600;">Overview</span>
      <h4 class="page-title">Dashboard</h4>
    </div>
  </div>
  <div class="col-12 col-md-6 text-md-end mt-2 mt-md-0">
    <div class="user-badge">
        <i class="uil uil-user-circle" style="font-size: 1.2rem; color: #4318FF;"></i>
        <?php echo e(auth()->user()->first_name.' '.auth()->user()->last_name); ?>

    </div>
  </div>
</div>

<div class="filter-section">
    <form action="<?php echo e(route('admin.dashboard')); ?>" method="GET">
        <div class="row align-items-end g-3">
            <div class="col-6 col-lg-3">
                <label class="form-label">Start Date</label>
                <input type="date" class="form-control" name="startDate"
                       value="<?php echo e(request('startDate', $userStart)); ?>"
                       min="<?php echo e($userStart); ?>">
            </div>
            <div class="col-6 col-lg-3">
                <label class="form-label">End Date</label>
                <input type="date" class="form-control" name="endDate"
                       value="<?php echo e($endDateUi); ?>"
                       min="<?php echo e($userStart); ?>">
            </div>
            <div class="col-12 col-lg-4">
                <label class="form-label">Quick Select</label>
                <div class="quick-range" role="group">
                    <button type="button" class="btn active" data-range="today">Today</button>
                    <button type="button" class="btn" data-range="7d">7 Days</button>
                    <button type="button" class="btn" data-range="mtd">Month</button>
                    <button type="button" class="btn" data-range="ytd">Year</button>
                </div>
            </div>
            <div class="col-12 col-lg-2">
                <button type="button" id="refreshBtn" class="btn-sync">
                    <i class="uil uil-sync me-2"></i> Sync
                </button>
            </div>
        </div>
    </form>
</div>

<div class="row d-none" id="loader">
  <div class="col-12 text-center py-5">
    <div class="spinner-border text-primary" role="status"></div>
  </div>
</div>


<div id="dashboard_data_top">
  <div class="row gy-premium">

    
    <div class="col-12 col-sm-6 col-xl-3">
        <a href="<?php echo e(url('admin/orders')); ?>" class="text-decoration-none">
            <div class="mini-card" data-card="total">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <div class="card-label">Total Orders</div>
                        <div class="card-value total_orders skeleton">0</div>
                        <div class="card-sub">
                            <span class="trend-icon"></span> <span class="trend-val">0%</span>
                            <span class="text-muted ms-1 fw-normal">since last period</span>
                        </div>
                    </div>
                    <div class="icon-box ic-total">
                        <i class="uil uil-shopping-bag"></i>
                    </div>
                </div>
            </div>
        </a>
    </div>

    
    <div class="col-12 col-sm-6 col-xl-3">
        <a href="<?php echo e(url('admin/orders')); ?>" class="text-decoration-none">
            <div class="mini-card" data-card="pending">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <div class="card-label">Pending Orders</div>
                        <div class="card-value pending_orders skeleton">0</div>
                        <div class="card-sub">
                            <span class="trend-icon"></span> <span class="trend-val">0%</span>
                            <span class="text-muted ms-1 fw-normal">needs attention</span>
                        </div>
                    </div>
                    <div class="icon-box ic-pending">
                        <i class="uil uil-clock-three"></i>
                    </div>
                </div>
            </div>
        </a>
    </div>

    
    <div class="col-12 col-sm-6 col-xl-3">
        <a href="<?php echo e(url('admin/orders')); ?>" class="text-decoration-none">
            <div class="mini-card" data-card="complete">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <div class="card-label">Delivered</div>
                        <div class="card-value complete_orders skeleton">0</div>
                        <div class="card-sub">
                            <span class="trend-icon"></span> <span class="trend-val">0%</span>
                            <span class="text-muted ms-1 fw-normal">successful</span>
                        </div>
                    </div>
                    <div class="icon-box ic-complete">
                        <i class="uil uil-check-circle"></i>
                    </div>
                </div>
            </div>
        </a>
    </div>

    
    <div class="col-12 col-sm-6 col-xl-3">
        <a href="<?php echo e(url('admin/orders')); ?>" class="text-decoration-none">
            <div class="mini-card" data-card="cancel">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <div class="card-label">Cancelled</div>
                        <div class="card-value cancell_orders skeleton">0</div>
                        <div class="card-sub down">
                            <span class="trend-icon"></span> <span class="trend-val">0%</span>
                            <span class="text-muted ms-1 fw-normal">returned</span>
                        </div>
                    </div>
                    <div class="icon-box ic-cancel">
                        <i class="uil uil-times-circle"></i>
                    </div>
                </div>
            </div>
        </a>
    </div>

    <?php if(! \Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'worker')): ?>
    
    <div class="col-12 col-sm-6 col-xl-3">
        <a href="<?php echo e(url('admin/products')); ?>" class="text-decoration-none">
            <div class="mini-card" data-card="sell">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <div class="card-label">Total Sales</div>
                        <div class="card-value sell_amount skeleton">৳0</div>
                        <div class="card-sub">
                            <span class="trend-icon"></span> <span class="trend-val">0%</span>
                            <span class="text-muted ms-1 fw-normal">revenue</span>
                        </div>
                    </div>
                    <div class="icon-box ic-sell">
                        <i class="uil uil-graph-bar"></i>
                    </div>
                </div>
            </div>
        </a>
    </div>

    
    <div class="col-12 col-sm-6 col-xl-3">
        <a href="<?php echo e(url('admin/products')); ?>" class="text-decoration-none">
            <div class="mini-card" data-card="expense">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <div class="card-label">Total Expense</div>
                        <div class="card-value total_expense skeleton">৳0</div>
                        <div class="card-sub down">
                            <span class="trend-icon"></span> <span class="trend-val">0%</span>
                            <span class="text-muted ms-1 fw-normal">costs</span>
                        </div>
                    </div>
                    <div class="icon-box ic-expense">
                        <i class="uil uil-bill"></i>
                    </div>
                </div>
            </div>
        </a>
    </div>

    
    <div class="col-12 col-sm-6 col-xl-3">
        <a href="<?php echo e(url('admin/orders')); ?>" class="text-decoration-none">
            <div class="mini-card" data-card="profit">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <div class="card-label">Net Profit</div>
                        <div class="card-value total_net_profit skeleton">৳0</div>
                        <div class="card-sub">
                            <span class="trend-icon"></span> <span class="trend-val">0%</span>
                            <span class="text-muted ms-1 fw-normal">earnings</span>
                        </div>
                    </div>
                    <div class="icon-box ic-profit">
                        <i class="uil uil-money-withdraw"></i>
                    </div>
                </div>
            </div>
        </a>
    </div>

    
    <div class="col-12 col-sm-6 col-xl-3">
        <a href="<?php echo e(url('admin/products')); ?>" class="text-decoration-none">
            <div class="mini-card" data-card="stocks">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <div class="card-label">Stock Available</div>
                        <div class="card-value"><?php echo e(number_format($total_stocks ?? 0)); ?></div>
                        <div class="card-sub">
                            <span class="text-muted fw-normal">Total Items in Inventory</span>
                        </div>
                    </div>
                    <div class="icon-box ic-stocks">
                        <i class="uil uil-cube"></i>
                    </div>
                </div>
            </div>
        </a>
    </div>

    
    <div class="col-12 col-sm-6 col-xl-3">
        <a href="<?php echo e(route('admin.stock_warning')); ?>" class="text-decoration-none">
            <div class="mini-card" data-card="warning" style="border-left: 4px solid #FF947A;">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <div class="card-label text-danger">Stock Warning</div>
                        <div class="card-value low_stock_count skeleton text-dark">0</div>
                        <div class="card-sub text-danger">
                            <i class="uil uil-info-circle me-1"></i> Low Stock Items (<= <?php echo e($dyn_limit); ?>)
                        </div>
                    </div>
                    <div class="icon-box" style="background: #FFF4E5; color: #FF947A;">
                        <i class="uil uil-exclamation-triangle"></i>
                    </div>
                </div>
            </div>
        </a>
    </div>

    
    <div class="col-12 col-sm-6 col-xl-3">
        <a href="<?php echo e(url('admin/products')); ?>" class="text-decoration-none">
            <div class="mini-card" style="border-left: 4px solid #05CD99;">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <div class="card-label" style="color: #05CD99;">Total Products</div>
                        <div class="card-value"><?php echo e(\App\Models\Product::count()); ?></div>
                        <div class="card-sub" style="color: #05CD99;">
                            <i class="uil uil-layer-group me-1"></i> Active Items
                        </div>
                    </div>
                    <div class="icon-box" style="background: #E6FBF5; color: #05CD99;">
                        <i class="uil uil-clipboard-alt"></i>
                    </div>
                </div>
            </div>
        </a>
    </div>

    
    <div class="col-12 col-sm-6 col-xl-3">
        <a href="<?php echo e(url('admin/users')); ?>" class="text-decoration-none">
            <div class="mini-card" style="border-left: 4px solid #4318FF;">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <div class="card-label" style="color: #4318FF;">Total Employees</div>
                        <div class="card-value">
                            <?php echo e(\App\Models\User::whereHas('roles', fn($q) => $q->where('name', 'worker'))->count()); ?>

                        </div>
                        <div class="card-sub" style="color: #4318FF;">
                            <i class="uil uil-users-alt me-1"></i> Staff Members
                        </div>
                    </div>
                    <div class="icon-box" style="background: #F4F7FE; color: #4318FF;">
                        <i class="uil uil-user-check"></i>
                    </div>
                </div>
            </div>
        </a>
    </div>
    <?php endif; ?>

    
    <?php if($isWorker || auth()->user()->hasRole('admin')): ?>
    <div class="col-12 col-sm-6 col-xl-3">
        <a href="<?php echo e($isWorker ? url('admin/user-report') : route('admin.report.sales')); ?>" class="text-decoration-none">
            <div class="mini-card" style="border-left: 4px solid #FFB547;">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <div class="card-label" style="color: #FFB547;">
                            <?php echo e($isWorker ? 'My Performance' : 'Sales Report'); ?>

                        </div>
                        <div class="card-value" style="font-size: 1.6rem;">View Report</div>
                        <div class="card-sub" style="color: #FFB547;">
                            <i class="uil uil-analytics me-1"></i> Check Stats
                        </div>
                    </div>
                    <div class="icon-box" style="background: #FFF7E6; color: #FFB547;">
                        <i class="uil uil-file-alt"></i>
                    </div>
                </div>
            </div>
        </a>
    </div>
    <?php endif; ?>

  </div>
</div>

<div class="mt-4" id="dashboard_data"></div>


<div id="stock_warning_area"></div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script>
  window.isWorker = <?php echo json_encode(auth()->user()->hasRole('worker'), 15, 512) ?>;
  // ✅✅✅ NEW: Pass dynamic limit to JS
  window.dynLimit = <?php echo e($dyn_limit); ?>; 

  /* ===== Count-up animation ===== */
  const nf = new Intl.NumberFormat('en-BD', { maximumFractionDigits: 0 });
  const nfMoney = new Intl.NumberFormat('en-BD', { style: 'currency', currency: 'BDT', maximumFractionDigits:0 });

  function animateCount(el, to, isMoney=false, duration=1000){
    const start = 0;
    const startTime = performance.now();
    el.classList.remove('skeleton'); // remove loading state
    function frame(now){
      const p = Math.min((now - startTime) / duration, 1);
      // Ease-out expo function for smoother landing
      const ease = p === 1 ? 1 : 1 - Math.pow(2, -10 * p);
      const val = Math.floor(start + (to - start) * ease);
      el.textContent = isMoney ? nfMoney.format(val) : nf.format(val);
      if(p < 1) requestAnimationFrame(frame);
    }
    requestAnimationFrame(frame);
  }

  /* ===== Reset Skeletons ===== */
  function skeletonAll(){
    ['.total_orders','.pending_orders','.complete_orders','.cancell_orders',
     '.sell_amount','.total_expense','.total_net_profit', '.low_stock_count'
    ].forEach(cls=>{
      const el = document.querySelector(cls);
      if(el){ el.classList.add('skeleton'); el.textContent = ''; }
    });
  }

  /* ===== Trend Logic (Updated for White Design) ===== */
  function setTrend(cardSel, current, previous, positiveGood=true){
    const card = document.querySelector(`[data-card="${cardSel}"]`);
    if(!card) return;
    
    const subWrap = card.querySelector('.card-sub');
    const icon    = subWrap.querySelector('.trend-icon');
    const valEl   = subWrap.querySelector('.trend-val');

    let pct = 0;
    if(previous > 0){
      pct = ((current - previous) / previous) * 100;
    }else if(current > 0){
      pct = 100;
    }
    const rounded = Math.round(pct);

    valEl.textContent = (rounded>0? '+' : '') + rounded + '%';
    const upIsGood = positiveGood ? rounded >= 0 : rounded < 0;

    if(upIsGood){
      icon.innerHTML = '<i class="uil uil-arrow-growth"></i>';
      subWrap.style.color = '#05CD99'; // Green
    }else{
      icon.innerHTML = '<i class="uil uil-chart-down"></i>';
      subWrap.style.color = '#EE5D50'; // Red
    }
  }

  /* ===== Date helpers ===== */
  function formatYMD(d){ return d.toISOString().slice(0,10); }
  function dateDiffDays(a,b){ const A=new Date(a), B=new Date(b); return Math.floor((B-A)/(1000*60*60*24))+1; }
  function shiftBack(sd, ed){
    const len = dateDiffDays(sd, ed);
    const s = new Date(sd); s.setDate(s.getDate()-len);
    const e = new Date(ed); e.setDate(e.getDate()-len);
    return {psd: formatYMD(s), ped: formatYMD(e)};
  }
  function applyRange(range){
    const sd = document.querySelector('input[name="startDate"]');
    const ed = document.querySelector('input[name="endDate"]');
    const today = new Date();
    let s, e = new Date(); 

    if(range==='today'){
      s = new Date();
    }else if(range==='7d'){
      s = new Date(); s.setDate(s.getDate()-6);
    }else if(range==='mtd'){
      s = new Date(today.getFullYear(), today.getMonth(), 1);
    }else if(range==='ytd'){
      s = new Date(today.getFullYear(), 0, 1);
    }else{ return; }
    
    const minStr = sd.getAttribute('min'); const minDate = new Date(minStr);
    if (s < minDate) s = minDate;

    sd.value = formatYMD(s);
    ed.value = formatYMD(e);

    document.querySelectorAll('.quick-range .btn').forEach(b=>b.classList.remove('active'));
    const btn = document.querySelector(`.quick-range .btn[data-range="${range}"]`);
    if(btn) btn.classList.add('active');

    fetchBoth();
  }

  /* ===== API Calls ===== */
  function fetchJSON(url){ return fetch(url, {headers:{'X-Requested-With':'XMLHttpRequest'}}).then(r=>r.json()); }
  function getRangeDates(){
    const sd = document.querySelector('input[name="startDate"]').value;
    const ed = document.querySelector('input[name="endDate"]').value;
    return {sd, ed};
  }

  function fetchDashboardData(){
    const url = <?php echo json_encode(route('admin.getDashboardData'), 15, 512) ?>;
    const loader = document.getElementById('loader');
    loader.classList.remove('d-none');
    fetch(url, { headers:{'X-Requested-With':'XMLHttpRequest'} })
      .then(r=>r.text())
      .then(html=>{ document.getElementById('dashboard_data').innerHTML = html; })
      .finally(()=> loader.classList.add('d-none'));
  }

  function fetchBoth(){
    const url = <?php echo json_encode(route('admin.getDashboardData2'), 15, 512) ?>;
    const {sd, ed} = getRangeDates();
    const {psd, ped} = shiftBack(sd, ed);

    const curUrl = `${url}?startDate=${encodeURIComponent(sd)}&endDate=${encodeURIComponent(ed)}`;
    const prvUrl = `${url}?startDate=${encodeURIComponent(psd)}&endDate=${encodeURIComponent(ped)}`;

    skeletonAll();

    Promise.all([fetchJSON(curUrl), fetchJSON(prvUrl)]).then(([cur, prv])=>{
      // Update Values
      const sel = (s)=>document.querySelector(s);
      if(sel('.total_orders')) animateCount(sel('.total_orders'),    cur.total_orders||0);
      if(sel('.pending_orders')) animateCount(sel('.pending_orders'), cur.pending_orders||0);
      if(sel('.complete_orders')) animateCount(sel('.complete_orders'),cur.complete_orders||0);
      if(sel('.cancell_orders')) animateCount(sel('.cancell_orders'), cur.cancell_orders||0);

      if(!window.isWorker){
        if(sel('.sell_amount')) animateCount(sel('.sell_amount'),        cur.sell_amount||0, true);
        if(sel('.total_expense')) animateCount(sel('.total_expense'),    cur.totalExpense||0, true);
        if(sel('.total_net_profit')) animateCount(sel('.total_net_profit'), cur.profit||0, true);
        
        // --- ✅ STOCK WARNING COUNT UPDATE ---
        if(sel('.low_stock_count')) animateCount(sel('.low_stock_count'), cur.low_stock_count||0);
      }

      // Update Trends
      setTrend('total',    cur.total_orders||0,    prv.total_orders||0, true);
      setTrend('pending',  cur.pending_orders||0,  prv.pending_orders||0, false); 
      setTrend('complete', cur.complete_orders||0, prv.complete_orders||0, true);
      setTrend('cancel',   cur.cancell_orders||0,  prv.cancell_orders||0, false);

      if(!window.isWorker){
        setTrend('sell',    cur.sell_amount||0,       prv.sell_amount||0, true);
        setTrend('expense', cur.totalExpense||0,    prv.totalExpense||0, false);
        setTrend('profit',  cur.profit||0,          prv.profit||0, true);
        
        // --- ✅ GENERATE STOCK WARNING LIST TABLE (Fixed for Mobile & Dynamic Label) ---
        const warningArea = document.getElementById('stock_warning_area');
        
        if(cur.low_stock_items && cur.low_stock_items.length > 0 && warningArea) {
            let html = `
              <div class="row mt-4">
                  <div class="col-12">
                      <div class="card border-0 shadow-sm" style="border-radius: 16px;">
                          <div class="card-header bg-white py-3 border-bottom-0">
                               <h5 class="fw-bold text-danger mb-0" style="font-size: 1.1rem;">
                                  <i class="uil uil-exclamation-circle me-2"></i>Critical Stock Alerts (Top 10)
                               </h5>
                          </div>
                          <div class="table-responsive">
                              <table class="table align-middle table-hover mb-0" style="min-width: 500px;">
                                  <thead class="bg-light">
                                      <tr>
                                          <th class="ps-4">Product</th>
                                          <th>Variant</th>
                                          <th class="text-center">Stock</th>
                                          <th class="text-end pe-4">Status</th>
                                      </tr>
                                  </thead>
                                  <tbody>`;
            
            cur.low_stock_items.forEach(item => {
                let pName = item.product ? item.product.name : 'Unknown';
                let img = item.product ? `<?php echo e(asset('products')); ?>/${item.product.image}` : '';
                let size = item.variation && item.variation.size ? item.variation.size.name : '';
                let color = item.variation && item.variation.color ? item.variation.color.name : '';
                let variant = [size, color].filter(Boolean).join(' / ') || 'Single';

                // Limit Name length for mobile
                let displayName = pName.length > 30 ? pName.substring(0, 30) + '...' : pName;

                html += `
                    <tr>
                        <td class="ps-4">
                            <div class="d-flex align-items-center">
                                <img src="${img}" width="35" height="35" class="rounded me-2 bg-light border">
                                <span class="fw-bold text-dark text-wrap" style="max-width: 200px; font-size: 0.9rem;">${displayName}</span>
                            </div>
                        </td>
                        <td class="text-muted small">${variant}</td>
                        <td class="text-center"><span class="badge bg-danger rounded-pill">${item.quantity}</span></td>
                        <td class="text-end pe-4 text-danger fw-bold small">Low (<= ${window.dynLimit})</td>
                    </tr>`;
            });

            html += `</tbody></table></div></div></div></div>`;
            warningArea.innerHTML = html;
        } else if(warningArea) {
            warningArea.innerHTML = '';
        }
      }
    });
  }

  /* ===== Init Tooltips ===== */
  function initTooltips(){
    const tEls = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    tEls.map(el => new bootstrap.Tooltip(el));
  }

  document.addEventListener('DOMContentLoaded', function(){
    const sd = document.querySelector('input[name="startDate"]');
    const ed = document.querySelector('input[name="endDate"]');

    ed.min = sd.min;
    function clamp(){ if (ed.value < sd.value) ed.value = sd.value; }

    fetchBoth();
    // Removed unnecessary fetchDashboardData() call for worker

    sd.addEventListener('change', ()=>{ clamp(); fetchBoth(); });
    ed.addEventListener('change', ()=>{ clamp(); fetchBoth(); });

    document.getElementById('refreshBtn').addEventListener('click', ()=>{ fetchBoth(); });

    document.querySelectorAll('.quick-range .btn').forEach(btn=>{
      btn.addEventListener('click', ()=> applyRange(btn.dataset.range));
    });

    document.addEventListener('shown.bs.tab', initTooltips);
  });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('backend.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/chirkut1/public_html/resources/views/backend/dashboard.blade.php ENDPATH**/ ?>