<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <?php
        $information    = \App\Models\Information::first();

        // ✅✅ DYNAMIC COLORS & TEXTS SETUP
        $brandGradient  = $ln_pg->theme_gradient_col ?? (optional($information)->gradient_code ?? 'linear-gradient(90deg,#0d6efd,#00276C)');
        $brandSolid     = $ln_pg->theme_primary_col ?? (optional($information)->primary_color ?? '#00276C');

        $btnBgColor     = $ln_pg->btn_bg_color ?? $brandSolid;
        $btnTextColor   = $ln_pg->btn_text_color ?? '#ffffff';

        $txtHero        = $ln_pg->btn_text_hero ?: 'অর্ডার করতে ক্লিক করুন';
        $txtVideo       = $ln_pg->btn_text_video ?: 'অর্ডার করতে চাই';
        $txtFeature     = $ln_pg->btn_text_feature ?: 'অর্ডার করুন';
        $txtForm        = $ln_pg->btn_text_form ?: 'অর্ডার কনফার্ম করুন';

        $pageTitle      = $title ?? ($ln_pg->title1 ?? 'Landing Page');

        $product    = $ln_pg->product ?? null;

        $variations = collect();
        if($product){
            try{
                $product->loadMissing(['variations.size','variations.color', 'variations.stocks', 'category']);
                $variations = $product->variations ?? collect();
            }catch(\Throwable $e){
                $variations = $product->variations ?? collect();
            }
        }

        $defaultVar     = $variations->first();
        $defaultVarId   = $defaultVar->id ?? null;

        $defaultBase = $defaultVar->price ?? null;
        $defaultDisc = $defaultVar->after_discount_price ?? null;

        $defaultPrice = null;
        if($defaultDisc !== null && $defaultDisc !== '' && (float)$defaultDisc > 0){
            $defaultPrice = $defaultDisc;
        }elseif($defaultBase !== null && $defaultBase !== '' && (float)$defaultBase > 0){
            $defaultPrice = $defaultBase;
        }else{
            $defaultPrice = ($product && (float)($product->after_discount ?? 0) > 0)
                ? $product->after_discount
                : ($product->sell_price ?? 0);
        }

        $defaultStock = 0;
        if($defaultVar) {
            $defaultStock = $defaultVar->stocks->sum('quantity');
        } elseif($product) {
            $defaultStock = $product->stock_quantity ?? 0;
        }

        $pixelId = setting('fb_pixel_id') ?? null;
        $contentCategory = $product?->category?->name ?? 'Landing Page';
        $productId   = $product->id ?? 0;
        $productName = $product->name ?? '';
    ?>

    <title><?php echo e($pageTitle); ?></title>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('backend/landing_page/css/owl.css')); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css">
    <link rel="stylesheet" href="<?php echo e(asset('backend/landing_page/css/owl.theme.min.css')); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.theme.default.min.css">
    
    
    <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <link rel="stylesheet" href="<?php echo e(asset('backend/landing_page/css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/landing_page/css/media.css')); ?>">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" integrity="sha384-rbsA2VBKQhggwzxH7pPCaAqO46MgnOM80zW1RWuH61DGLwZJEdK2Kadq2F9CUG65" crossorigin="anonymous">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;500;600;700;900&display=swap"/>

    <style>
        :root{
            --brand-gradient: <?php echo $brandGradient; ?>;
            --brand-solid: <?php echo e($brandSolid); ?>;
            --btn-bg: <?php echo e($btnBgColor); ?>;
            --btn-text: <?php echo e($btnTextColor); ?>;
            
            --bg: #f6f8ff;
            --card: #ffffff;
            --text: #0f172a;
            --muted: #64748b;
            --border: rgba(15,23,42,.10);
            --radius-xl: 26px;
            --radius: 18px;
            --shadow: 0 18px 45px rgba(2,6,23,.14);
            --shadow-soft: 0 14px 30px rgba(2,6,23,.08);
        }

        html,body{ width:100%; overflow-x:hidden; }
        body{
            font-family:'Hind Siliguri', sans-serif !important;
            background: var(--bg);
            color: var(--text);
        }

        /* ✅✅✅ TOASTR CUSTOM STYLES (GREEN BG & WHITE TEXT) */
        #toast-container {
            z-index: 9999999 !important;
        }
        #toast-container > .toast {
            opacity: 1 !important;
            box-shadow: 0 4px 12px rgba(0,0,0,0.15) !important;
        }
        /* Success Message - Green */
        #toast-container > .toast-success {
            background-color: #28a745 !important; /* Green Color */
            color: #ffffff !important;
        }
        /* Error Message - Red */
        #toast-container > .toast-error {
            background-color: #dc3545 !important; /* Red Color */
            color: #ffffff !important;
        }
        /* Text Color Force White */
        .toast-message, .toast-title {
            color: #ffffff !important;
        }
        .toast-close-button {
            color: #ffffff !important;
            opacity: 0.8 !important;
        }

        .container-fluid-landing{
            width: 100%;
            max-width: 1160px;
            margin: 0 auto;
            padding: 0 14px;
        }
        .container-premium{
            max-width:1160px;
            margin:0 auto;
            padding: 0 14px;
        }

        .top-div{
            width:100%;
            margin:0;
            position:relative;
            background: var(--brand-gradient);
            display:flex;
            align-items:center;
            justify-content:center;
            min-height: 340px;
            padding: 26px 0;
            overflow:hidden;
            border-bottom-left-radius: 32px;
            border-bottom-right-radius: 32px;
        }
        .hero-inner{
            width:100%;
            max-width: 980px;
            margin: 0 auto;
            padding: 22px 18px;
            text-align:center;
            background: rgba(255,255,255,.12);
            border: 1px solid rgba(255,255,255,.22);
            border-radius: var(--radius-xl);
            box-shadow: 0 18px 55px rgba(0,0,0,.25);
            backdrop-filter: blur(8px);
            position:relative;
            z-index:2;
        }
        .hero-title{
            margin:0;
            color:#fff;
            font-weight:900;
            line-height:1.2;
            font-size: clamp(22px, 3.0vw, 44px);
            text-shadow: 0 10px 22px rgba(0,0,0,.22);
        }
        .hero-sub{
            margin-top:10px;
            color: rgba(255,255,255,.92);
            font-weight: 700;
            font-size: 16px;
        }
        .hero-actions{
            margin-top: 16px;
            display:flex;
            gap:12px;
            justify-content:center;
            flex-wrap:wrap;
            align-items:center;
        }

        .btn-primary-brand{
            background: var(--btn-bg) !important;
            color: var(--btn-text) !important;
            border: 0 !important;
            font-weight: 900 !important;
            border-radius: 999px !important;
            padding: 12px 18px !important;
            box-shadow: 0 14px 30px rgba(2,6,23,.18);
            letter-spacing: .2px;
            transition: transform .15s ease, box-shadow .15s ease, filter .15s ease;
        }
        .btn-primary-brand:hover{
            transform: translateY(-1px);
            filter: brightness(1.1);
            box-shadow: 0 18px 40px rgba(2,6,23,.22);
        }

        button:disabled, .btn-primary-brand:disabled {
            background-color: #94a3b8 !important;
            border-color: #94a3b8 !important;
            cursor: not-allowed !important;
            transform: none !important;
            box-shadow: none !important;
            filter: none !important;
        }

        .offer-badge{
            background: rgba(255,255,255,.92) !important;
            color: var(--text) !important;
            border: 0 !important;
            padding: 10px 14px;
            border-radius: 999px;
            font-size:16px;
            font-weight:900;
            box-shadow: 0 14px 30px rgba(2,6,23,.14);
            display:flex;
            gap:8px;
            align-items:center;
        }
        .offer-badge i{ color: var(--brand-solid); }

        .section-title{
            background: var(--brand-solid) !important;
            color:#fff !important;
            border-radius: 999px;
            padding: 12px 16px;
            text-align:center;
            font-weight:900;
            font-size: 22px;
            box-shadow: 0 14px 30px rgba(2,6,23,.10);
            margin: 0 auto 14px;
            display:inline-block;
        }

        .cardx{
            background: var(--card);
            border: 1px solid var(--border);
            border-radius: var(--radius-xl);
            box-shadow: var(--shadow-soft);
            overflow:hidden;
        }
        .cardx-pad{ padding: 16px; }

        .top_section_img{
            width:100%;
            border-radius: var(--radius-xl);
            box-shadow: var(--shadow-soft);
            border: 1px solid rgba(255,255,255,.35);
        }

        .video-16x9{
            position: relative;
            width: 100%;
            padding-top: 56.25%;
            border-radius: var(--radius-xl);
            overflow: hidden;
            background: #000;
            box-shadow: var(--shadow-soft);
        }
        .video-16x9 iframe, .video-16x9 video{
            position:absolute; inset:0;
            width:100% !important;
            height:100% !important;
            border:0;
        }

        .call-box{
            background: linear-gradient(135deg, rgba(255,255,255,.96), rgba(255,255,255,.92));
            border: 1px solid var(--border);
            border-radius: var(--radius-xl);
            text-align:center;
            padding: 16px 18px;
            box-shadow: var(--shadow-soft);
        }
        .call-pill{
            display:inline-flex;
            gap:10px;
            align-items:center;
            padding: 10px 14px;
            border-radius: 999px;
            background: rgba(2,6,23,.04);
            border: 1px solid rgba(2,6,23,.08);
            font-weight: 900;
        }
        .call-pill a{ text-decoration:none; color: var(--brand-solid); }

        .left_side_text{
            background: var(--brand-solid) !important;
            color:#fff !important;
            text-align:center;
            padding: 14px 16px;
            font-size: 22px;
            font-weight: 900;
        }
        .left_side_details{
            padding: 14px 16px;
            color: var(--text);
        }

        .form-wrapper{
            background: var(--card);
            border: 1px solid var(--border);
            border-radius: var(--radius-xl);
            padding: 18px;
            box-shadow: var(--shadow-soft);
        }
        .billing-title{ font-weight:900; font-size: 34px; margin:0 0 14px 0; }
        .order-title{ font-weight:900; font-size: 34px; margin:0 0 14px 0; }

        .form-control{
            border-radius: 14px !important;
            border: 1px solid rgba(0,39,108,.22) !important;
            box-shadow: 0 10px 24px rgba(0,39,108,.06);
            min-height: 48px;
        }
        .form-control:focus{
            border-color: rgba(0,39,108,.45) !important;
            box-shadow: 0 14px 28px rgba(0,39,108,.12) !important;
            outline: none !important;
        }
        .form-select {
            border-radius: 14px !important;
            border: 1px solid var(--brand-solid) !important;
            padding: 12px;
            font-weight: 700;
            background-color: #fcfcfc;
        }

        @media (min-width: 992px){
            .order-sticky{ position: sticky; top: 18px; }
        }

        .review-order-table{ width:100%; border-collapse: collapse; }
        .review-order-table thead th{
            font-weight: 900; padding: 10px 0;
            border-bottom: 1px solid rgba(2,6,23,.10);
            color: var(--text);
        }
        .review-order-table td, .review-order-table th{ padding: 10px 0; vertical-align: top; }
        .product-image{ display:flex; align-items:center; gap:12px; }
        .product-thumbnail{
            width: 58px; height: 58px; border-radius: 16px; overflow:hidden;
            border: 1px solid rgba(2,6,23,.08); background:#fff;
            box-shadow: 0 10px 25px rgba(2,6,23,.06); flex: 0 0 auto;
        }
        .product-thumbnail img{ width:100%; height:100%; object-fit:cover; }
        .product-name-td{ font-weight: 900; font-size: 16px; color: var(--text); }
        .price-amount{ font-weight: 900; font-size: 18px; color: var(--text); }

        .pro-qty{ display:flex; align-items:center; gap:8px; }
        .quantity-button{
            width:38px; height:38px; border-radius: 12px;
            display:flex; align-items:center; justify-content:center;
            background: rgba(2,6,23,.06); border: 1px solid rgba(2,6,23,.10);
            cursor:pointer; font-weight: 900; user-select:none;
        }
        .inner_qty{
            width:68px !important; height:38px; border-radius: 12px;
            border: 1px solid rgba(2,6,23,.12); text-align:center;
            font-weight: 900; box-shadow: 0 10px 24px rgba(2,6,23,.05);
        }

        .totals-row{ border-top: 1px dashed rgba(2,6,23,.18); padding-top: 10px; }
        #total{ font-size: 22px; font-weight: 900; color: var(--brand-solid); }

        .place-order .button.btn-primary-brand{
            width:100% !important; padding: 16px 18px !important;
            border-radius: 22px !important; font-size: 20px !important; line-height: 1.1;
        }

        .whats_btn{
            position: fixed; right: 16px; bottom: 16px; z-index: 9999;
            width: 54px; height: 54px; border-radius: 999px;
            background: #25D366; display:flex; align-items:center; justify-content:center;
            box-shadow: 0 10px 25px rgba(0,0,0,.25); text-decoration:none;
        }
        .whats_btn img{ width: 28px; height: 28px; }

        .scrollTopBtn{
            position: fixed; right: 16px; bottom: 84px; z-index: 9999;
            width: 48px; height: 48px; border-radius: 999px;
            background: var(--brand-solid); color:#fff; border:0; display:none;
            align-items:center; justify-content:center;
            box-shadow: 0 10px 25px rgba(0,0,0,.20); cursor:pointer;
        }

        @media (max-width: 767px){
            .billing-title, .order-title{ font-size: 28px; }
            .hero-inner{ padding: 18px 14px; }
            .top-div{ border-bottom-left-radius: 22px; border-bottom-right-radius: 22px; }

            .review-order-table { table-layout: fixed; width: 100%; }
            .variation-wrap { width: 100%; overflow: hidden; }
            #variation_select, .form-select {
                max-width: 100%;
                width: 100%;
                white-space: nowrap;
                text-overflow: ellipsis;
                overflow: hidden;
            }

            /* ✅✅✅ HIDE WHATSAPP & SCROLL TOP ON MOBILE */
            .whats_btn, .scrollTopBtn {
                display: none !important;
            }
        }

        .stock-status {
            font-size: 14px;
            font-weight: 800;
            margin-top: 4px;
            display: block;
        }
        .in-stock { color: #10b981; }
        .out-stock { color: #ef4444; }
        
        .coupon-section {
            background-color: #f8f9fa;
            border: 1px dashed #ced4da;
            border-radius: 12px;
            padding: 15px;
            margin-top: 15px;
        }
        .coupon-input-group {
            display: flex;
            box-shadow: 0 4px 12px rgba(0,0,0,0.05);
            border-radius: 50px;
            overflow: hidden;
            border: 1px solid #e9ecef;
        }
        .coupon-input-group input {
            border: none;
            padding: 12px 20px;
            flex-grow: 1;
            font-size: 14px;
            outline: none;
            min-width: 0; /* ✅ Fix for mobile flexbox */
        }
        .coupon-input-group button {
            border: none;
            background: #212529;
            color: #fff;
            padding: 0 25px;
            font-weight: 700;
            font-size: 14px;
            cursor: pointer;
            transition: background 0.3s;
            flex-shrink: 0; /* ✅ Fix to prevent button disappearing on mobile */
        }
        .coupon-input-group button:hover {
            background: #000;
        }
        
        /* ✅ Payment Method Styles */
        .payment-label {
            cursor: pointer;
            transition: all 0.2s;
            border: 1px solid rgba(0,0,0,0.1);
        }
        .payment-label:hover {
            background-color: #f8f9fa !important;
            border-color: rgba(0,0,0,0.2);
        }
        input[name="payment_method"]:checked + span {
            color: var(--brand-solid);
        }
        input[name="payment_method"]:checked ~ .payment-label {
            border-color: var(--brand-solid) !important;
            background-color: rgba(0, 39, 108, 0.05) !important;
        }
    </style>

    <?php if(!empty(optional($information)->tracking_code)): ?>
        <?php echo $information->tracking_code; ?>

    <?php endif; ?>

    <?php if(!empty($pixelId)): ?>
        <script>
        !function(f,b,e,v,n,t,s)
        {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
        n.callMethod.apply(n,arguments):n.queue.push(arguments)};
        if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
        n.queue=[];t=b.createElement(e);t.async=!0;
        t.src=v;s=b.getElementsByTagName(e)[0];
        s.parentNode.insertBefore(t,s)}(window, document,'script',
        'https://connect.facebook.net/en_US/fbevents.js');

        fbq('init', '<?php echo e($pixelId); ?>');
        fbq('track', 'PageView');
        </script>
        <noscript>
        <img height="1" width="1" style="display:none"
            src="https://www.facebook.com/tr?id=<?php echo e($pixelId); ?>&ev=PageView&noscript=1"/>
        </noscript>
    <?php endif; ?>

    <script>
    (function(){
      window.LP_EVENT_BASE = 'LP_<?php echo e($productId); ?>_' + Date.now();

      function waitForFbq(cb, tries){
        tries = tries || 0;
        if(typeof window.fbq === 'function') return cb();
        if(tries > 60) return;
        setTimeout(function(){ waitForFbq(cb, tries+1); }, 100);
      }

      function getValue(){
        var priceEl = document.getElementById('price_val');
        return Number(priceEl ? priceEl.value : 0) || 0;
      }

      function fireLPEvents(){
        var value = getValue();
        var contentId = '<?php echo e($productId); ?>';
        var contentName = <?php echo json_encode($productName, 15, 512) ?>;
        var contentCategory = <?php echo json_encode($contentCategory, 15, 512) ?>;
        var currency = 'BDT';

        try{
          fbq('track', 'ViewContent', {
            content_ids: [contentId],
            content_name: contentName,
            content_type: 'product',
            content_category: contentCategory,
            value: value,
            currency: currency
          }, {eventID: window.LP_EVENT_BASE + '_VC'});

          fbq('track', 'InitiateCheckout', {
            content_ids: [contentId],
            content_name: contentName,
            content_type: 'product',
            value: value,
            currency: currency,
            num_items: 1
          }, {eventID: window.LP_EVENT_BASE + '_IC'});
        }catch(e){}

        window.dataLayer = window.dataLayer || [];
        window.dataLayer.push({
          event: 'view_content',
          ecommerce: {
            currency: currency,
            value: value,
            items: [{
              item_id: contentId,
              item_name: contentName,
              item_category: contentCategory,
              price: value,
              quantity: 1
            }]
          }
        });
        window.dataLayer.push({
          event: 'initiate_checkout',
          ecommerce: {
            currency: currency,
            value: value,
            items: [{
              item_id: contentId,
              item_name: contentName,
              item_category: contentCategory,
              price: value,
              quantity: 1
            }]
          }
        });
      }

      window.addEventListener('load', function(){
        waitForFbq(fireLPEvents);
      });
    })();
    </script>

</head>

<body>
<div class="main-wrapper">

    <div class="top-div">
        <div class="container-premium">
            <div class="hero-inner" data-aos="fade-down" data-aos-duration="900">
                <h2 class="hero-title"><?php echo e($ln_pg->title1); ?></h2>
                <div class="hero-sub"><?php echo e($ln_pg->call_text ?? ''); ?></div>
                <div class="hero-actions" data-aos="fade-up" data-aos-duration="900">
                    <a href="javascript:void(0)" class="btn btn-primary-brand js-scroll-order">
                        <i class="fa fa-shopping-cart"></i>&nbsp;&nbsp;<?php echo e($txtHero); ?>

                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="container-fluid-landing" style="margin-top:12px;">
        <div class="cardx" style="padding:14px;">
            <img src="<?php echo e(asset('landing_pages/'.$ln_pg->landing_bg)); ?>" class="top_section_img" alt="img">
            <div style="text-align:center; margin-top:14px;">
                <span class="section-title"><?php echo e($ln_pg->title1); ?></span>
            </div>
        </div>
    </div>

    <div class="container-fluid-landing" style="margin-top:18px; margin-bottom:22px;">

        <div class="cardx cardx-pad" data-aos="zoom-in">
            <div class="video-16x9"><?php echo $ln_pg->video_url; ?></div>
            <div style="margin-top:16px; text-align:center;">
                <button type="button" class="btn btn-primary-brand js-scroll-order">
                    <?php echo e($txtVideo); ?> <img src="<?php echo e(asset('frontend/images/hand.png')); ?>" style="width:22px; height:auto; margin-left:6px;" alt="">
                </button>
            </div>
        </div>

        <div class="call-box" style="margin-top:16px;">
            <div class="call-pill">
                <i class="fa-solid fa-phone"></i>
                <a href="tel:<?php echo e($ln_pg->phone); ?>"><?php echo e($ln_pg->phone); ?></a>
            </div>
        </div>

        <div class="cardx" style="margin-top:16px;">
            <div class="left_side_text"><?php echo e($ln_pg->left_side_title); ?></div>
            <div class="left_side_details"><?php echo $ln_pg->left_side_desc; ?></div>
        </div>

        <div class="cardx cardx-pad" style="margin-top:16px;">
            <div style="text-align:center;">
                <span class="section-title"><?php echo e($ln_pg->feature); ?></span>
            </div>
            <div class="owl-carousel img-gallery" style="margin-top:12px;">
                <?php $__currentLoopData = $ln_pg->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div>
                        <img src="<?php echo e(asset('landing_sliders/'.$slider->image)); ?>"
                             style="border-radius:18px; width:100%; height:auto; box-shadow: var(--shadow-soft); border:1px solid rgba(2,6,23,.06);"
                             alt="img">
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <div style="margin-top:16px; text-align:center;">
                <button type="button" class="btn btn-primary-brand js-scroll-order">
                    <?php echo e($txtFeature); ?> <img src="<?php echo e(asset('frontend/images/hand.png')); ?>" style="width:22px; height:auto; margin-left:6px;" alt="">
                </button>
            </div>
        </div>

        <div class="cardx cardx-pad" style="margin-top:16px;">
            <?php if(isset($ln_pg->review_top_text)): ?>
                <div style="text-align:center;">
                    <span class="section-title"><?php echo e($ln_pg->review_top_text); ?></span>
                </div>
            <?php endif; ?>
            <div class="owl-carousel img-gallery2" style="margin-top:12px;">
                <?php $__currentLoopData = $ln_pg->review_images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review_slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div style="padding:4px;">
                        <img src="<?php echo e(asset('review_landing_sliders/'.$review_slider->review_image)); ?>"
                             style="width:100%; height: auto; border-radius:18px; box-shadow: var(--shadow-soft); border:1px solid rgba(2,6,23,.06);"
                             alt="img">
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>

        <div id="element_widget" style="margin-top:16px;">
            <div class="cardx cardx-pad">
                <div style="text-align:center; margin-bottom:10px;">
                    <span class="section-title"><?php echo e(BanglaText('land_instruction')); ?></span>
                </div>

                <div class="form-wrapper">
                    <form action="<?php echo e(route('front.storelandData')); ?>" method="POST" id="checkout_land_form">
                        <?php echo csrf_field(); ?>

                        <input type="hidden" name="purchase_event_id" id="purchase_event_id" value="">
                        
                        
                        <div class="form-group mb-4">
                            <label style="font-weight:900; margin-bottom: 10px; display:block; font-size: 18px;">
                                পেমেন্ট মেথড সিলেক্ট করুন:
                            </label>
                            
                            <div class="d-flex flex-column gap-2">
                                
                                <label class="payment-label p-3 border rounded-3 d-flex align-items-center gap-3 bg-white shadow-sm" style="cursor:pointer;">
                                    <input class="form-check-input mt-0" type="radio" name="payment_method" id="payment_cod" value="cod" checked style="width: 20px; height: 20px;">
                                    <span class="fw-bold fs-5 text-dark">ক্যাশ অন ডেলিভারি (Cash on Delivery)</span>
                                </label>

                                
                                <?php if(isset($information->ssl_active) && $information->ssl_active == 1): ?>
                                <label class="payment-label p-3 border rounded-3 d-flex align-items-center gap-3 bg-white shadow-sm" style="border-color: #00276C !important; cursor:pointer;">
                                    <input class="form-check-input mt-0" type="radio" name="payment_method" id="payment_ssl" value="sslcommerz" style="width: 20px; height: 20px;">
                                    <span class="fw-bold fs-5 text-dark">অনলাইন পেমেন্ট (bKash / Nagad / Card)</span>
                                </label>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="row g-4">
                            <div class="col-lg-6">
                                <div class="cardx cardx-pad" style="height:100%;">
                                    <h3 class="billing-title">Billing Address</h3>

                                    <div class="form-group mb-3">
                                        <label style="font-weight:800;"><?php echo e(BanglaText('name')); ?> <span style="color:#ef4444">*</span></label>
                                        <input type="text" name="first_name" class="form-control">
                                        
                                        <input type="hidden" value="<?php echo e($productId); ?>" name="prd_id">
                                    </div>

                                    <div class="form-group mb-3">
                                        <label style="font-weight:800;"><?php echo e(BanglaText('mobile')); ?> <span style="color:#ef4444">*</span></label>
                                        <input type="text" name="mobile" class="form-control">
                                    </div>

                                    <input type="hidden" id="variation_id" name="variation_id" value="<?php echo e($defaultVarId); ?>">
                                    <input type="hidden" id="total_price_val" name="final_amount" value="">
                                    <input type="hidden" id="shipping_cost" value="0">
                                    
                                    
                                    <input type="hidden" name="amount" value="">
                                    
                                    <input type="hidden" id="product_price" value="<?php echo e($defaultPrice); ?>">
                                    <input type="hidden" id="product_quantity" name="quantity" value="1">
                                    <input type="hidden" id="max_stock" value="<?php echo e($defaultStock); ?>">

                                    <div class="form-group mb-3">
                                        <label style="font-weight:800;"><?php echo e(BanglaText('address')); ?> <span style="color:#ef4444">*</span></label>
                                        <input type="text" name="shipping_address" class="form-control">
                                    </div>

                                    <div class="form-group mb-0">
                                        <label style="font-weight:800;"><?php echo e(BanglaText('delivery_zone')); ?></label>
                                        <select required name="delivery_charge_id" onchange="getCharge()" id="delivery_charge_id" class="form-control">
                                            <?php $__currentLoopData = $charges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $charge): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($charge->id); ?>" data-charge="<?php echo e($charge->amount); ?>">
                                                    <?php echo e($charge->title); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <div class="cardx cardx-pad order-sticky">
                                    <h3 class="order-title">Your Order</h3>

                                    <table class="review-order-table">
                                        <thead>
                                            <tr>
                                                <th class="product-name">Product</th>
                                                <th class="product-total" style="text-align:right;">Subtotal</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr class="cart_item">
                                                <td class="product-name">
                                                    <div class="product-image">
                                                        <?php if(!empty($product)): ?>
                                                            <div class="product-thumbnail">
                                                                <img src="<?php echo e(getImage('products', $product->image)); ?>" alt="">
                                                            </div>
                                                            <div class="product-name-td"><?php echo e($productName); ?></div>
                                                        <?php endif; ?>
                                                    </div>
                                                </td>
                                                <td class="product-total" style="text-align:right;">
                                                    <span id="price" class="price-amount amount"><?php echo e($defaultPrice); ?></span>
                                                    <input type="hidden" id="price_val" value="<?php echo e($defaultPrice); ?>">

                                                    <div id="stock_status" class="stock-status <?php echo e($defaultStock > 0 ? 'in-stock' : 'out-stock'); ?>">
                                                        <?php echo e($defaultStock > 0 ? 'In Stock: '.$defaultStock : 'Out of Stock'); ?>

                                                    </div>
                                                </td>
                                            </tr>

                                            <?php if($variations->count()): ?>
                                            <tr>
                                                <td colspan="2">
                                                    <div class="variation-wrap">
                                                        <div style="font-weight:900; margin-bottom:6px;">
                                                            Select Variation (Size / Color) <span class="text-danger">*</span>
                                                        </div>

                                                        <div class="form-group">
                                                            <select id="variation_select" class="form-control form-select">
                                                                <?php $__currentLoopData = $variations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php
                                                                        $vBase  = $v->price ?? $product->sell_price ?? 0;
                                                                        $vDisc  = $v->after_discount_price ?? null;
                                                                        $vPrice = ((float)$vDisc > 0) ? $vDisc : $vBase;
                                                                        $vStock = $v->stocks->sum('quantity');
                                                                        $sizeName  = $v->size->name ?? $v->size->title ?? '';
                                                                        $colorName = $v->color->name ?? '';
                                                                        $label = trim(($sizeName ?: '') . (($sizeName && $colorName) ? ' - ' : '') . ($colorName ?: ''));
                                                                    ?>

                                                                    <option value="<?php echo e($v->id); ?>"
                                                                            data-price="<?php echo e($vPrice); ?>"
                                                                            data-stock="<?php echo e($vStock); ?>"
                                                                            <?php echo e(($defaultVarId && $v->id == $defaultVarId) ? 'selected' : ''); ?>>
                                                                        <?php echo e($label ?: ('Variation #'.$v->id)); ?> - <?php echo e($vPrice); ?> Tk
                                                                    </option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                            <?php endif; ?>

                                            <tr>
                                                <td style="font-weight:900;">Select Quantity</td>
                                                <td style="text-align:right;">
                                                    <div class="pro-qty item-quantity" style="justify-content:flex-end;">
                                                        <span class="decrease-qty quantity-button">-</span>
                                                        <input type="text" class="inner_qty qty-input quantity-input" value="1" inputmode="numeric">
                                                        <span class="increase-qty quantity-button">+</span>
                                                    </div>
                                                </td>
                                            </tr>

                                            <?php if(isset($information->coupon_visibility) && $information->coupon_visibility == 1): ?>
                                            <tr>
                                                <td colspan="2">
                                                    
                                                    <div class="coupon-section">
                                                        <label class="fw-bold mb-2 text-dark" style="font-size:15px;">কুপন কোড (যদি থাকে)</label>
                                                        <div class="coupon-input-group">
                                                            <input type="text" id="coupon_code" placeholder="Enter coupon code">
                                                            <button type="button" onclick="applyCouponLand()">APPLY</button>
                                                        </div>
                                                        <small id="coupon_msg" class="d-block mt-2 fw-bold"></small>
                                                    </div>
                                                </td>
                                            </tr>
                                            <?php endif; ?>

                                            <tr class="totals-row">
                                                <td style="font-weight:900;">Subtotal</td>
                                                <td style="text-align:right;"><span class="final-price-amount amount"></span></td>
                                            </tr>
                                            <tr>
                                                <td style="font-weight:900;">Shipping</td>
                                                <td style="text-align:right;"><span id="delvry_charge">0</span></td>
                                            </tr>
                                            
                                            <?php if(session()->has('coupon_discount')): ?>
                                            <tr>
                                                <td style="font-weight:900; color:green;">Discount</td>
                                                <td style="text-align:right; color:green;">- <?php echo e(session('coupon_discount')); ?></td>
                                            </tr>
                                            <?php endif; ?>

                                            <tr>
                                                <td style="font-weight:900;">Total</td>
                                                <td style="text-align:right;"><strong><span id="total" class="Price-amount amount"></span></strong></td>
                                            </tr>
                                        </tbody>
                                    </table>

                                    <div style="margin-top:12px;">
                                        <p style="color:var(--brand-solid);font-weight:900; margin-top:10px;">
                                            <?php echo e(BanglaText('alert')); ?>

                                        </p>

                                        
                                        <?php if(isset($information->ssl_terms_active) && $information->ssl_terms_active == 1): ?>
                                        <div class="mb-3 mt-4" id="terms_checkbox_area" style="display: none;">
                                            <div class="form-check d-flex align-items-center gap-2">
                                                <input class="form-check-input mt-0" type="checkbox" id="agree_terms" name="agree_terms" value="1" style="width: 20px; height: 20px; cursor: pointer; flex-shrink: 0;">
                                                <label class="form-check-label text-dark mb-0" for="agree_terms" style="cursor: pointer; font-size: 14px; line-height: 1.4;">
                                                    I agree to the 
                                                    <a href="<?php echo e(route('front.privacyPolicy')); ?>" target="_blank" class="text-primary text-decoration-none fw-bold">Privacy Policy</a>, 
                                                    <a href="<?php echo e(url('/page/terms-condition')); ?>" target="_blank" class="text-primary text-decoration-none fw-bold">Terms & Conditions</a>, 
                                                    and 
                                                    <a href="<?php echo e(route('front.returnPolicy')); ?>" target="_blank" class="text-primary text-decoration-none fw-bold">Return Policy</a>.
                                                </label>
                                            </div>
                                            <small class="text-danger d-none fw-bold mt-2 d-block" id="terms_error">You must agree to the terms and policies to proceed.</small>
                                        </div>
                                        <?php endif; ?>
                                        

                                        <div class="form-row place-order">
                                            <button type="submit" id="submit_btn" class="button btn-primary-brand" form="checkout_land_form">
                                                <?php echo e($txtForm); ?>

                                            </button>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <?php
        $waNumber = $ln_pg->whatsapp ?? $ln_pg->phone ?? '';
        $waNumberClean = preg_replace('/\D+/', '', $waNumber);
    ?>
    <?php if(!empty($waNumberClean)): ?>
        <a href="https://wa.me/<?php echo e($waNumberClean); ?>" target="_blank" class="whats_btn" aria-label="WhatsApp">
            <img src="https://img.icons8.com/windows/96/ffffff/whatsapp--v1.png" alt="whatsapp">
        </a>
    <?php endif; ?>

    <button type="button" class="scrollTopBtn" id="scrollTopBtn" aria-label="Scroll to top">
        <i class="fa-solid fa-arrow-up"></i>
    </button>

    <?php echo $__env->make('frontend.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
    <div class="modal fade" id="otpModal" data-bs-backdrop="static" tabindex="-1">
      <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content p-4 rounded-4 border-0 shadow-lg">
          <div class="modal-header border-0 p-0 mb-3">
             <h5 class="modal-title fw-bold">মোবাইল ভেরিফিকেশন</h5>
             <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
          </div>
          <div class="modal-body text-center p-0">
            <p class="text-muted mb-3">আমরা আপনার নাম্বারে ৪ ডিজিটের কোড পাঠিয়েছি</p>
            <input type="text" id="otp_input" class="form-control text-center fs-3 fw-bold mb-3" placeholder="____" maxlength="4">
            <div class="d-grid">
                <button type="button" class="btn btn-primary btn-lg" onclick="verifyOtpLand()">যাচাই করুন</button>
            </div>
            <div class="mt-3">
                 <button type="button" class="btn btn-link text-decoration-none" id="resendOtpBtn" onclick="resendOtpLand()">আবার পাঠান</button>
            </div>
            <p class="text-danger mt-2 fw-bold" id="otp_error"></p>
          </div>
        </div>
      </div>
    </div>

</div>

<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script src="<?php echo e(asset('backend/landing_page/js/carousel.min.js')); ?>"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script>
<script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
<script src="<?php echo e(asset('backend/landing_page/js/main.js')); ?>"></script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.min.js"
        integrity="sha384-cuYeSxntonz0PPNlHhBs68uyIAVpIIOZZ5JqeqvYYIcEL727kskC66kF92t6Xl2V"
        crossorigin="anonymous"></script>

<script>
    // ✅ NEW: Check if Terms are enabled from Admin
    var isTermsEnabled = <?php echo e((isset($information->ssl_terms_active) && $information->ssl_terms_active == 1) ? 'true' : 'false'); ?>;

    function toNumber(v){
        v = (v ?? '').toString().replace(/[^\d.]/g,'');
        var n = parseFloat(v);
        return isNaN(n) ? 0 : n;
    }

    function waitForFbq(cb, tries){
        tries = tries || 0;
        if(typeof window.fbq === 'function') return cb();
        if(tries > 60) return;
        setTimeout(function(){ waitForFbq(cb, tries+1); }, 100);
    }

    function getCharge(){
        let $opt = $('#delivery_charge_id').find("option:selected");
        var charge = toNumber($opt.data('charge'));
        $('span#delvry_charge').text(charge);

        var unitPrice = toNumber($('#price_val').val());
        var qty = toNumber($('.inner_qty').val());
        var maxStock = toNumber($('#max_stock').val());
        
        var discount = <?php echo e(session('coupon_discount') ?? 0); ?>;

        if(maxStock <= 0) {
            qty = 0;
            $('.inner_qty').val(0);
        } else if(qty <= 0) {
            qty = 1;
            $('.inner_qty').val(1);
        } else if(qty > maxStock) {
            toastr.error('Max quantity available: ' + maxStock);
            qty = maxStock;
            $('.inner_qty').val(maxStock);
        }

        var subTotal = unitPrice * qty;
        var total = (subTotal + charge) - discount;

        $('span.final-price-amount').text(subTotal);
        $('#total').text(total);
        $('#total_price_val').val(total);
        $('#product_quantity').val(qty);
        
        // ✅ SSLCommerz Amount Update
        $('input[name="amount"]').val(subTotal); 
    }

    function buildPurchaseEventId(){
        var pid = "<?php echo e($productId); ?>";
        return "PUR_" + pid + "_" + Date.now() + "_" + Math.floor(Math.random() * 1000000);
    }
    
    var isOtpVerified = false;
    var otpSystemEnabled = <?php echo e($information->otp_system ?? 0); ?>;
    var isSendingOtp = false;

    function applyCouponLand() {
        var code = $('#coupon_code').val();
        if(!code) { toastr.error('কুপন কোড লিখুন'); return; }

        $.ajax({
            url: "<?php echo e(route('front.getCouponDiscount')); ?>", 
            method: "GET",
            data: { code: code },
            success: function(res) {
                if(res.success) {
                    toastr.success(res.msg);
                    setTimeout(function(){ location.reload(); }, 1000); 
                } else {
                    $('#coupon_msg').text(res.msg).css('color', 'red');
                    toastr.error(res.msg);
                }
            }
        });
    }

    function sendOtpLand() {
        if(isSendingOtp) return;
        
        var mobile = $('input[name="mobile"]').val();
        if(mobile.length !== 11) { toastr.error('১১ ডিজিটের মোবাইল নাম্বার দিন'); return; }

        isSendingOtp = true;
        var $btn = $('#submit_btn');
        $btn.prop('disabled', true).text('Sending OTP...');

        $.ajax({
            url: "<?php echo e(route('sendOtp')); ?>", 
            type: "POST", 
            data: { mobile: mobile, _token: "<?php echo e(csrf_token()); ?>" },
            success: function(res) {
                isSendingOtp = false;
                $btn.prop('disabled', false).text("<?php echo e($txtForm); ?>");
                
                if(res.success) {
                    $('#otpModal').modal('show');
                    toastr.success(res.msg);
                } else {
                    toastr.error(res.msg);
                }
            },
            error: function(err) {
                isSendingOtp = false;
                $btn.prop('disabled', false).text("<?php echo e($txtForm); ?>");
                console.log(err);
            }
        });
    }

    function verifyOtpLand() {
        var code = $('#otp_input').val();
        var mobile = $('input[name="mobile"]').val();

        $.ajax({
            url: "<?php echo e(route('verifyOtp')); ?>", 
            type: "POST", 
            data: { otp: code, mobile: mobile, _token: "<?php echo e(csrf_token()); ?>" },
            success: function(res) {
                if(res.success) {
                    isOtpVerified = true;
                    $('#otpModal').modal('hide');
                    toastr.success('ভেরিফিকেশন সফল!');
                    $('form#checkout_land_form').submit();
                } else {
                    $('#otp_error').text(res.msg);
                }
            }
        });
    }

    function resendOtpLand() {
        $('#otp_input').val('');
        $('#otp_error').text('');
        $('#otpModal').modal('hide');
        sendOtpLand();
    }

    $(document).ready(function () {
        AOS.init({ duration: 900 });

        // ✅✅✅ TOASTR SETTINGS CONFIG
        toastr.options = {
            "closeButton": true,
            "progressBar": true,
            "positionClass": "toast-top-right",
            "timeOut": "3000",
            "extendedTimeOut": "1000",
        };

        $(".img-gallery").owlCarousel({
            loop: true, autoplay: true, dots: false, margin: 10, nav: false,
            responsive: { 0:{items:1}, 700:{items:3}, 1200:{items:3} }
        });

        $(".img-gallery2").owlCarousel({
            loop: true, autoplay: true, dots: false, margin: 10, nav: false,
            responsive: { 0:{items:1}, 700:{items:1}, 1200:{items:1} }
        });

        $(document).on('click', '.js-scroll-order', function(){
            $('html,body').animate({ scrollTop: $("#element_widget").offset().top - 8 }, 'slow');
        });

        $(document).on('click', '.increase-qty', function () {
            var $qtyInput = $(this).siblings('.inner_qty');
            var q = parseInt($qtyInput.val() || 1);
            $qtyInput.val(q + 1);
            $('#product_quantity').val(q + 1);
            getCharge();
        });

        $(document).on('click', '.decrease-qty', function () {
            var $qtyInput = $(this).siblings('.inner_qty');
            var q = parseInt($qtyInput.val() || 1);
            q = q - 1;
            if (q < 1) q = 1;
            $qtyInput.val(q);
            $('#product_quantity').val(q);
            getCharge();
        });

        $(document).on('change', '#delivery_charge_id', function(){
            getCharge();
        });

        $(document).on('change', '#variation_select', function(){
            let selectedOption = $(this).find('option:selected');
            let variation_id = selectedOption.val();
            let price = parseFloat(selectedOption.data('price')) || 0;
            let stock = parseInt(selectedOption.data('stock')) || 0;

            $("#variation_id").val(variation_id);
            $('#product_price').val(price);
            $('#price_val').val(price);
            $('.price-amount').text(price);
            $('#max_stock').val(stock);

            let $stockDiv = $('#stock_status');
            let $submitBtn = $('#submit_btn');

            if(stock > 0){
                $stockDiv.text('In Stock: ' + stock).removeClass('out-stock').addClass('in-stock');
                $submitBtn.prop('disabled', false).html("<?php echo e($txtForm); ?>");
                $('.inner_qty').val(1);
            } else {
                $stockDiv.text('Out of Stock').removeClass('in-stock').addClass('out-stock');
                $submitBtn.prop('disabled', true).html('Out of Stock');
                $('.inner_qty').val(0);
            }

            getCharge();
        });

        $('#variation_select').trigger('change');
        getCharge();

        $(window).on('scroll', function(){
            if($(this).scrollTop() > 400) $('#scrollTopBtn').fadeIn(150);
            else $('#scrollTopBtn').fadeOut(150);
        });
        $('#scrollTopBtn').on('click', function(){
            $('html,body').animate({scrollTop: 0}, 400);
        });

        // ✅✅✅ INCOMPLETE ORDER TRIGGER ADDED
        $(document).on('blur', 'input[name="mobile"]', function () {
            let mobile = $(this).val();
            let name = $('input[name="first_name"]').val();
            let address = $('input[name="shipping_address"]').val();
            let prd_id = $('input[name="prd_id"]').val(); 
            let variation_id = $('#variation_id').val();
            let quantity = $('.inner_qty').val();
            let amount = $('#price_val').val();

            if (mobile && mobile.length === 11) {
                $.post("<?php echo e(route('incompleteStore')); ?>", {
                    mobile: mobile,
                    name: name,
                    address: address,
                    prd_id: prd_id,
                    variation_id: variation_id,
                    quantity: quantity,
                    amount: amount,
                    _token: "<?php echo e(csrf_token()); ?>"
                }).done(function(response){
                    console.log("Draft Saved");
                });
            }
        });

        // ✅✅✅ TOGGLE TERMS VISIBILITY WHEN PAYMENT METHOD CHANGES
        $(document).on('change', 'input[name="payment_method"]', function() {
            var method = $(this).val();
            var termsArea = $('#terms_checkbox_area');
            
            if (method === 'sslcommerz') {
                if(isTermsEnabled) termsArea.slideDown();
            } else {
                if(isTermsEnabled) termsArea.slideUp();
            }
        });
        // Trigger on load
        $('input[name="payment_method"]:checked').trigger('change');

        // ✅✅✅ UPDATED SUBMIT LOGIC (COD + SSL WITH TERMS CHECK)
        $(document).on('submit', 'form#checkout_land_form', function (e) {
            e.preventDefault();
            $('span.textdanger').remove();
            
            var paymentMethod = $('input[name="payment_method"]:checked').val();

            // 1. ✅ TERMS AND CONDITIONS VALIDATION FOR SSL
            if(paymentMethod === 'sslcommerz' && isTermsEnabled) {
                if(!$('#agree_terms').is(':checked')) {
                    $('#terms_error').removeClass('d-none');
                    return false; // Stop form submission
                } else {
                    $('#terms_error').addClass('d-none');
                }
            }

            // 2. Check OTP (if enabled)
            if(otpSystemEnabled == 1 && !isOtpVerified) {
                sendOtpLand();
                return;
            }

            // 3. Check Stock
            var maxStock = toNumber($('#max_stock').val());
            if(maxStock <= 0) {
                toastr.error('Sorry, product is out of stock!');
                return;
            }

            // 4. Update Qty
            var q = toNumber($('.inner_qty').val());
            if(q <= 0) q = 1;
            $('#product_quantity').val(q);

            getCharge();

            let $form = $(this);

            // ===========================================
            // ✅ IF SSLCOMMERZ (ONLINE PAYMENT)
            // ===========================================
            if (paymentMethod === 'sslcommerz') {
                $form.attr('action', "<?php echo e(url('/pay')); ?>");
                $form.attr('method', 'POST');
                
                // Show loading on button
                $('#submit_btn').prop('disabled', true).html('Processing Payment...');
                
                // Submit normally (not AJAX) to redirect
                e.currentTarget.submit();
                return;
            }

            // ===========================================
            // ✅ IF COD (CASH ON DELIVERY)
            // ===========================================
            var purchaseEventId = buildPurchaseEventId();
            $('#purchase_event_id').val(purchaseEventId);

            var url = "<?php echo e(route('front.storelandData')); ?>"; // Route for COD
            var formData = $form.serialize();

            var total = toNumber($('#total_price_val').val());
            var ship_charge = (function(){
                var $sel = $('#delivery_charge_id').find(':selected');
                return toNumber($sel.length ? ($sel.data('charge') || 0) : 0);
            })();

            var unitPrice = toNumber($('#price_val').val());
            var pid = "<?php echo e($productId); ?>";
            var pname = <?php echo json_encode($productName, 15, 512) ?>;
            var cat = <?php echo json_encode($contentCategory, 15, 512) ?>;

            var items = [{
                item_id: pid,
                item_name: pname,
                item_category: cat,
                price: unitPrice,
                quantity: q
            }];

            var first_name = $('input[name="first_name"]').val();
            var mobile = $('input[name="mobile"]').val();
            var shipping_address = $('input[name="shipping_address"]').val();

            $.ajaxSetup({
                headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') }
            });

            var $btn = $('#submit_btn');
            $btn.prop('disabled', true).html('Processing...');

            $.ajax({
                type: 'POST',
                url: url,
                data: formData,
                success: function (res) {
                    if (res.success == true) {
                        var transaction_id = res.invoice_no || ('LP-' + Math.floor(Math.random() * 1000000));
                        var finalEventId = res.purchase_event_id || purchaseEventId;

                        waitForFbq(function(){
                            try{
                                fbq('track', 'Purchase', {
                                    currency: "BDT",
                                    value: total,
                                    content_type: "product",
                                    content_ids: [String(pid)],
                                    content_name: pname,
                                    content_category: cat,
                                    num_items: q,
                                    contents: [{
                                        id: String(pid),
                                        quantity: q,
                                        item_price: unitPrice
                                    }]
                                }, {eventID: finalEventId});
                            }catch(e){}
                        });

                        window.dataLayer = window.dataLayer || [];
                        window.dataLayer.push({
                            event: 'purchase',
                            ecommerce: {
                                currency: "BDT",
                                value: total,
                                shipping: ship_charge,
                                transaction_id: transaction_id,
                                items: items
                            },
                            customer: {
                                first_name: first_name,
                                phone: mobile,
                                shipping_address: shipping_address
                            }
                        });

                        toastr.success(res.msg);

                        if (res.url) {
                            document.location.href = res.url;
                        } else {
                            window.location.reload();
                        }

                    } else {
                        toastr.error(res.msg || 'Something went wrong!');
                        $btn.prop('disabled', false).html("<?php echo e($txtForm); ?>");
                    }
                },
                error: function (response) {
                    $btn.prop('disabled', false).html("<?php echo e($txtForm); ?>");

                    if(response.responseJSON && response.responseJSON.errors){
                        $.each(response.responseJSON.errors, function (field_name, error) {
                            $(document).find('[name="'+field_name+'"]').after(
                                '<span class="textdanger" style="color:red;display:block;margin-top:6px;font-weight:700;">'+ error +'</span>'
                            );
                        });
                        toastr.error('ফর্মের তথ্যগুলো সঠিকভাবে পূরণ করুন');
                    } else {
                        toastr.error(response.responseJSON?.msg || 'Validation/Error occurred! Check console.');
                        console.log(response);
                    }
                }
            });
        });
    });
</script>

</body>
</html><?php /**PATH /home/deshitest/public_html/resources/views/backend/landing_pages/land_page_two.blade.php ENDPATH**/ ?>