
<?php $__env->startSection('content'); ?>

<style>
  :root{
    --primary:#00276C;
    --primary2:#033199;
    --bg:#f5f6fa;
    --card:#ffffff;
    --text:#0f172a;
    --muted:#64748b;
    --border:rgba(2,6,23,.10);
    --shadow:0 18px 50px rgba(0,39,108,.12);
    --shadow2:0 14px 30px rgba(0,39,108,.18);
    --radius:18px;
  }

  /* OTP Modal CSS */
  #otpModal {
      z-index: 99999 !important; /* ✅ ফিক্স: পপআপকে সবকিছুর উপরে রাখার জন্য */
  }
  .otp-modal-content {
      border: none !important;
      border-radius: 20px !important;
      background: #ffffff;
      box-shadow: 0 10px 40px rgba(0, 0, 0, 0.2);
      text-align: center;
      overflow: hidden;
      position: relative;
  }
  .otp-modal-content::before {
      content: "";
      position: absolute;
      top: 0; left: 0; right: 0;
      height: 6px;
      background: linear-gradient(90deg, #E2136E, #F6921E);
  }
  .otp-icon-box {
      width: 80px; height: 80px;
      background: #fdf2f7;
      border-radius: 50%;
      display: flex; align-items: center; justify-content: center;
      margin: 10px auto 20px;
      color: #E2136E;
  }
  .otp-input {
      width: 100%; letter-spacing: 15px; text-align: center;
      font-size: 28px; font-weight: bold; color: #333;
      border: 2px solid #eee !important; border-radius: 12px !important;
      background: #fafafa; height: 65px;
      transition: all 0.3s ease;
      position: relative;
      z-index: 999999 !important; /* ✅ ফিক্স: ইনপুট বক্সে ক্লিক নিশ্চিত করার জন্য */
  }
  .otp-input:focus {
      border-color: #E2136E !important; background: #fff;
      box-shadow: 0 5px 15px rgba(226, 19, 110, 0.1) !important; outline: none;
  }
  .btn-verify {
      background: linear-gradient(135deg, #E2136E 0%, #C90D5E 100%);
      border: none; padding: 12px; font-size: 18px; border-radius: 12px;
      box-shadow: 0 8px 20px rgba(226, 19, 110, 0.3);
      width: 100%; color: white; font-family: 'Hind Siliguri', sans-serif;
  }
  .btn-verify:hover { transform: translateY(-2px); box-shadow: 0 12px 25px rgba(226, 19, 110, 0.4); }

  /* General Form Styles */
  input[type='text'], input[type='number'], #selectCourier {
    border: 1px solid rgba(0,39,108,.35) !important;
    border-radius: 14px !important;
    box-shadow: 0 6px 16px rgba(0,39,108,.06);
    transition: box-shadow .2s ease, border-color .2s ease, transform .2s ease;
  }
  input[type='text']:focus, input[type='number']:focus, #selectCourier:focus{
    border-color: rgba(0,39,108,.80) !important;
    box-shadow: 0 0 0 4px rgba(0,39,108,.14), 0 10px 22px rgba(0,39,108,.12) !important;
    outline: none !important;
    transform: translateY(-1px);
  }
  .form-group label, .hind{ font-family: 'Hind Siliguri', sans-serif; }
   
  .section-content{
    background: radial-gradient(circle at 12% 10%, rgba(0,39,108,.06), transparent 45%),
                radial-gradient(circle at 88% 14%, rgba(3,49,153,.06), transparent 42%),
                linear-gradient(180deg, #f5f6fa, #f5f6fa) !important;
  }
  aside.card, .orderDetails{
    background: var(--card) !important;
    border-radius: var(--radius) !important;
    box-shadow: var(--shadow) !important;
  }

  /* Shipping Radio Styles */
  .ship-radio-wrap{
    display:grid; grid-template-columns: repeat(2, minmax(0, 1fr)); gap: 14px;
    justify-content:center; align-items: stretch; max-width: 620px; margin: 0 auto;
  }
  .ship-option{ position:relative; display:block; width: 100%; margin: 0; }
  .ship-option input[type="radio"]{ position:absolute !important; inset:0 !important; opacity:0 !important; cursor:pointer !important; z-index: 3 !important; margin:0 !important; }
  .ship-card{
    position:relative; padding:14px 16px; border-radius:16px;
    background: linear-gradient(180deg, rgba(255,255,255,1), rgba(255,255,255,.98));
    border: 1px solid rgba(0,39,108,.10); text-align:center;
    box-shadow: 0 10px 22px rgba(2,6,23,.06);
    transition: transform .18s ease, box-shadow .18s ease, border-color .18s ease;
    height: 100%; min-height: 78px; display:flex; flex-direction:column; justify-content:center;
  }
  .ship-title{ font-family:'Hind Siliguri', sans-serif; font-weight:900; color:#0f172a; margin-bottom:6px; font-size:16px; }
  .ship-amount{
    display:inline-flex; align-items:center; justify-content:center; gap:6px; padding:6px 12px;
    border-radius:999px; font-weight:900; font-size:13px; color:#fff;
    background: linear-gradient(90deg, var(--primary) 0%, var(--primary2) 100%);
  }
  .ship-option:hover .ship-card{ transform: translateY(-2px); border-color: rgba(0,39,108,.28); }
  .ship-option input[type="radio"]:checked + .ship-card{
    border-color: rgba(0,39,108,.65);
    box-shadow: 0 0 0 4px rgba(0,39,108,.14), 0 18px 45px rgba(0,39,108,.18);
    transform: translateY(-2px);
  }

  /* ✅ Payment Radio Card Style */
  .payment-card-label {
      cursor: pointer;
      transition: all 0.2s;
  }
  .payment-card-label:hover {
      background-color: #f8f9fa;
  }
  input[name="payment_method"]:checked + label {
      color: #00276C !important;
  }

  /* Confirm Button */
  #chk_btn{
    border-radius: 16px !important;
    background: linear-gradient(90deg, var(--primary) 0%, var(--primary2) 100%) !important;
    border: 1px solid rgba(255,255,255,.18) !important;
    box-shadow: 0 18px 40px rgba(0,39,108,.28) !important;
    transition: transform .18s ease, box-shadow .18s ease !important;
  }
  #chk_btn:hover{ transform: translateY(-2px) !important; filter: brightness(1.05) !important; }
  #chk_btn.is-disabled{ opacity:.65 !important; pointer-events:none !important; }

  @media (max-width: 575px){ .ship-radio-wrap{ grid-template-columns: repeat(2, minmax(0, 1fr)) !important; } }
</style>

<?php
use App\Models\Information;
use App\Models\BanglaText;

$info = Information::first();
$bangla_text = BanglaText::first();
$cart = session()->get('cart', []);
$is_free = 0;
foreach($cart as $item){
    if(!empty($item['is_free_shipping']) && $item['is_free_shipping'] == 1){ $is_free = 1; break; }
}
?>

<main class="main-wrapper">
 <section class="section-content py-5" style="margin-top:60px; background: #f5f6fa;">
    <div class="container">
        
        <form action="<?php echo e(route('front.checkouts.store')); ?>" method="POST" id="checkout_form">
            <?php echo csrf_field(); ?>

            
            <?php if(!session()->has('order_token')){ session(['order_token' => (string) \Illuminate\Support\Str::uuid()]); } ?>
            <input type="hidden" name="order_token" value="<?php echo e(session('order_token')); ?>">

            <div class="row g-4">
                <div class="col-lg-6">
                    <aside class="card border-0 shadow-sm rounded-4 p-4">
                        <h4 class="mb-4 fw-bold" style="font-family: 'Hind Siliguri', sans-serif; text-align: justify;">
                            <?php echo e($bangla_text->checkout_form_top_text); ?>

                        </h4>

                        
                        <div class="mb-3">
                            <label class="form-label fs-2 text-dark hind"><?php echo e($bangla_text->name_text); ?></label>
                            <input type="text" name="first_name" id="name" class="form-control rounded-3" required>
                        </div>

                        
                        <div class="mb-3">
                            <label class="form-label fs-2 text-dark hind"><?php echo e($bangla_text->mobile_text); ?></label>
                            <input type="text" maxlength="11" name="mobile" id="mobile" class="form-control rounded-3" required>
                        </div>

                        
                        <div class="mb-3">
                            <label class="form-label fs-2 text-dark hind"><?php echo e($bangla_text->address_text); ?></label>
                            <input type="text" name="shipping_address" id="address" class="form-control rounded-3" required>
                        </div>

                        <input type="hidden" name="ip_address" id="ip_address" value="">

                        <?php
                            $shipping_value = [];
                            foreach($cart as $citem) { $shipping_value[] = $citem['is_free_shipping']; }
                            $hasPaidShipping = (in_array(null, $shipping_value) || $is_free != 1);
                        ?>

                        <div class="mb-3">
                          <label class="form-label fs-2 text-dark hind d-block text-center"><?php echo e($bangla_text->delivery_text); ?></label>

                          <?php if($hasPaidShipping): ?>
                            <div class="ship-radio-wrap">
                              <?php $__currentLoopData = $charges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $charge): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <label class="ship-option">
                                  <input type="radio" name="delivery_charge_id_radio" class="charge_radio_radioui" value="<?php echo e($charge->id); ?>" data-charge="<?php echo e($charge->amount); ?>">
                                  <div class="ship-card">
                                    <div class="ship-title"><?php echo e($charge->title); ?></div>
                                    <div class="ship-amount"><?php echo e(number_format($charge->amount, 2)); ?> ৳</div>
                                  </div>
                                </label>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                            <select required name="delivery_charge_id" id="selectCourier" class="form-select d-none">
                              <?php $__currentLoopData = $charges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $charge): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <option value="<?php echo e($charge->id); ?>" data-charge="<?php echo e($charge->amount); ?>"><?php echo e($charge->title); ?></option> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                          <?php else: ?>
                            <div class="ship-radio-wrap">
                              <label class="ship-option">
                                <input type="radio" name="delivery_charge_id_radio" class="charge_radio_radioui" value="0" data-charge="0" checked>
                                <div class="ship-card"><div class="ship-title">ফ্রী শিপিং</div><div class="ship-amount">0.00 ৳</div></div>
                              </label>
                            </div>
                            <select name="delivery_charge_id" id="selectCourier" class="d-none"><option value="0" data-charge="0" selected>ফ্রী শিপিং</option></select>
                          <?php endif; ?>
                        </div>

                        
                        <div class="mb-3 mt-4">
                            <h6 class="fw-bold mb-2 text-dark" style="font-family: 'Hind Siliguri', sans-serif;">পেমেন্ট মেথড সিলেক্ট করুন:</h6>

                            <?php if(isset($info->cod_active) && $info->cod_active == 1): ?>
                            <div class="card bg-white border shadow-sm rounded-3 mb-2 payment-card-label">
                                <div class="card-body d-flex align-items-center gap-3 p-3">
                                    <input type="radio" value="cod" id="payment_cod"
                                           checked 
                                           class="form-check-input" name="payment_method" 
                                           style="width: 20px; height: 20px; cursor: pointer;"
                                           onchange="togglePaymentAction('cod')"> 
                                    <label for="payment_cod" class="fw-bold text-dark mb-0 w-100" style="font-family: 'Hind Siliguri', sans-serif; cursor: pointer;">
                                        ক্যাশ অন ডেলিভারি (Cash on Delivery)
                                    </label>
                                </div>
                            </div>
                            <?php endif; ?>

                            <?php if(isset($info->ssl_active) && $info->ssl_active == 1): ?>
                            <div class="card bg-white border shadow-sm rounded-3 payment-card-label" style="border: 1px solid #00276C !important;">
                                <div class="card-body d-flex align-items-center gap-3 p-3">
                                    <input type="radio" value="online" id="payment_online"
                                           <?php echo e((isset($info->cod_active) && $info->cod_active == 0) ? 'checked' : ''); ?>

                                           class="form-check-input" name="payment_method" 
                                           style="width: 20px; height: 20px; cursor: pointer;"
                                           onchange="togglePaymentAction('online')"> 
                                    <label for="payment_online" class="fw-bold text-dark mb-0 w-100" style="font-family: 'Hind Siliguri', sans-serif; cursor: pointer;">
                                        অনলাইন পেমেন্ট (bKash / Nagad / Card)
                                    </label>
                                </div>
                            </div>
                            <?php endif; ?>

                            <?php if((!isset($info->cod_active) || $info->cod_active == 0) && (!isset($info->ssl_active) || $info->ssl_active == 0)): ?>
                                <div class="alert alert-danger mt-2">
                                    দুঃখিত, বর্তমানে কোনো পেমেন্ট মেথড চালু নেই। অনুগ্রহ করে কর্তৃপক্ষের সাথে যোগাযোগ করুন।
                                </div>
                            <?php endif; ?>
                        </div>
                        

                        
                        <?php if(isset($info->ssl_terms_active) && $info->ssl_terms_active == 1): ?>
                        <div class="mb-3 mt-3" id="terms_checkbox_area" style="display: none;">
                            <div class="form-check d-flex align-items-center gap-2">
                                <input class="form-check-input" type="checkbox" id="agree_terms" name="agree_terms" value="1" style="width: 20px; height: 20px; cursor: pointer;">
                                <label class="form-check-label text-dark hind mb-0" for="agree_terms" style="cursor: pointer; font-size: 15px;">
                                    I agree to the 
                                    <a href="<?php echo e(route('front.privacyPolicy')); ?>" target="_blank" class="text-primary text-decoration-none fw-bold">Privacy Policy</a>, 
                                    <a href="<?php echo e(url('/page/terms-condition')); ?>" target="_blank" class="text-primary text-decoration-none fw-bold">Terms & Conditions</a>, 
                                    and 
                                    <a href="<?php echo e(route('front.returnPolicy')); ?>" target="_blank" class="text-primary text-decoration-none fw-bold">Return Policy</a>.
                                </label>
                            </div>
                            <small class="text-danger d-none fw-bold mt-2" id="terms_error">You must agree to the terms and policies to proceed.</small>
                        </div>
                        <?php endif; ?>

                        <input type="hidden" name="amount" id="ssl_amount" value="<?php echo e($totalPrice); ?>">

                        <div class="d-grid mt-4">
                            <button type="submit" id="chk_btn" class="btn btn-lg fw-bold main-bg fs-2 text-white rounded-3 hind">
                                <?php echo e($bangla_text->order_confirm_text); ?>

                            </button>
                        </div>
                    </aside>
                </div>

                <div class="col-lg-6">
                    <div class="card border-0 shadow-sm rounded-4 p-4 orderDetails bg-white sticky-top" style="top: 100px;">
                        <?php echo $__env->make('frontend.cart.details', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
                 
                
                <?php $__currentLoopData = $cart; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="cart-item-data"
                         data-product-id="<?php echo e($item['product_id']); ?>"
                         data-product-name="<?php echo e($item['name']); ?>"
                         data-category-name="<?php echo e($item['category_name']); ?>"
                         data-price="<?php echo e($item['price']); ?>"
                         data-quantity="<?php echo e($item['quantity']); ?>">
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                

                <input type="hidden" name="total_cart_price" value="<?php echo e($totalPrice); ?>">
            </div>
        </form>
    </div>
</section>
</main> 
<div class="modal fade" id="otpModal" data-bs-backdrop="static" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content otp-modal-content p-4">
      <div class="modal-header border-0 pb-0 justify-content-end">
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body text-center pt-0 pb-4">
        <div class="otp-icon-box"><i class="fas fa-shield-alt fa-2x"></i></div>
        <h4 class="fw-bold mb-2 otp-title">মোবাইল ভেরিফিকেশন</h4>
        <p class="otp-subtitle">আপনার <span class="fw-bold text-dark" id="otp_sent_number"></span> নাম্বারে কোড পাঠানো হয়েছে।</p>
        <div class="form-group mb-4">
            <input type="text" id="otp_input" maxlength="4" class="form-control otp-input" placeholder="____" autocomplete="one-time-code" inputmode="numeric">
            <small class="text-danger mt-2 d-block fw-bold" id="otp_error"></small>
        </div>
        <button type="button" class="btn-verify" onclick="verifyOtpNow()">যাচাই করুন (Verify)</button>
        <div class="text-center mt-3">
             <button type="button" class="btn btn-link text-decoration-none text-muted p-0 small" id="resendOtpBtn" onclick="resendOtp()">
                 কোড পাননি? <span class="text-primary fw-bold">আবার পাঠান</span>
             </button>
        </div>
      </div>
    </div>
  </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('frontend/js/checkout.js')); ?>"></script>
<script>
// ✅ NEW: Check if Terms are enabled from Admin
var isTermsEnabled = <?php echo e((isset($info->ssl_terms_active) && $info->ssl_terms_active == 1) ? 'true' : 'false'); ?>;

fetch('https://api.ipify.org?format=json').then(r => r.json()).then(data => { const el = document.getElementById('ip_address'); if(el) el.value = data.ip; }).catch(console.error);

// ✅ UPDATED: Payment Method Toggle Logic (Global Function)
window.togglePaymentAction = function(method) {
    var form = document.getElementById('checkout_form');
    var btn = $('#chk_btn');
    var mobileInput = $('#mobile').val();
    var termsArea = $('#terms_checkbox_area'); // Added for Terms

    if(method === 'online') {
        form.action = "<?php echo e(url('/pay')); ?>"; // Force Action Change
        btn.text('Pay Now (bKash/Nagad)');
        btn.removeClass('is-disabled').removeAttr('disabled');
        if(typeof isTermsEnabled !== 'undefined' && isTermsEnabled) termsArea.slideDown(); // Show Terms
    } else {
        form.action = "<?php echo e(route('front.checkouts.store')); ?>";
        btn.text("<?php echo e($bangla_text->order_confirm_text); ?>");
        if(typeof isTermsEnabled !== 'undefined' && isTermsEnabled) termsArea.slideUp(); // Hide Terms
    }
};

// Coupon Function
function applyCoupon() {
    var code = $('#coupon_code').val();
    var btn = $('#coupon_btn');
    var msg = $('#coupon_message');
    if(!code) { msg.text('Please enter a coupon code').css('color', 'red'); return; }
    btn.prop('disabled', true).text('Checking...');
    msg.text('');
    $.ajax({
        url: "<?php echo e(route('front.getCouponDiscount')); ?>", method: "GET", data: { code: code },
        success: function(response) {
            if(response.success) {
                msg.text(response.msg).css('color', 'green');
                setTimeout(function(){ location.reload(); }, 1000);
            } else {
                msg.text(response.msg).css('color', 'red');
                btn.prop('disabled', false).text('Apply');
            }
        },
        error: function() { msg.text('Error!').css('color', 'red'); btn.prop('disabled', false).text('Apply'); }
    });
}

// Calculate Total
function calculate_total() {
    var subtotal = parseFloat($('#subtotal').val() || 0);
    var discount = <?php echo e(session('coupon_discount') ? session('coupon_discount') : 0); ?>;
    var shipping_charge = 0;
    var selected_shipping = $('input[name="delivery_charge_id_radio"]:checked');
    if (selected_shipping.length > 0) {
        shipping_charge = parseFloat(selected_shipping.data('charge'));
    } else {
        var selectVal = $('#selectCourier').find(':selected');
        if(selectVal.length > 0){ shipping_charge = parseFloat(selectVal.data('charge')); }
    }
    $('#d_charge').text('৳' + shipping_charge.toFixed(0));
    $('.delivery_charge').text('৳' + shipping_charge.toFixed(0));
    var total = subtotal + shipping_charge - discount;
    if(total < 0) total = 0;
    $('.total').text('৳' + total.toFixed(0));
    $('input[name="final_amount"]').val(total);
    $('#ssl_amount').val(total);
}

// Delete Cart
function deleteCartItem(url) {
    if(confirm('Delete this item?')) {
        $.ajax({
            url: url, type: 'POST', data: { _token: '<?php echo e(csrf_token()); ?>', _method: 'DELETE' },
            success: function(res) { window.location.reload(); },
            error: function() { alert('Error!'); }
        });
    }
}

$(document).ready(function(){
  $(document).on('change', 'input[name="delivery_charge_id_radio"]', function(){
      var val = $(this).val(); $('#selectCourier').val(val).trigger('change'); calculate_total();
  });
  var $radios = $('input[name="delivery_charge_id_radio"]');
  if($radios.length && !$radios.filter(':checked').length){ $radios.first().prop('checked', true).trigger('change'); }
  calculate_total();
    
  // Initialize Payment State
  var selectedPayment = $('input[name="payment_method"]:checked').val();
  if(selectedPayment){ togglePaymentAction(selectedPayment); }
});

// ============================================
// ✅✅✅ INCOMPLETE ORDER AUTO SAVE ✅✅✅
// ============================================

// টাইমার ভেরিয়েবল
var autoSaveTimer;

function saveIncompleteData() {
    var mobile = $('#mobile').val();
      
    // মোবাইল নাম্বার অন্তত ১১ ডিজিট হলেই সেভ করার চেষ্টা করবে
    if (mobile && mobile.length >= 11) {
        var formData = $('#checkout_form').serialize();

        $.ajax({
            url: "<?php echo e(route('incompleteStore')); ?>", // ✅ Correct Route Name from web.php
            type: "POST",
            data: formData,
            success: function(response) {
                if(response.success) {
                    console.log('Auto Save Success: Incomplete Order Stored');
                }
            },
            error: function(err) {
                console.log('Auto Save Failed');
            }
        });
    }
}

// ১. যখন ইউজার মোবাইল বা নাম টাইপ করা শেষ করবে (Keyup with delay)
$(document).on('keyup', '#mobile', function() {
    clearTimeout(autoSaveTimer);
    autoSaveTimer = setTimeout(saveIncompleteData, 2000); // ২ সেকেন্ড পর সেভ হবে
});

// ২. যখন ইউজার ইনপুট ফিল্ড থেকে বের হবে (Blur)
$(document).on('blur', '#mobile, #name, #address', function() {
    saveIncompleteData();
});

// ============================================
// ✅✅✅ CORE FORM SUBMISSION LOGIC
// ============================================

var isOtpVerified = false;
var otpSystemEnabled = <?php echo e($info->otp_system ?? 0); ?>;
var timerInterval;
var isSendingOtp = false;

function startTimer(duration, display) {
    var timer = duration, seconds;
    clearInterval(timerInterval);
    $('#resendOtpBtn').prop('disabled', true).addClass('text-muted').removeClass('text-primary');
    timerInterval = setInterval(function () {
        seconds = parseInt(timer % 60, 10);
        seconds = seconds < 10 ? "0" + seconds : seconds;
        display.html("Wait (" + seconds + "s)");
        if (--timer < 0) {
            clearInterval(timerInterval);
            display.html("Resend Code");
            $('#resendOtpBtn').prop('disabled', false).removeClass('text-muted').addClass('text-primary');
        }
    }, 1000);
}

function submitOrderFinal() {
    var form = document.getElementById('checkout_form');
    var $form = $(form);
    var btn = $('#chk_btn');
      
    var paymentMethod = $('input[name="payment_method"]:checked').val();
      
    if(paymentMethod === 'online') {
        form.action = "<?php echo e(url('/pay')); ?>"; 
        form.submit(); 
        return;
    }

    // Normal Ajax Submit for COD
    btn.addClass('is-disabled').attr('disabled', 'disabled').text('Processing...');

    $.ajax({
        type: 'POST',
        url: "<?php echo e(route('front.checkouts.store')); ?>", 
        data: $form.serialize(),
        success: function(res){
            if(res.success){
                if(res.url) window.location.href = res.url; else location.reload();
            } else {
                if(typeof toastr !== 'undefined') toastr.error(res.msg);
                btn.removeClass('is-disabled').removeAttr('disabled').text("<?php echo e($bangla_text->order_confirm_text); ?>");
            }
        },
        error: function(err){
            btn.removeClass('is-disabled').removeAttr('disabled').text("<?php echo e($bangla_text->order_confirm_text); ?>");
            if(typeof toastr !== 'undefined') toastr.error('Network Error');
        }
    });
}

function sendOtpBeforeSubmit() {
    if(isSendingOtp) return;
    var mobile = $('#mobile').val();
    if(mobile.length !== 11) { alert('Invalid Mobile Number'); return; }
      
    isSendingOtp = true;
    $('#chk_btn').addClass('is-disabled').text('Sending OTP...');
      
    $.ajax({
        url: "<?php echo e(route('sendOtp')); ?>", type: "POST", data: { mobile: mobile, _token: "<?php echo e(csrf_token()); ?>" },
        success: function(res) {
            isSendingOtp = false;
            $('#chk_btn').removeClass('is-disabled').text("<?php echo e($bangla_text->order_confirm_text); ?>");
            if(res.success) {
                $('#otp_sent_number').text(mobile);
                
                // ✅ FIXED: Append modal to body to prevent Bootstrap backdrop overlay issue
                $('#otpModal').appendTo('body'); 
                
                var myModal = new bootstrap.Modal(document.getElementById('otpModal'));
                myModal.show();
                
                // ✅ অটোমেটিক ইনপুট বক্সে ফোকাস দেওয়ার জন্য
                setTimeout(function() {
                    $('#otp_input').focus();
                }, 500);
                
                startTimer(30, $('#resendOtpBtn'));
            } else { alert(res.msg); }
        },
        error: function() { isSendingOtp = false; $('#chk_btn').removeClass('is-disabled').text("Submit"); }
    });
}

function verifyOtpNow() {
    var code = $('#otp_input').val();
    var mobile = $('#mobile').val();
    $.ajax({
        url: "<?php echo e(route('verifyOtp')); ?>", type: "POST", data: { otp: code, mobile: mobile, _token: "<?php echo e(csrf_token()); ?>" },
        success: function(res) {
            if(res.success) {
                isOtpVerified = true;
                bootstrap.Modal.getInstance(document.getElementById('otpModal')).hide();
                submitOrderFinal(); 
            } else { $('#otp_error').text(res.msg); }
        }
    });
}

(function(){
  document.addEventListener('DOMContentLoaded', function(){
    const form = document.getElementById('checkout_form');
    if(!form) return;
      
    form.addEventListener('submit', function(e){
      e.preventDefault(); 
      e.stopImmediatePropagation(); 

      var paymentMethod = $('input[name="payment_method"]:checked').val();
       
      // ✅ NEW: Terms & Conditions Validation (Fires before OTP/Submit logic)
      if(paymentMethod === 'online' && typeof isTermsEnabled !== 'undefined' && isTermsEnabled) {
          if(!$('#agree_terms').is(':checked')) {
              $('#terms_error').removeClass('d-none'); // Show Error Message
              return; // Stop form submission
          } else {
              $('#terms_error').addClass('d-none'); // Hide Error Message
          }
      }

      if(paymentMethod === 'online' && !otpSystemEnabled) {
          form.action = "<?php echo e(url('/pay')); ?>";
          form.submit();
          return;
      }

      var mobile = $('#mobile').val();
      var address = $('#address').val();
      var name = $('#name').val();
      if(!name){ alert('নাম লিখুন'); return; }
      if(!mobile || mobile.length !== 11){ alert('সঠিক মোবাইল নাম্বার দিন'); return; }
      if(!address){ alert('ঠিকানা দিন'); return; }

      if(otpSystemEnabled == 1 && !isOtpVerified) {
          sendOtpBeforeSubmit();
      } else {
          submitOrderFinal();
      }
    });
  });
})();

// ✅✅✅ FIXED: INITIATE CHECKOUT TRACKING (FIRES ONLY ONCE) ✅✅✅
$(document).ready(function(){
    // Check if event already fired
    if (window.hasFiredInitiateCheckout) return;
    window.hasFiredInitiateCheckout = true;

    var items = [];
    $('.cart-item-data').each(function() {
        items.push({
            id: $(this).data('product-id'),
            quantity: $(this).data('quantity'),
            price: $(this).data('price')
        });
    });

    var total = parseFloat($('input[name="total_cart_price"]').val() || 0);

    // Fire Pixel
    if (typeof fbq === 'function') {
        fbq('track', 'InitiateCheckout', {
            value: total,
            currency: 'BDT',
            content_ids: items.map(i => i.id),
            content_type: 'product',
            num_items: items.length
        });
    }
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('frontend.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/deshitest/public_html/resources/views/frontend/cart/checkout.blade.php ENDPATH**/ ?>