

<?php
    use App\Models\Information;
    use App\Models\AdminText;

    // ✅ Invoice type (for active highlight)
    $info_nav = Information::orderBy('id','desc')->first();
    $invoiceType = (int)($info_nav->invoice_type ?? 1);

    // Helper for dynamic label
    if (!function_exists('adm_text')) {
        function adm_text($key, $fallback='') {
            try{
                $t = \App\Models\AdminText::first();
                if($t && isset($t->$key) && $t->$key) return $t->$key;
            }catch(\Throwable $e){}
            return $fallback;
        }
    }

    // Order status icon map
    if (!function_exists('order_status_icon')) {
        function order_status_icon($label){
            $label = strtolower(trim((string)$label));
            if (str_contains($label, 'courier complete')) return 'uil uil-check-circle';
            if (str_contains($label, 'courier'))          return 'uil uil-truck';
            if (str_contains($label, 'all'))              return 'uil uil-receipt';
            if (str_contains($label, 'pending'))          return 'uil uil-clock';
            if (str_contains($label, 'processing'))       return 'uil uil-sync';
            if (str_contains($label, 'on hold'))          return 'uil uil-pause-circle';
            if (str_contains($label, 'incomplete'))       return 'uil uil-exclamation-circle';
            if (str_contains($label, 'complete'))         return 'uil uil-check';
            if (str_contains($label, 'cancel'))           return 'uil uil-times-circle';
            if (str_contains($label, 'return') || str_contains($label, 'returned') || str_contains($label, 'refund')) {
                return 'uil uil-corner-up-left';
            }
            return 'uil uil-shopping-bag';
        }
    }

    // Role flag
    $isWorker = auth()->check() && method_exists(auth()->user(), 'hasRole')
        ? auth()->user()->hasRole('worker')
        : false;

    // Active route helper
    if (!function_exists('nav_active')) {
        function nav_active($patterns = []) {
            foreach ((array)$patterns as $p) {
                if (request()->routeIs($p) || request()->is($p)) return 'active';
            }
            return '';
        }
    }
?>


<link rel="stylesheet" href="https://unicons.iconscout.com/release/v4.0.8/css/line.css">

<aside id="appSidebar" class="premium-sidebar">
    
    
    <div class="sidebar-header"></div>

    
    <div class="sidebar-content" data-simplebar>
        
        
        <ul class="sidebar-menu">

            
            <li class="menu-item">
                <a href="<?php echo e(route('admin.dashboard')); ?>" class="menu-link <?php echo e(nav_active(['admin.dashboard'])); ?>">
                    <i class="menu-icon uil uil-tachometer-fast"></i>
                    <span class="menu-text"><?php echo e(adm_text('dashboard','Dashboard')); ?></span>
                </a>
            </li>

            
            <?php $ordersOpen = request()->is('admin/orders*') ? 'show' : ''; ?>
            <?php if($isWorker || auth()->user()->can('order.view') || auth()->user()->can('permission.view')): ?>
            <li class="menu-item">
                <button class="menu-link has-dropdown <?php echo e($ordersOpen ? '' : 'collapsed'); ?>" type="button" 
                        data-bs-toggle="collapse" data-bs-target="#menuOrders" 
                        aria-expanded="<?php echo e($ordersOpen ? 'true':'false'); ?>">
                    <i class="menu-icon uil uil-folder-plus"></i>
                    <span class="menu-text"><?php echo e(adm_text('orders_manage','Orders Manage')); ?></span>
                    <i class="uil uil-angle-right menu-arrow"></i>
                </button>

                <div class="collapse menu-dropdown <?php echo e($ordersOpen); ?>" id="menuOrders">
                    <ul class="sub-menu">
                        <?php if($isWorker || auth()->user()->can('order.view')): ?>
                            <?php $__currentLoopData = getOrderStatus(1); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <a href="<?php echo e(url('admin/orders?q=&status='.$key)); ?>" 
                                   class="sub-link <?php echo e(request('status')===(string)$key ? 'active' : ''); ?>">
                                    <i class="<?php echo e(order_status_icon($item)); ?>"></i>
                                    <span><?php echo e($item); ?></span>
                                </a>
                            </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </ul>
                </div>
            </li>
            <?php endif; ?>

            
            <?php if(auth()->user()->can('product.view') || auth()->user()->can('type.view') || auth()->user()->can('category.view') || auth()->user()->can('discount.view')): ?>
            <?php
                $productsOpen = request()->is('admin/types*') || request()->is('admin/categories*') || request()->is('admin/products*') || request()->is('admin/free-shipping*') ? 'show' : '';
            ?>
            <li class="menu-item">
                <button class="menu-link has-dropdown <?php echo e($productsOpen ? '' : 'collapsed'); ?>" type="button" 
                        data-bs-toggle="collapse" data-bs-target="#menuProducts" 
                        aria-expanded="<?php echo e($productsOpen ? 'true':'false'); ?>">
                    <i class="menu-icon uil uil-box"></i>
                    <span class="menu-text"><?php echo e(adm_text('products','Products')); ?></span>
                    <i class="uil uil-angle-right menu-arrow"></i>
                </button>
                <div class="collapse menu-dropdown <?php echo e($productsOpen); ?>" id="menuProducts">
                    <ul class="sub-menu">
                        <?php if(auth()->user()->can('type.view')): ?>
                        <li><a href="<?php echo e(route('admin.types.index')); ?>" class="sub-link <?php echo e(nav_active(['admin.types.*'])); ?>"><i class="uil uil-bright"></i><span><?php echo e(adm_text('brand_manage','Brand Manage')); ?></span></a></li>
                        <?php endif; ?>
                        <?php if(auth()->user()->can('category.view')): ?>
                        <li><a href="<?php echo e(route('admin.categories.index')); ?>" class="sub-link <?php echo e(nav_active(['admin.categories.*'])); ?>"><i class="uil uil-books"></i><span><?php echo e(adm_text('category_manage','Category Manage')); ?></span></a></li>
                        <?php endif; ?>
                        <?php if(auth()->user()->can('product.view')): ?>
                        <li><a href="<?php echo e(route('admin.products.index')); ?>" class="sub-link <?php echo e(nav_active(['admin.products.*'])); ?>"><i class="uil uil-box"></i><span><?php echo e(adm_text('products_manage','Products Manage')); ?></span></a></li>
                        <?php endif; ?>
                    </ul>
                </div>
            </li>
            <?php endif; ?>

            
            <?php if(auth()->user()->can('size.view') || auth()->user()->can('color.view')): ?>
            <?php $variationOpen = request()->is('admin/sizes*') || request()->is('admin/colors*') ? 'show' : ''; ?>
            <li class="menu-item">
                <button class="menu-link has-dropdown <?php echo e($variationOpen ? '' : 'collapsed'); ?>" type="button" 
                        data-bs-toggle="collapse" data-bs-target="#menuVariation" 
                        aria-expanded="<?php echo e($variationOpen ? 'true':'false'); ?>">
                    <i class="menu-icon uil uil-layer-group"></i>
                    <span class="menu-text"><?php echo e(adm_text('variation','Variation')); ?></span>
                    <i class="uil uil-angle-right menu-arrow"></i>
                </button>
                <div class="collapse menu-dropdown <?php echo e($variationOpen); ?>" id="menuVariation">
                    <ul class="sub-menu">
                        <?php if(auth()->user()->can('size.view')): ?>
                        <li><a href="<?php echo e(route('admin.sizes.index')); ?>" class="sub-link <?php echo e(nav_active(['admin.sizes.*'])); ?>"><i class="uil uil-ruler"></i><span><?php echo e(adm_text('size_manage','Size Manage')); ?></span></a></li>
                        <?php endif; ?>
                        <?php if(auth()->user()->can('color.view')): ?>
                        <li><a href="<?php echo e(route('admin.colors.index')); ?>" class="sub-link <?php echo e(nav_active(['admin.colors.*'])); ?>"><i class="uil uil-palette"></i><span><?php echo e(adm_text('color_manage','Color Manage')); ?></span></a></li>
                        <?php endif; ?>
                    </ul>
                </div>
            </li>
            <?php endif; ?>

            
            <?php if(auth()->user()->can('product.view')): ?>
            <li class="menu-item">
                <a href="<?php echo e(route('admin.stock_warning')); ?>" class="menu-link <?php echo e(nav_active(['admin.stock_warning'])); ?>">
                    <i class="menu-icon uil uil-exclamation-triangle"></i>
                    <span class="menu-text"><?php echo e(adm_text('stock_warning','Stock Warning')); ?></span>
                </a>
            </li>
            <?php endif; ?>

            
            <li class="menu-item">
                <a href="<?php echo e(route('admin.homecat')); ?>" class="menu-link <?php echo e(nav_active(['admin.homecat'])); ?>">
                    <i class="menu-icon uil uil-home"></i>
                    <span class="menu-text"><?php echo e(adm_text('home_category','Home Category')); ?></span>
                </a>
            </li>

            
            <li class="menu-item">
                <a href="<?php echo e(route('admin.free_shipping')); ?>" class="menu-link <?php echo e(nav_active(['admin.free_shipping'])); ?>">
                    <i class="menu-icon uil uil-truck"></i>
                    <span class="menu-text"><?php echo e(adm_text('free_shipping','Free Shipping')); ?></span>
                </a>
            </li>

            
            <?php if(auth()->user()->can('discount.view') || auth()->user()->can('product.view')): ?>
            <li class="menu-item">
                <a href="<?php echo e(route('admin.coupon_codes.index')); ?>" class="menu-link <?php echo e(nav_active(['admin.coupon_codes.*'])); ?>">
                    <i class="menu-icon uil uil-ticket"></i>
                    <span class="menu-text"><?php echo e(adm_text('coupon_code','Coupon Code')); ?></span>
                </a>
            </li>
            <?php endif; ?>

            
            <?php if (! ($isWorker)): ?>
            <li class="menu-item">
                <a href="<?php echo e(route('admin.reviews.index')); ?>" class="menu-link <?php echo e(nav_active(['admin.reviews.*'])); ?>">
                    <i class="menu-icon uil uil-comment-alt-dots"></i>
                    <span class="menu-text"><?php echo e(adm_text('reviews','Reviews')); ?></span>
                </a>
            </li>
            <?php endif; ?>

            
            <?php if(auth()->user()->can('page.view') || auth()->user()->can('image.view') || auth()->user()->can('slider.view')): ?>
            <?php 
                $frontOpen = request()->is('admin/pages*') || request()->is('admin/sliders*') || request()->is('admin/styles*') || request()->is('admin/dynamic-text*') ? 'show' : ''; 
            ?>
            <li class="menu-item">
                <button class="menu-link has-dropdown <?php echo e($frontOpen ? '' : 'collapsed'); ?>" type="button" 
                        data-bs-toggle="collapse" data-bs-target="#menuFront" 
                        aria-expanded="<?php echo e($frontOpen ? 'true':'false'); ?>">
                    <i class="menu-icon uil uil-monitor"></i>
                    <span class="menu-text"><?php echo e(adm_text('front_page','Front Page')); ?></span>
                    <i class="uil uil-angle-right menu-arrow"></i>
                </button>
                <div class="collapse menu-dropdown <?php echo e($frontOpen); ?>" id="menuFront">
                    <ul class="sub-menu">
                        <?php if(auth()->user()->can('page.view')): ?>
                        <li><a href="<?php echo e(route('admin.pages.index')); ?>" class="sub-link <?php echo e(nav_active(['admin.pages.*'])); ?>"><i class="uil uil-notes"></i><span><?php echo e(adm_text('manage_page_data','Manage Page Data')); ?></span></a></li>
                        <?php endif; ?>
                        <li><a href="<?php echo e(route('admin.styles.index')); ?>" class="sub-link <?php echo e(nav_active(['admin.styles.*'])); ?>"><i class="uil uil-palette"></i><span><?php echo e(adm_text('style','Style')); ?></span></a></li>
                        <?php if(auth()->user()->can('slider.view')): ?>
                        <li><a href="<?php echo e(route('admin.sliders.index')); ?>" class="sub-link <?php echo e(nav_active(['admin.sliders.*'])); ?>"><i class="uil uil-sliders-v"></i><span><?php echo e(adm_text('slider_manage','Slider Manage')); ?></span></a></li>
                        <?php endif; ?>
                        <li><a href="<?php echo e(route('admin.dynamic_text.edit')); ?>" class="sub-link <?php echo e(nav_active(['admin.dynamic_text.*'])); ?>"><i class="uil uil-edit"></i><span><?php echo e(adm_text('dynamic_text','Dynamic Text')); ?></span></a></li>
                    </ul>
                </div>
            </li>
            <?php endif; ?>

            
            <?php if(auth()->user()->can('delivery_charge.view')): ?>
            <li class="menu-item">
                <a href="<?php echo e(route('admin.delivery_charge.index')); ?>" class="menu-link <?php echo e(nav_active(['admin.delivery_charge.*'])); ?>">
                    <i class="menu-icon uil uil-bill"></i>
                    <span class="menu-text"><?php echo e(adm_text('delivery_charge','Delivery Charge')); ?></span>
                </a>
            </li>
            <?php endif; ?>
            <?php if(auth()->user()->can('couriers.view')): ?>
            <li class="menu-item">
                <a href="<?php echo e(route('admin.couriers.index')); ?>" class="menu-link <?php echo e(nav_active(['admin.couriers.*'])); ?>">
                    <i class="menu-icon uil uil-truck-loading"></i>
                    <span class="menu-text"><?php echo e(adm_text('courier_manage','Courier Manage')); ?></span>
                </a>
            </li>
            <?php endif; ?>

            
            <?php if(auth()->user()->can('combo.view') || auth()->user()->can('permission.view') || auth()->user()->can('role.view')): ?>
            <?php $usersOpen = request()->is('admin/users*') ? 'show' : ''; ?>
            <li class="menu-item">
                <button class="menu-link has-dropdown <?php echo e($usersOpen ? '' : 'collapsed'); ?>" type="button" 
                        data-bs-toggle="collapse" data-bs-target="#menuUsers" 
                        aria-expanded="<?php echo e($usersOpen ? 'true':'false'); ?>">
                    <i class="menu-icon uil uil-users-alt"></i>
                    <span class="menu-text"><?php echo e(adm_text('users','Users')); ?></span>
                    <i class="uil uil-angle-right menu-arrow"></i>
                </button>
                <div class="collapse menu-dropdown <?php echo e($usersOpen); ?>" id="menuUsers">
                    <ul class="sub-menu">
                        <?php if(auth()->user()->can('user.view')): ?>
                        <li><a href="<?php echo e(route('admin.users.index')); ?>" class="sub-link <?php echo e(nav_active(['admin.users.*'])); ?>"><i class="uil uil-user"></i><span><?php echo e(adm_text('manage_user','Manage User')); ?></span></a></li>
                        <?php endif; ?>
                    </ul>
                </div>
            </li>
            <?php endif; ?>

            
            <?php if(auth()->user()->can('combo.view') || auth()->user()->can('permission.view') || auth()->user()->can('role.view')): ?>
            
            <?php 
                $landingOpen = request()->routeIs('admin.landing_pages*') || request()->is('facebook-feed*') ? 'show' : ''; 
            ?>
            
            <li class="menu-item">
                <button class="menu-link has-dropdown <?php echo e($landingOpen ? '' : 'collapsed'); ?>" type="button" 
                        data-bs-toggle="collapse" data-bs-target="#menuLanding" 
                        aria-expanded="<?php echo e($landingOpen ? 'true':'false'); ?>">
                    <i class="menu-icon uil uil-apps"></i>
                    <span class="menu-text"><?php echo e(adm_text('landing_page','Landing Page')); ?></span>
                    <i class="uil uil-angle-right menu-arrow"></i>
                </button>
                <div class="collapse menu-dropdown <?php echo e($landingOpen); ?>" id="menuLanding">
                    <ul class="sub-menu">
                        <li>
                            <a href="<?php echo e(route('admin.landing_pages_five')); ?>" class="sub-link <?php echo e(nav_active(['admin.landing_pages_five*'])); ?>">
                                <i class="uil uil-star"></i>
                                <span>Design 1</span>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('admin.landing_pages_two')); ?>" class="sub-link <?php echo e(nav_active(['admin.landing_pages_two*'])); ?>">
                                <i class="uil uil-edit"></i>
                                <span>Design 2</span>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('admin.landing_pages_three')); ?>" class="sub-link <?php echo e(nav_active(['admin.landing_pages_three*'])); ?>">
                                <i class="uil uil-diamond"></i>
                                <span>Design 3</span>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('admin.landing_pages_four')); ?>" class="sub-link <?php echo e(nav_active(['admin.landing_pages_four*'])); ?>">
                                <i class="uil uil-moon"></i>
                                <span>Design 4</span>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('admin.landing_pages.color')); ?>" class="sub-link <?php echo e(nav_active(['admin.landing_pages.color'])); ?>">
                                <i class="uil uil-palette"></i>
                                <span>Color Settings</span>
                            </a>
                        </li>
                    </ul>
                </div>
            </li>

            <li class="menu-item">
                <a href="<?php echo e(url('/facebook-feed')); ?>" class="menu-link <?php echo e(request()->is('facebook-feed*') ? 'active' : ''); ?>">
                    <i class="menu-icon uil uil-facebook-f"></i>
                    <span class="menu-text"><?php echo e(adm_text('fb_data_feed','FB Data Feed')); ?></span>
                </a>
            </li>
            <?php endif; ?>

            
            <li class="menu-header">Analytics & Settings</li>

            
            <?php if($isWorker || auth()->user()->can('order.view') || auth()->user()->can('permission.view')): ?>
            <li class="menu-item">
                <a href="<?php echo e(route('admin.report.sales')); ?>" class="menu-link <?php echo e(nav_active(['admin.report.sales'])); ?>">
                    <i class="menu-icon uil uil-chart-growth"></i>
                    <span class="menu-text"><?php echo e(adm_text('sales_report','Sales Report')); ?></span>
                </a>
            </li>
            <?php endif; ?>

            
            <?php $reportsOpen = request()->is('admin/report/*') ? 'show' : ''; ?>
            <?php if($isWorker || auth()->user()->can('order.view') || auth()->user()->can('permission.view')): ?>
            <li class="menu-item">
                <button class="menu-link has-dropdown <?php echo e($reportsOpen ? '' : 'collapsed'); ?>" type="button" 
                        data-bs-toggle="collapse" data-bs-target="#menuReports" 
                        aria-expanded="<?php echo e($reportsOpen ? 'true':'false'); ?>">
                    <i class="menu-icon uil uil-chart-line"></i>
                    <span class="menu-text"><?php echo e(adm_text('reports','Reports')); ?></span>
                    <i class="uil uil-angle-right menu-arrow"></i>
                </button>
                <div class="collapse menu-dropdown <?php echo e($reportsOpen); ?>" id="menuReports">
                    <ul class="sub-menu">
                        <?php if($isWorker): ?>
                            <li><a href="<?php echo e(route('admin.report.user')); ?>" class="sub-link <?php echo e(nav_active(['admin.report.user'])); ?>"><i class="uil uil-user-check"></i><span><?php echo e(adm_text('user_report','User Report')); ?></span></a></li>
                        <?php else: ?>
                            <?php if(auth()->user()->can('user.view')): ?>
                            <li><a href="<?php echo e(route('admin.report.order')); ?>" class="sub-link <?php echo e(nav_active(['admin.report.order'])); ?>"><i class="uil uil-clipboard-notes"></i><span><?php echo e(adm_text('order_report','Order Report')); ?></span></a></li>
                            <li><a href="<?php echo e(route('admin.report.user')); ?>" class="sub-link <?php echo e(nav_active(['admin.report.user'])); ?>"><i class="uil uil-user-check"></i><span><?php echo e(adm_text('user_report','User Report')); ?></span></a></li>
                            <?php endif; ?>
                        <?php endif; ?>
                    </ul>
                </div>
            </li>
            <?php endif; ?>

            
            <li class="menu-item">
                <a href="<?php echo e(route('admin.invoice_design.index')); ?>" class="menu-link <?php echo e(request()->routeIs('admin.invoice_design.index') ? 'active' : ''); ?>">
                    <i class="menu-icon uil uil-print"></i>
                    <span class="menu-text">Invoice Design</span>
                </a>
            </li>

            
            <?php if(!$isWorker && auth()->user()->can('user.view')): ?>
                
                
                <li class="menu-item">
                    <a href="<?php echo e(route('admin.expenses.index')); ?>" class="menu-link <?php echo e(nav_active(['admin.expenses.*'])); ?>">
                        <i class="menu-icon uil uil-money-withdrawal"></i>
                        <span class="menu-text"><?php echo e(adm_text('expense','Expense')); ?></span>
                    </a>
                </li>

                
                <li class="menu-item">
                    <a href="<?php echo e(route('admin.ipblock')); ?>" class="menu-link <?php echo e(nav_active(['admin.ipblock'])); ?>">
                        <i class="menu-icon uil uil-shield-slash"></i>
                        <span class="menu-text"><?php echo e(adm_text('block_ip','Block Ip')); ?></span>
                    </a>
                </li>

            <?php endif; ?>

            
            <?php if(auth()->user()->can('product.delete')): ?>
            <li class="menu-item">
                <a href="<?php echo e(route('admin.settings.index')); ?>" class="menu-link <?php echo e(nav_active(['admin.settings.*'])); ?>">
                    <i class="menu-icon uil uil-cog"></i>
                    <span class="menu-text"><?php echo e(adm_text('settings_manage','Settings Manage')); ?></span>
                </a>
            </li>
            <?php endif; ?>

        </ul>
        
        
        <div class="sidebar-footer">
            <p><?php echo e(date('Y')); ?> &copy; BIZ CARE LTD. V-2.1</p>
            
        </div>

    </div>
</aside>

<style>
/* ======================================
   PREMIUM SIDEBAR DESIGN (Slate/Indigo)
   ======================================
*/
:root {
    --nav-w: 250px; 
    --nav-bg: #0f172a;             /* Deep Slate Background */
    --nav-item-color: #94a3b8;    /* Muted Text */
    --nav-item-hover: #f1f5f9;    /* White Text on hover */
    --nav-active-bg: rgba(99, 102, 241, 0.12); /* Indigo Glass */
    --nav-active-border: rgba(99, 102, 241, 0.4); 
    --nav-accent: #818cf8;        /* Indigo Light */
    --nav-header-h: 80px;         /* Header Spacer Height */
}

/* Base Reset */
.premium-sidebar {
    width: var(--nav-w);
    height: 100vh;
    position: fixed;
    top: 0; left: 0;
    background: var(--nav-bg);
    z-index: 1040;
    display: flex;
    flex-direction: column;
    border-right: 1px solid rgba(255,255,255,0.05);
    transition: all 0.3s ease;
}

/* Force body padding when sidebar exists (Desktop) */
@media (min-width: 992px) {
    body.with-sidebar { padding-left: var(--nav-w); }
}

/* Mobile View */
@media (max-width: 991.98px) {
    .premium-sidebar {
        position: relative;
        width: 100%;
        height: auto;
        border-right: none;
    }
    body.with-sidebar { padding-left: 0 !important; }
    
    /* ===== FIX: Remove Gap on Mobile ===== */
    .sidebar-header {
        display: none !important;
    }
}

/* ===== HEADER SPACER (PRESERVES GAP) ===== */
.sidebar-header {
    min-height: var(--nav-header-h); /* 80px */
    width: 100%;
    /* No content, just space */
}

/* ===== SCROLL AREA ===== */
.sidebar-content {
    flex: 1;
    overflow-y: auto;
    overflow-x: hidden;
    padding: 10px 12px 20px 12px;
    display: flex;
    flex-direction: column;
    
    /* Hide Scrollbar */
    scrollbar-width: none; 
    -ms-overflow-style: none;
}
.sidebar-content::-webkit-scrollbar { 
    display: none; 
    width: 0;
}

/* ===== MENU LIST ===== */
.sidebar-menu {
    list-style: none;
    padding: 0; margin: 0;
    display: flex;
    flex-direction: column;
    gap: 6px; /* Spacing between items */
    flex-grow: 1; /* Push footer down if menu is short */
}

.menu-header {
    font-size: 11px;
    text-transform: uppercase;
    letter-spacing: 1px;
    color: #475569;
    font-weight: 700;
    margin: 20px 0 8px 12px;
}

/* ===== MENU LINKS ===== */
.menu-link {
    display: flex;
    align-items: center;
    padding: 13px 16px; /* slightly taller */
    color: var(--nav-item-color);
    text-decoration: none;
    border-radius: 8px;
    transition: all 0.25s cubic-bezier(0.4, 0, 0.2, 1);
    background: transparent;
    border: 1px solid transparent;
    width: 100%;
    cursor: pointer;
    font-size: 16px;
    font-weight: 500;
    outline: none !important;
}

/* Button reset */
button.menu-link {
    border: none;
    box-shadow: none;
    text-align: left;
}

.menu-link:hover {
    color: var(--nav-item-hover);
    background: rgba(255,255,255,0.03);
    transform: translateX(4px);
}

/* Active State */
.menu-link.active {
    background: var(--nav-active-bg);
    border-color: var(--nav-active-border);
    color: #fff;
    box-shadow: 0 4px 12px rgba(0,0,0,0.2);
}

.menu-icon {
    font-size: 22px; 
    margin-right: 14px;
    transition: color 0.2s;
    min-width: 24px;
    text-align: center;
}
.menu-link.active .menu-icon {
    color: var(--nav-accent);
}

.menu-text {
    flex: 1;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

/* Arrow Rotation */
.menu-arrow {
    font-size: 20px;
    color: #64748b;
    transition: transform 0.3s ease;
}
.menu-link[aria-expanded="true"] .menu-arrow {
    transform: rotate(90deg);
    color: #fff;
}

/* ===== SUBMENU ===== */
.sub-menu {
    list-style: none;
    padding: 4px 0 4px 0;
    margin: 0;
    position: relative;
}

.sub-link {
    display: flex;
    align-items: center;
    padding: 10px 12px 10px 50px; /* Indented */
    color: #64748b;
    font-size: 14.5px;
    text-decoration: none;
    transition: all 0.2s;
    border-radius: 6px;
    margin-bottom: 2px;
}

.sub-link:hover {
    color: #fff;
}

.sub-link.active {
    color: #fff;
    background: rgba(255,255,255,0.04);
}

.sub-link i {
    font-size: 18px;
    margin-right: 10px;
    color: inherit;
}
.sub-link.active i {
    color: var(--nav-accent);
}

/* ===== COPYRIGHT FOOTER ===== */
.sidebar-footer {
    margin-top: 30px;
    padding-top: 20px;
    border-top: 1px solid rgba(255,255,255,0.05);
    text-align: center;
    color: #64748b;
}
.sidebar-footer p {
    margin: 0;
    line-height: 1.5;
    font-size: 12px;
}
.sidebar-footer .small {
    font-size: 11px;
    opacity: 0.7;
}

/* ===== CLEANUP ===== */
.premium-sidebar .menu-link::after,
.premium-sidebar .menu-link:after,
.premium-sidebar .menu-arrow::before {
    display: none !important;
    content: none !important;
} 
</style><?php /**PATH /home/deshitest/public_html/resources/views/backend/partials/navbar.blade.php ENDPATH**/ ?>