
<?php $__env->startSection('content'); ?>

<style>
  th, td, h4, .cr_manage, .form-label {
    color: #111827 !important;
  }

  .card {
    border: none !important;
    border-radius: 12px !important;
    box-shadow: 0 2px 12px rgba(0,0,0,.08);
  }

  .page-title-box {
    display: flex;
    flex-wrap: wrap;
    justify-content: space-between;
    align-items: center;
  }

  .form-control, select, input[type="file"] {
    border-radius: 8px !important;
  }

  .table thead {
    background-color: #f1f5f9;
  }

  @media(max-width:768px){
    .card-header h4{
      font-size: 1.1rem;
    }
    .table thead{
      font-size: 14px;
    }
    .table td{
      font-size: 13px;
    }
  }
</style>

<div class="row gy-4">
  <div class="col-12">
    <div class="page-title-box mb-3">
      <div>
        <h4 class="page-title mb-0 fw-bold">Category Manage</h4>
        <small class="text-muted">Manage all product categories easily</small>
      </div>
      <ol class="breadcrumb m-0">
        <li class="breadcrumb-item"><a href="javascript:void(0);">SIS</a></li>
        <li class="breadcrumb-item"><a href="javascript:void(0);">CRM</a></li>
        <li class="breadcrumb-item active">Category Manage</li>
      </ol>
    </div>
  </div>

  <!-- Category Create -->
  <div class="col-lg-4 col-md-12">
    <div class="card border-0 shadow-sm h-100">
      <div class="card-header bg-light">
        <h5 class="mb-0 fw-semibold text-dark">➕ Create Category</h5>
      </div>
      <div class="card-body">
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('category.create')): ?>
        <form method="POST" action="<?php echo e(route('admin.categories.store')); ?>" id="ajax_form" enctype="multipart/form-data">
          <?php echo csrf_field(); ?>
          <div class="mb-3">
            <label class="form-label fw-medium">Category Name</label>
            <input type="text" name="name" class="form-control" placeholder="Enter Category Name" required>
          </div>

          <div class="mb-3">
            <label class="form-label fw-medium">Category Image</label>
            <input type="file" name="image" class="form-control">
          </div>

          <div class="mb-3">
            <label class="form-label fw-medium">Parent Category</label>
            <select class="form-select" name="parent_id">
              <option value="" hidden>Select Category...</option>
              <?php $__currentLoopData = $cats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($key); ?>"><?php echo e($cat); ?></option>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
          </div>

          <button type="submit" class="btn btn-primary w-100 py-2 rounded-3">
            <i class="mdi mdi-content-save-outline"></i> Save Category
          </button>
        </form>
        <?php endif; ?>
      </div>
    </div>
  </div>

  <!-- Category List -->
  <div class="col-lg-8 col-md-12">
    <div class="card border-0 shadow-sm">
      <div class="card-body">
        <div class="d-flex flex-wrap justify-content-between align-items-center mb-3 gap-2">
          <div class="d-flex flex-wrap gap-2">
            <a class="btn btn-sm btn-success popular_update" href="<?php echo e(route('admin.popularCatgeory')); ?>?is_popular=1">Activate Popular</a>
            <a class="btn btn-sm btn-outline-danger popular_update" href="<?php echo e(route('admin.popularCatgeory')); ?>?is_popular=0">Deactivate Popular</a>
            <a class="btn btn-sm btn-info popular_update" href="<?php echo e(route('admin.popularCatgeory')); ?>?is_menu=1">Activate Menu</a>
            <a class="btn btn-sm btn-outline-danger popular_update" href="<?php echo e(route('admin.popularCatgeory')); ?>?is_menu=0">Deactivate Menu</a>
          </div>
          <form class="d-flex gap-2" method="get">
            <input type="search" class="form-control form-control-sm" name="q" placeholder="Search..." value="<?php echo e($q??''); ?>">
            <button class="btn btn-primary btn-sm"><i class="mdi mdi-magnify"></i></button>
          </form>
        </div>

        <div class="table-responsive">
          <table class="table table-centered align-middle">
            <thead class="table-light">
              <tr>
                <th>
                  <div class="form-check">
                    <input type="checkbox" class="form-check-input check_all" id="check_all">
                    <label class="form-check-label" for="check_all">All</label>
                  </div>
                </th>
                <th>Name</th>
                <th>Parent</th>
                <th>Image</th>
                <th>Popular</th>
                <th>Menu</th>
                <th class="text-center">Action</th>
              </tr>
            </thead>
            <tbody>
              <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td><input type="checkbox" class="checkbox form-check-input" value="<?php echo e($item->id); ?>"></td>
                <td><?php echo e($item->name); ?></td>
                <td><?php echo e($item->parent? $item->parent->name : '-'); ?></td>
                <td><img src="<?php echo e(getImage('categories',$item->image)); ?>" width="60" class="rounded shadow-sm"></td>
                <td><span class="badge bg-<?php echo e($item->is_popular ? 'success' : 'secondary'); ?>"><?php echo e($item->is_popular ? 'Yes' : 'No'); ?></span></td>
                <td><span class="badge bg-<?php echo e($item->is_menu ? 'info' : 'secondary'); ?>"><?php echo e($item->is_menu ? 'Yes' : 'No'); ?></span></td>
                <td class="text-center">
                  <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('category.edit')): ?>
                    <a href="<?php echo e(route('admin.categories.edit',$item->id)); ?>" class="btn btn-sm btn-outline-primary btn_modal"><i class="mdi mdi-square-edit-outline"></i></a>
                  <?php endif; ?>
                  <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('category.delete')): ?>
                    <a href="<?php echo e(route('admin.categories.destroy',$item->id)); ?>" class="btn btn-sm btn-outline-danger delete"><i class="mdi mdi-delete"></i></a>
                  <?php endif; ?>
                </td>
              </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
          </table>
        </div>
        <div class="mt-3">
          <?php echo urldecode(str_replace("/?","?",$items->appends(Request::all())->render())); ?>

        </div>
      </div>
    </div>
  </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script>
$(function(){
  $(".check_all").on('change',function(){
    $(".checkbox").prop('checked',$(this).is(":checked"));
  });

  $('a.popular_update').on('click',function(e){
    e.preventDefault();
    const url = $(this).attr('href');
    const cat_ids = $('.checkbox:checked').map(function(){ return $(this).val(); }).get();

    if(cat_ids.length === 0){
      toastr.error('Please select at least one category!');
      return;
    }

    $.ajax({
      type:'GET',
      url:url,
      data:{cat_ids},
      success:function(res){
        if(res.status){
          toastr.success(res.msg);
          setTimeout(()=>location.reload(),1000);
        } else {
          toastr.error(res.msg);
        }
      }
    });
  });
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\php8212\htdocs\ecommerce\resources\views/backend/categories/index.blade.php ENDPATH**/ ?>