
<?php $__env->startSection('content'); ?>

<style>
  /* Print tweaks */
  @media print{
    nav, .no-print, .pagination{ display:none !important; }
    .card{ border:none !important; box-shadow:none !important; }
    .print-header{ display:block !important; margin-bottom:8px; }
    table tbody td{ font-size:12px !important; }
  }

  /* Sticky actions */
  .toolbar-sticky{
    position: sticky; top: 0; z-index: 6; background: #fff; padding: .5rem 0;
    border-bottom: 1px solid #f0f0f0;
  }

  /* Mobile responsive table */
  @media (max-width:576px){
    .table-responsive{ border:0; }
    table.table thead{ display:none; }
    table.table tbody tr{
      display:block; margin-bottom:10px; border:1px solid #eee; border-radius:10px; padding:10px;
    }
    table.table tbody td{
      display:flex; justify-content:space-between; gap:10px; border:0 !important; padding:.25rem 0 !important;
      font-size:13px !important;
    }
    table.table tbody td::before{
      content: attr(data-label);
      font-weight:600; color:#111;
    }
  }

  .text-truncate-2{
    display:-webkit-box; -webkit-line-clamp:2; -webkit-box-orient:vertical; overflow:hidden;
  }
  .nowrap{ white-space:nowrap; }
</style>

<div class="row">
  <div class="col-12">
    <div class="page-title-box">
      <div class="page-title-right">
        <ol class="breadcrumb m-0">
          <li class="breadcrumb-item"><a href="#">SIS</a></li>
          <li class="breadcrumb-item"><a href="#">CRM</a></li>
          <li class="breadcrumb-item active">Order report</li>
        </ol>
      </div>
      <h4 class="page-title">Order Report</h4>
    </div>
  </div>
</div>

<div class="row">
  <div class="col-12">
    <div class="card">
      <div class="card-body">

        
        <div class="print-header" style="display:none">
          <h5 class="mb-0">Order Report</h5>
          <small>
            <?php
              $fromTxt = request('from') ?: '—';
              $toTxt   = request('to') ?: '—';
            ?>
            Date Range: <?php echo e($fromTxt); ?> to <?php echo e($toTxt); ?>

          </small>
        </div>

        
        <div class="row mb-2 no-print">
          <div class="col-12 toolbar-sticky">
            <form class="row gy-2 gx-2 align-items-end" method="GET" action="<?php echo e(route('admin.report.order.search')); ?>">
              <div class="col-md-4">
                <label class="form-label">Search</label>
                <input type="search" class="form-control" name="query" placeholder="Search..." value="<?php echo e(request('query')); ?>">
              </div>

              <div class="col-md-4">
                <label class="form-label">Status</label>
                <select class="form-select" name="status">
                  <option value="">Status...</option>
                  <?php $__currentLoopData = getOrderStatus(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($key); ?>" <?php echo e((string)request('status')===(string)$key ? 'selected' : ''); ?>><?php echo e($value); ?></option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
              </div>

              <div class="col-md-4">
                <label class="form-label">Assign By</label>
                <select class="form-select" name="assign">
                  <option value="">Assign By...</option>
                  <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($user->id); ?>" <?php echo e((string)request('assign')===(string)$user->id ? 'selected':''); ?>>
                      <?php echo e(full_name($user)); ?>

                    </option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
              </div>

              <div class="col-md-4">
                <label class="form-label">From</label>
                <input type="date" name="from" class="form-control" value="<?php echo e(request('from')); ?>">
              </div>

              <div class="col-md-4">
                <label class="form-label">To</label>
                <input type="date" name="to" class="form-control" value="<?php echo e(request('to')); ?>">
              </div>

              <div class="col-md-4">
                <label class="form-label">Courier</label>
                <select class="form-select" name="courier">
                  <option value="">Choose...</option>
                  <?php $__currentLoopData = $couriers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $courier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($courier->id); ?>" <?php echo e((string)request('courier')===(string)$courier->id ? 'selected' : ''); ?>>
                      <?php echo e($courier->name); ?>

                    </option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
              </div>

              <div class="col-auto">
                <button type="submit" class="btn btn-sm btn-primary">Submit</button>
              </div>
              <div class="col-auto">
                <a href="<?php echo e(route('admin.report.order')); ?>" class="btn btn-sm btn-outline-secondary">Reset</a>
              </div>

              <div class="col-auto ms-auto">
                <a class="btn btn-dark btn-sm"
                   href="<?php echo e(route('admin.report.order.export', [
                        'query'=>request('query'),
                        'status'=>request('status'),
                        'assign'=>request('assign'),
                        'from'=>request('from'),
                        'to'=>request('to'),
                        'courier'=>request('courier')
                   ])); ?>">
                  Export
                </a>
                <button type="button" class="btn btn-info btn-sm print-btn">Print</button>
              </div>
            </form>
          </div>
        </div>

        
        <div class="row">
          <div class="col-sm-12">
            <div class="table-responsive">
              <?php $total = 0; ?>
              <table class="table table-sm align-middle table-hover mb-0">
                <thead class="table-light">
                  <tr>
                    <th class="nowrap" style="font-size:11px;">Order ID</th>
                    <th class="nowrap" style="font-size:11px;">Invoice No</th>
                    <th style="font-size:11px;">Customer</th>
                    <th class="nowrap" style="font-size:11px;">Phone</th>
                    <th style="font-size:11px;">Address</th>
                    <th style="font-size:11px;">Product</th>
                    <th class="nowrap" style="font-size:11px;">Qty</th>
                    <th style="font-size:11px;">Courier</th>
                    <th style="font-size:11px;">Courier ID</th>
                    <th style="font-size:11px;">Assigned To</th>
                    <th class="nowrap" style="font-size:11px;">Work Date</th>
                    <th class="nowrap" style="font-size:11px;">Total</th>
                  </tr>
                </thead>
                <tbody>
                  <?php $__empty_1 = true; $__currentLoopData = $details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <?php
                      $unit = $item->unit_price ?? 0;
                      $qty  = $item->quantity ?? 0;
                      $row_total = $unit * $qty;
                      $total += $row_total;

                      $order = $item->order;
                      $assignedUser = $order->assignUser ?? \App\Models\User::find($order->assign_user_id);
                      $workDate = $order->assigned_at ?? $order->updated_at ?? $order->created_at;
                      $workDateText = $workDate ? \Carbon\Carbon::parse($workDate)->format('Y-m-d') : '—';

                      $courierName = $order->courier->name ?? '—';
                      $productName = optional($item->product)->name ?? '—';
                    ?>
                    <tr>
                      <td class="nowrap" data-label="Order ID" style="font-size:11px;"><?php echo e($order->id); ?></td>
                      <td class="nowrap" data-label="Invoice No" style="font-size:11px;">
                        <a href="<?php echo e(route('admin.orders.show',$order->id)); ?>" target="_blank" style="color:#000;">#<?php echo e($order->invoice_no); ?></a>
                      </td>
                      <td data-label="Customer" style="font-size:11px;"><?php echo e($order->first_name); ?></td>
                      <td data-label="Phone" class="nowrap" style="font-size:11px;"><?php echo e($order->mobile); ?></td>
                      <td data-label="Address" style="font-size:11px;">
                        <span class="text-truncate-2" title="<?php echo e($order->shipping_address); ?>"><?php echo e($order->shipping_address); ?></span>
                      </td>
                      <td data-label="Product" style="font-size:11px;">
                        <span class="text-truncate-2" title="<?php echo e($productName); ?>"><?php echo e($productName); ?></span>
                      </td>
                      <td data-label="Quantity" class="nowrap" style="font-size:11px;"><?php echo e($qty); ?></td>
                      <td data-label="Courier" style="font-size:11px;"><?php echo e($courierName); ?></td>
                      <td data-label="Courier ID" style="font-size:11px;"><?php echo e($order->courier_tracking_id ?? '—'); ?></td>
                      <td data-label="Assigned To" style="font-size:11px;">
                        <?php echo e($assignedUser ? ($assignedUser->first_name.' '.$assignedUser->last_name) : '—'); ?>

                      </td>
                      <td data-label="Work Date" class="nowrap" style="font-size:11px;"><?php echo e($workDateText); ?></td>
                      <td data-label="Total" class="nowrap" style="font-size:11px;"><?php echo e(number_format($row_total,2)); ?></td>
                    </tr>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr><td colspan="12" class="text-center text-danger">No data found</td></tr>
                  <?php endif; ?>

                  <tr>
                    <td colspan="11" class="text-end"><h6 class="mb-0">Total Amount :</h6></td>
                    <td class="nowrap"><h6 class="text-danger mb-0"><?php echo e(number_format($total,2)); ?></h6></td>
                  </tr>
                </tbody>
              </table>
            </div>

            
            <div class="mt-2"><?php echo e($details->appends(request()->query())->links()); ?></div>
          </div>
        </div>

      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script>
  document.addEventListener('DOMContentLoaded', function(){
    document.querySelectorAll('.print-btn').forEach(btn=>{
      btn.addEventListener('click', ()=> window.print());
    });
  });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/deshitest/public_html/resources/views/backend/reports/order.blade.php ENDPATH**/ ?>